/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Service;
import org.apache.camel.StaticService;
import org.apache.camel.impl.engine.DefaultFallbackResourceResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.ResourceResolver;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class DefaultResourceLoader
extends ServiceSupport
implements ResourceLoader,
StaticService {
    public static final String RESOURCE_LOADER_KEY_PREFIX = "resource-loader-";
    private final Map<String, ResourceResolver> resolvers;
    private CamelContext camelContext;
    private ResourceResolver fallbackResolver;

    public DefaultResourceLoader() {
        this(null);
    }

    public DefaultResourceLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.resolvers = new ConcurrentHashMap<String, ResourceResolver>();
        this.fallbackResolver = null;
        if (camelContext != null) {
            this.fallbackResolver = (ResourceResolver)camelContext.getRegistry().lookupByNameAndType("fallback-resource-resolver", ResourceResolver.class);
        }
        if (this.fallbackResolver == null) {
            this.fallbackResolver = new DefaultFallbackResourceResolver(camelContext);
        }
        this.fallbackResolver.setCamelContext(camelContext);
    }

    public void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.fallbackResolver);
    }

    public void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object[])new Object[]{this.resolvers.values(), this.fallbackResolver});
        this.resolvers.clear();
    }

    public ResourceResolver getFallbackResolver() {
        return this.fallbackResolver;
    }

    public void setFallbackResolver(ResourceResolver fallbackResolver) {
        this.fallbackResolver = fallbackResolver;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.fallbackResolver.setCamelContext(this.camelContext);
    }

    public Resource resolveResource(String uri) {
        ObjectHelper.notNull((Object)uri, (String)"Resource uri must not be null");
        String scheme = StringHelper.before((String)uri, (String)":");
        if (scheme == null) {
            return this.fallbackResolver.resolve(uri);
        }
        ResourceResolver rr = this.getResourceResolver(scheme);
        if (rr == null) {
            throw new IllegalArgumentException("Cannot find a ResourceResolver in classpath supporting the scheme: " + scheme);
        }
        return rr.resolve(uri);
    }

    protected boolean hasResourceResolver(String scheme) {
        ResourceResolver answer = (ResourceResolver)this.getCamelContext().getRegistry().lookupByNameAndType(RESOURCE_LOADER_KEY_PREFIX + scheme, ResourceResolver.class);
        if (answer == null) {
            answer = this.resolvers.get(scheme);
        }
        return answer != null;
    }

    private ResourceResolver getResourceResolver(String scheme) {
        ResourceResolver answer = (ResourceResolver)this.getCamelContext().getRegistry().lookupByNameAndType(RESOURCE_LOADER_KEY_PREFIX + scheme, ResourceResolver.class);
        if (answer == null) {
            answer = this.resolvers.computeIfAbsent(scheme, this::resolveService);
        }
        return answer;
    }

    private ResourceResolver resolveService(String scheme) {
        FactoryFinder finder;
        CamelContext context = this.getCamelContext();
        ResourceResolver rr = ResolverHelper.resolveService((CamelContext)context, (FactoryFinder)(finder = context.getCamelContextExtension().getBootstrapFactoryFinder("META-INF/services/org/apache/camel/resource-resolver/")), (String)scheme, ResourceResolver.class).orElse(null);
        if (rr != null) {
            CamelContextAware.trySetCamelContext((Object)rr, (CamelContext)this.getCamelContext());
            ServiceHelper.startService((Service)rr);
        }
        return rr;
    }
}

