/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.PerformanceCounterEvaluator;

public final class RoutePerformanceCounterEvaluators {
    private RoutePerformanceCounterEvaluators() {
    }

    public static PerformanceCounterEvaluator<ManagedRouteMBean> exchangesFailed(long threshold) {
        return new ExchangesFailed(threshold);
    }

    public static PerformanceCounterEvaluator<ManagedRouteMBean> exchangesInflight(long threshold) {
        return new ExchangesInflight(threshold);
    }

    public static PerformanceCounterEvaluator<ManagedRouteMBean> redeliveries(long threshold) {
        return new Redeliveries(threshold);
    }

    public static PerformanceCounterEvaluator<ManagedRouteMBean> externalRedeliveries(long threshold) {
        return new ExternalRedeliveries(threshold);
    }

    public static PerformanceCounterEvaluator<ManagedRouteMBean> lastProcessingTime(long timeThreshold, int failuresThreshold) {
        return new LastProcessingTime(timeThreshold, failuresThreshold);
    }

    public static PerformanceCounterEvaluator<ManagedRouteMBean> minProcessingTime(long timeThreshold, int failuresThreshold) {
        return new MinProcessingTime(timeThreshold, failuresThreshold);
    }

    public static PerformanceCounterEvaluator<ManagedRouteMBean> meanProcessingTime(long timeThreshold, int failuresThreshold) {
        return new MeanProcessingTime(timeThreshold, failuresThreshold);
    }

    public static PerformanceCounterEvaluator<ManagedRouteMBean> maxProcessingTime(long timeThreshold, int failuresThreshold) {
        return new MaxProcessingTime(timeThreshold, failuresThreshold);
    }

    public static final class MaxProcessingTime
    implements PerformanceCounterEvaluator<ManagedRouteMBean> {
        private final long timeThreshold;
        private final int failuresThreshold;
        private final AtomicInteger failureCount = new AtomicInteger();

        public MaxProcessingTime(long timeThreshold, int failuresThreshold) {
            this.timeThreshold = timeThreshold;
            this.failuresThreshold = failuresThreshold;
        }

        @Override
        public void test(ManagedRouteMBean counter, HealthCheckResultBuilder builder, Map<String, Object> options) {
            try {
                long value = counter.getMaxProcessingTime();
                if (value > this.timeThreshold) {
                    int newFailureCount = this.failureCount.incrementAndGet();
                    if (newFailureCount > this.failuresThreshold) {
                        builder.down();
                    }
                } else {
                    this.failureCount.set(0);
                }
                builder.detail("exchanges.max-processing-time", (Object)value);
                builder.detail("exchanges.max-processing-time.threshold.time", (Object)this.timeThreshold);
                builder.detail("exchanges.max-processing-time.threshold.failures", (Object)this.failuresThreshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class MeanProcessingTime
    implements PerformanceCounterEvaluator<ManagedRouteMBean> {
        private final long timeThreshold;
        private final int failuresThreshold;
        private final AtomicInteger failureCount = new AtomicInteger();

        public MeanProcessingTime(long timeThreshold, int failuresThreshold) {
            this.timeThreshold = timeThreshold;
            this.failuresThreshold = failuresThreshold;
        }

        @Override
        public void test(ManagedRouteMBean counter, HealthCheckResultBuilder builder, Map<String, Object> options) {
            try {
                long value = counter.getMeanProcessingTime();
                if (value > this.timeThreshold) {
                    int newFailureCount = this.failureCount.incrementAndGet();
                    if (newFailureCount > this.failuresThreshold) {
                        builder.down();
                    }
                } else {
                    this.failureCount.set(0);
                }
                builder.detail("exchanges.mean-processing-time", (Object)value);
                builder.detail("exchanges.mean-processing-time.threshold.time", (Object)this.timeThreshold);
                builder.detail("exchanges.mean-processing-time.threshold.failures", (Object)this.failuresThreshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class MinProcessingTime
    implements PerformanceCounterEvaluator<ManagedRouteMBean> {
        private final long timeThreshold;
        private final int failuresThreshold;
        private final AtomicInteger failureCount = new AtomicInteger();

        public MinProcessingTime(long timeThreshold, int failuresThreshold) {
            this.timeThreshold = timeThreshold;
            this.failuresThreshold = failuresThreshold;
        }

        @Override
        public void test(ManagedRouteMBean counter, HealthCheckResultBuilder builder, Map<String, Object> options) {
            try {
                long value = counter.getMinProcessingTime();
                if (value > this.timeThreshold) {
                    int newFailureCount = this.failureCount.incrementAndGet();
                    if (newFailureCount > this.failuresThreshold) {
                        builder.down();
                    }
                } else {
                    this.failureCount.set(0);
                }
                builder.detail("exchanges.min-processing-time", (Object)value);
                builder.detail("exchanges.min-processing-time.threshold.time", (Object)this.timeThreshold);
                builder.detail("exchanges.min-processing-time.threshold.failures", (Object)this.failuresThreshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class LastProcessingTime
    implements PerformanceCounterEvaluator<ManagedRouteMBean> {
        private final long timeThreshold;
        private final int failuresThreshold;
        private final AtomicInteger failureCount = new AtomicInteger();

        public LastProcessingTime(long timeThreshold, int failuresThreshold) {
            this.timeThreshold = timeThreshold;
            this.failuresThreshold = failuresThreshold;
        }

        @Override
        public void test(ManagedRouteMBean counter, HealthCheckResultBuilder builder, Map<String, Object> options) {
            try {
                long value = counter.getLastProcessingTime();
                if (value > this.timeThreshold) {
                    int newFailureCount = this.failureCount.incrementAndGet();
                    if (newFailureCount > this.failuresThreshold) {
                        builder.down();
                    }
                } else {
                    this.failureCount.set(0);
                }
                builder.detail("exchanges.last-processing-time", (Object)value);
                builder.detail("exchanges.last-processing-time.threshold.time", (Object)this.timeThreshold);
                builder.detail("exchanges.last-processing-time.threshold.failures", (Object)this.failuresThreshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class ExternalRedeliveries
    implements PerformanceCounterEvaluator<ManagedRouteMBean> {
        private final long threshold;

        public ExternalRedeliveries(long threshold) {
            this.threshold = threshold;
        }

        @Override
        public void test(ManagedRouteMBean counter, HealthCheckResultBuilder builder, Map<String, Object> options) {
            try {
                long value = counter.getExternalRedeliveries();
                if (value > this.threshold) {
                    builder.down();
                }
                builder.detail("exchanges.external-redeliveries", (Object)value);
                builder.detail("exchanges.external-redeliveries.threshold", (Object)this.threshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class Redeliveries
    implements PerformanceCounterEvaluator<ManagedRouteMBean> {
        private final long threshold;

        public Redeliveries(long threshold) {
            this.threshold = threshold;
        }

        @Override
        public void test(ManagedRouteMBean counter, HealthCheckResultBuilder builder, Map<String, Object> options) {
            try {
                long value = counter.getRedeliveries();
                if (value > this.threshold) {
                    builder.down();
                }
                builder.detail("exchanges.redeliveries", (Object)value);
                builder.detail("exchanges.redeliveries.threshold", (Object)this.threshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class ExchangesInflight
    implements PerformanceCounterEvaluator<ManagedRouteMBean> {
        private final long threshold;

        public ExchangesInflight(long threshold) {
            this.threshold = threshold;
        }

        @Override
        public void test(ManagedRouteMBean counter, HealthCheckResultBuilder builder, Map<String, Object> options) {
            try {
                long value = counter.getExchangesInflight();
                if (value > this.threshold) {
                    builder.down();
                }
                builder.detail("exchanges.inflight", (Object)value);
                builder.detail("exchanges.inflight.threshold", (Object)this.threshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class ExchangesFailed
    implements PerformanceCounterEvaluator<ManagedRouteMBean> {
        private final long threshold;

        public ExchangesFailed(long threshold) {
            this.threshold = threshold;
        }

        @Override
        public void test(ManagedRouteMBean counter, HealthCheckResultBuilder builder, Map<String, Object> options) {
            try {
                long value = counter.getExchangesFailed();
                if (value > this.threshold) {
                    builder.down();
                }
                builder.detail("exchanges.failed", (Object)value);
                builder.detail("exchanges.failed.threshold", (Object)this.threshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

