/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.support.AsyncProcessorSupport;

public class EvaluateExpressionProcessor
extends AsyncProcessorSupport
implements Traceable {
    private final Expression expression;

    public EvaluateExpressionProcessor(Expression expression) {
        this.expression = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object result = this.expression.evaluate(exchange, Object.class);
            exchange.setProperty("CamelEvaluateExpressionResult", result);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    public String toString() {
        return "EvalExpression[" + this.expression + "]";
    }

    public String getTraceLabel() {
        return "eval[" + this.expression + "]";
    }
}

