/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiLanguageResolver
implements LanguageResolver {
    private static final transient Logger LOG = LoggerFactory.getLogger(OsgiLanguageResolver.class);
    private final BundleContext bundleContext;

    public OsgiLanguageResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Language resolveLanguage(String name, CamelContext context) {
        Object bean;
        block6: {
            bean = null;
            try {
                bean = context.getRegistry().lookup(name);
                if (bean != null) {
                    LOG.debug("Found language: {} in registry: {}", (Object)name, bean);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Ignored error looking up bean: " + name + ". Error: " + e);
            }
        }
        if (bean instanceof Language) {
            return (Language)bean;
        }
        Language lang = this.getLanguage(name, context);
        if (lang != null) {
            return lang;
        }
        LanguageResolver resolver = this.getLanguageResolver("default", context);
        if (resolver != null) {
            return resolver.resolveLanguage(name, context);
        }
        throw new NoSuchLanguageException(name);
    }

    protected Language getLanguage(String name, CamelContext context) {
        LOG.trace("Finding Language: {}", (Object)name);
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(LanguageResolver.class.getName(), "(language=" + name + ")");
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    Object service = this.bundleContext.getService(ref);
                    if (!LanguageResolver.class.isAssignableFrom(service.getClass())) continue;
                    LanguageResolver resolver = (LanguageResolver)service;
                    return resolver.resolveLanguage(name, context);
                }
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected LanguageResolver getLanguageResolver(String name, CamelContext context) {
        LOG.trace("Finding LanguageResolver: {}", (Object)name);
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(LanguageResolver.class.getName(), "(resolver=" + name + ")");
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    Object service = this.bundleContext.getService(ref);
                    if (!LanguageResolver.class.isAssignableFrom(service.getClass())) continue;
                    LanguageResolver resolver = (LanguageResolver)service;
                    return resolver;
                }
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

