/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cli.connector;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.cli.connector.LoggerHelper;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.spi.CliConnector;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.support.DefaultContextReloadStrategy;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCliConnector
extends ServiceSupport
implements CliConnector,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCliConnector.class);
    private final CliConnectorFactory cliConnectorFactory;
    private CamelContext camelContext;
    private int delay = 2000;
    private String platform;
    private String platformVersion;
    private String mainClass;
    private final AtomicBoolean terminating = new AtomicBoolean();
    private ScheduledExecutorService executor;
    private volatile ExecutorService terminateExecutor;
    private File lockFile;
    private File statusFile;
    private File actionFile;
    private File outputFile;

    public LocalCliConnector(CliConnectorFactory cliConnectorFactory) {
        this.cliConnectorFactory = cliConnectorFactory;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStart() throws Exception {
        this.terminating.set(false);
        this.mainClass = this.cliConnectorFactory.getRuntimeStartClass();
        if (this.mainClass == null) {
            this.mainClass = this.camelContext.getGlobalOption("CamelMainClass");
        }
        this.platform = this.cliConnectorFactory.getRuntime();
        if (this.platform == null) {
            String sn = this.camelContext.getClass().getSimpleName().toLowerCase(Locale.ROOT);
            this.platform = sn.contains("boot") ? "Spring Boot" : (sn.contains("spring") ? "Spring" : (sn.contains("quarkus") ? "Quarkus" : (sn.contains("osgi") ? "Karaf" : (sn.contains("cdi") ? "CDI" : (this.camelContext.getName().equals("CamelJBang") ? "JBang" : "Camel")))));
        }
        this.platformVersion = this.cliConnectorFactory.getRuntimeVersion();
        this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
            String threadName = ThreadHelper.resolveThreadName(null, (String)"LocalCliConnector");
            return new Thread(r, threadName);
        });
        this.lockFile = LocalCliConnector.createLockFile(LocalCliConnector.getPid());
        if (this.lockFile != null) {
            this.statusFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-status.json");
            this.actionFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-action.json");
            this.outputFile = LocalCliConnector.createLockFile(this.lockFile.getName() + "-output.json");
            this.executor.scheduleWithFixedDelay(this::task, 0L, this.delay, TimeUnit.MILLISECONDS);
            LOG.info("Camel CLI enabled (local)");
        } else {
            LOG.warn("Cannot create PID file: {}. This integration cannot be managed by Camel CLI.", (Object)LocalCliConnector.getPid());
        }
    }

    public void sigterm() {
        this.terminating.set(true);
        this.terminateExecutor = Executors.newSingleThreadExecutor(r -> {
            String threadName = ThreadHelper.resolveThreadName(null, (String)"Terminate JVM task");
            return new Thread(r, threadName);
        });
        this.terminateExecutor.submit(new Runnable(){

            @Override
            public void run() {
                LOG.info("Camel CLI terminating JVM");
                try {
                    LocalCliConnector.this.camelContext.stop();
                }
                finally {
                    ServiceHelper.stopAndShutdownService((Object)this);
                }
            }
        });
    }

    protected void task() {
        if (!this.lockFile.exists() && this.terminating.compareAndSet(false, true)) {
            this.sigterm();
            return;
        }
        if (!this.statusFile.exists()) {
            return;
        }
        this.actionTask();
        this.statusTask();
    }

    protected void actionTask() {
        try {
            DevConsole dc;
            String action;
            JsonObject root = this.loadAction();
            if (root == null || root.isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action: {}", (Object)root);
            }
            if ("route".equals(action = root.getString("action"))) {
                String[] patterns = root.getString("id").split(",");
                List ids = this.camelContext.getRoutes().stream().map(Route::getRouteId).filter(routeId -> {
                    for (String p : patterns) {
                        if (!PatternHelper.matchPattern((String)routeId, (String)p)) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                for (String id : ids) {
                    try {
                        String command = root.getString("command");
                        if ("start".equals(command)) {
                            if ("*".equals(id)) {
                                this.camelContext.getRouteController().startAllRoutes();
                                continue;
                            }
                            this.camelContext.getRouteController().startRoute(id);
                            continue;
                        }
                        if ("stop".equals(command)) {
                            if ("*".equals(id)) {
                                this.camelContext.getRouteController().stopAllRoutes();
                                continue;
                            }
                            this.camelContext.getRouteController().stopRoute(id);
                            continue;
                        }
                        if ("suspend".equals(command)) {
                            this.camelContext.getRouteController().suspendRoute(id);
                            continue;
                        }
                        if (!"resume".equals(command)) continue;
                        this.camelContext.getRouteController().resumeRoute(id);
                    }
                    catch (Exception exception) {}
                }
            } else if ("logger".equals(action)) {
                try {
                    String command = root.getString("command");
                    if ("set-logging-level".equals(command)) {
                        String logger = root.getString("logger-name");
                        String level = root.getString("logging-level");
                        LoggerHelper.changeLoggingLevel(logger, level);
                    }
                }
                catch (Exception command) {}
            } else if ("gc".equals(action)) {
                System.gc();
            } else if ("reload".equals(action)) {
                ContextReloadStrategy reloader = (ContextReloadStrategy)this.camelContext.hasService(ContextReloadStrategy.class);
                if (reloader == null) {
                    reloader = new DefaultContextReloadStrategy();
                    this.camelContext.addService((Object)reloader);
                }
                reloader.onReload((Object)"Camel CLI");
            } else if ("reset-stats".equals(action)) {
                ManagedCamelContext mcc = (ManagedCamelContext)this.camelContext.getExtension(ManagedCamelContext.class);
                if (mcc != null) {
                    mcc.getManagedCamelContext().reset(true);
                }
            } else if ("thread-dump".equals(action)) {
                DevConsole dc2 = ((DevConsoleRegistry)this.camelContext.getExtension(DevConsoleRegistry.class)).resolveById("thread");
                if (dc2 != null) {
                    JsonObject json = (JsonObject)dc2.call(DevConsole.MediaType.JSON, Map.of("stackTrace", "true"));
                    LOG.trace("Updating output file: {}", (Object)this.outputFile);
                    IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
                }
            } else if ("top-processors".equals(action)) {
                DevConsole dc3 = ((DevConsoleRegistry)this.camelContext.getExtension(DevConsoleRegistry.class)).resolveById("top");
                if (dc3 != null) {
                    JsonObject json = (JsonObject)dc3.call(DevConsole.MediaType.JSON, Map.of("CamelHttpPath", "/*"));
                    LOG.trace("Updating output file: {}", (Object)this.outputFile);
                    IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
                }
            } else if ("source".equals(action)) {
                DevConsole dc4 = ((DevConsoleRegistry)this.camelContext.getExtension(DevConsoleRegistry.class)).resolveById("source");
                if (dc4 != null) {
                    String filter = root.getString("filter");
                    JsonObject json = (JsonObject)dc4.call(DevConsole.MediaType.JSON, Map.of("filter", filter));
                    LOG.trace("Updating output file: {}", (Object)this.outputFile);
                    IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
                }
            } else if ("route-controller".equals(action) && (dc = ((DevConsoleRegistry)this.camelContext.getExtension(DevConsoleRegistry.class)).resolveById("route-controller")) != null) {
                String stacktrace = root.getString("stacktrace");
                JsonObject json = (JsonObject)dc.call(DevConsole.MediaType.JSON, Map.of("stacktrace", stacktrace));
                LOG.trace("Updating output file: {}", (Object)this.outputFile);
                IOHelper.writeText((String)json.toJson(), (File)this.outputFile);
            }
            FileUtil.deleteFile((File)this.actionFile);
        }
        catch (Throwable e) {
            LOG.debug("Error executing action file: " + this.actionFile + " due to: " + e.getMessage() + ". This exception is ignored.", e);
        }
    }

    JsonObject loadAction() {
        try {
            if (this.actionFile != null && this.actionFile.exists()) {
                FileInputStream fis = new FileInputStream(this.actionFile);
                String text = IOHelper.loadText((InputStream)fis);
                IOHelper.close((Closeable)fis);
                if (!text.isEmpty()) {
                    return (JsonObject)Jsoner.deserialize((String)text);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void statusTask() {
        try {
            JsonObject vaults;
            JsonObject gc;
            JsonObject threads;
            JsonObject cl;
            JsonObject mem;
            JsonObject services;
            RuntimeMXBean mb;
            JsonObject root = new JsonObject();
            JsonObject rc = new JsonObject();
            String dir = new File(".").getAbsolutePath();
            dir = FileUtil.onlyPath((String)dir);
            rc.put((Object)"pid", (Object)ProcessHandle.current().pid());
            rc.put((Object)"directory", (Object)dir);
            ProcessHandle.current().info().user().ifPresent(u -> rc.put((Object)"user", u));
            rc.put((Object)"platform", (Object)this.platform);
            if (this.platformVersion != null) {
                rc.put((Object)"platformVersion", (Object)this.platformVersion);
            }
            if (this.mainClass != null) {
                rc.put((Object)"mainClass", (Object)this.mainClass);
            }
            if ((mb = ManagementFactory.getRuntimeMXBean()) != null) {
                rc.put((Object)"javaVersion", (Object)mb.getVmVersion());
            }
            root.put((Object)"runtime", (Object)rc);
            DevConsoleRegistry dcr = (DevConsoleRegistry)this.camelContext.getExtension(DevConsoleRegistry.class);
            if (dcr != null) {
                JsonObject json;
                DevConsole dc11;
                JsonObject json2;
                DevConsole dc10;
                JsonObject json3;
                DevConsole dc9;
                JsonObject json4;
                DevConsole dc8;
                JsonObject json5;
                DevConsole dc7;
                JsonObject json6;
                DevConsole dc6;
                JsonObject json7;
                DevConsole dc5;
                JsonObject json8;
                DevConsole dc4;
                JsonObject json9;
                DevConsole dc3;
                DevConsole dc = dcr.resolveById("context");
                DevConsole dc2 = dcr.resolveById("route");
                if (dc != null && dc2 != null) {
                    JsonObject json10 = (JsonObject)dc.call(DevConsole.MediaType.JSON);
                    JsonObject json22 = (JsonObject)dc2.call(DevConsole.MediaType.JSON, Map.of("processors", "true"));
                    if (json10 != null && json22 != null) {
                        root.put((Object)"context", (Object)json10);
                        root.put((Object)"routes", json22.get((Object)"routes"));
                    }
                }
                if ((dc3 = dcr.resolveById("endpoint")) != null && (json9 = (JsonObject)dc3.call(DevConsole.MediaType.JSON)) != null && !json9.isEmpty()) {
                    root.put((Object)"endpoints", (Object)json9);
                }
                if ((dc4 = dcr.resolveById("health")) != null && (json8 = (JsonObject)dc4.call(DevConsole.MediaType.JSON, Map.of("exposureLevel", "full"))) != null && !json8.isEmpty()) {
                    root.put((Object)"healthChecks", (Object)json8);
                }
                if ((dc5 = dcr.resolveById("event")) != null && (json7 = (JsonObject)dc5.call(DevConsole.MediaType.JSON)) != null && !json7.isEmpty()) {
                    root.put((Object)"events", (Object)json7);
                }
                if ((dc6 = dcr.resolveById("log")) != null && (json6 = (JsonObject)dc6.call(DevConsole.MediaType.JSON)) != null && !json6.isEmpty()) {
                    root.put((Object)"logger", (Object)json6);
                }
                if ((dc7 = dcr.resolveById("inflight")) != null && (json5 = (JsonObject)dc7.call(DevConsole.MediaType.JSON)) != null && !json5.isEmpty()) {
                    root.put((Object)"inflight", (Object)json5);
                }
                if ((dc8 = dcr.resolveById("blocked")) != null && (json4 = (JsonObject)dc8.call(DevConsole.MediaType.JSON)) != null && !json4.isEmpty()) {
                    root.put((Object)"blocked", (Object)json4);
                }
                if ((dc9 = dcr.resolveById("micrometer")) != null && (json3 = (JsonObject)dc9.call(DevConsole.MediaType.JSON)) != null && !json3.isEmpty()) {
                    root.put((Object)"micrometer", (Object)json3);
                }
                if ((dc10 = dcr.resolveById("resilience4j")) != null && (json2 = (JsonObject)dc10.call(DevConsole.MediaType.JSON)) != null && !json2.isEmpty()) {
                    root.put((Object)"resilience4j", (Object)json2);
                }
                if ((dc11 = dcr.resolveById("fault-tolerance")) != null && (json = (JsonObject)dc11.call(DevConsole.MediaType.JSON)) != null && !json.isEmpty()) {
                    root.put((Object)"fault-tolerance", (Object)json);
                }
            }
            if (!(services = this.collectServices()).isEmpty()) {
                root.put((Object)"services", (Object)services);
            }
            if ((mem = this.collectMemory()) != null) {
                root.put((Object)"memory", (Object)mem);
            }
            if ((cl = this.collectClassLoading()) != null) {
                root.put((Object)"classLoading", (Object)cl);
            }
            if ((threads = this.collectThreads()) != null) {
                root.put((Object)"threads", (Object)threads);
            }
            if ((gc = this.collectGC()) != null) {
                root.put((Object)"gc", (Object)gc);
            }
            if (!(vaults = this.collectVaults()).isEmpty()) {
                root.put((Object)"vaults", (Object)vaults);
            }
            LOG.trace("Updating status file: {}", (Object)this.statusFile);
            IOHelper.writeText((String)root.toJson(), (File)this.statusFile);
        }
        catch (Throwable e) {
            LOG.trace("Error updating status file: " + this.statusFile + " due to: " + e.getMessage() + ". This exception is ignored.", e);
        }
    }

    private JsonObject collectMemory() {
        MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
        if (mb != null) {
            JsonObject root = new JsonObject();
            root.put((Object)"heapMemoryUsed", (Object)mb.getHeapMemoryUsage().getUsed());
            root.put((Object)"heapMemoryCommitted", (Object)mb.getHeapMemoryUsage().getCommitted());
            root.put((Object)"heapMemoryMax", (Object)mb.getHeapMemoryUsage().getMax());
            root.put((Object)"nonHeapMemoryUsed", (Object)mb.getNonHeapMemoryUsage().getUsed());
            root.put((Object)"nonHeapMemoryCommitted", (Object)mb.getNonHeapMemoryUsage().getCommitted());
            return root;
        }
        return null;
    }

    private JsonObject collectClassLoading() {
        ClassLoadingMXBean cb = ManagementFactory.getClassLoadingMXBean();
        if (cb != null) {
            JsonObject root = new JsonObject();
            root.put((Object)"loadedClassCount", (Object)cb.getLoadedClassCount());
            root.put((Object)"unloadedClassCount", (Object)cb.getUnloadedClassCount());
            root.put((Object)"totalLoadedClassCount", (Object)cb.getTotalLoadedClassCount());
            return root;
        }
        return null;
    }

    private JsonObject collectThreads() {
        ThreadMXBean tb = ManagementFactory.getThreadMXBean();
        if (tb != null) {
            JsonObject root = new JsonObject();
            root.put((Object)"threadCount", (Object)tb.getThreadCount());
            root.put((Object)"peakThreadCount", (Object)tb.getPeakThreadCount());
            return root;
        }
        return null;
    }

    private JsonObject collectGC() {
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        if (gcs != null && !gcs.isEmpty()) {
            JsonObject root = new JsonObject();
            long count = 0L;
            long time = 0L;
            for (GarbageCollectorMXBean gc : gcs) {
                count += gc.getCollectionCount();
                time += gc.getCollectionTime();
            }
            root.put((Object)"collectionCount", (Object)count);
            root.put((Object)"collectionTime", (Object)time);
            return root;
        }
        return null;
    }

    private JsonObject collectVaults() {
        JsonObject json;
        Optional dcAzure;
        JsonObject json2;
        Optional dcGcp;
        JsonObject json3;
        JsonObject root = new JsonObject();
        Optional dcAws = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDevConsoleResolver().lookupDevConsole("aws-secrets");
        if (dcAws.isPresent() && (json3 = (JsonObject)((DevConsole)dcAws.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"aws-secrets", (Object)json3);
        }
        if ((dcGcp = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDevConsoleResolver().lookupDevConsole("gcp-secrets")).isPresent() && (json2 = (JsonObject)((DevConsole)dcGcp.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"gcp-secrets", (Object)json2);
        }
        if ((dcAzure = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDevConsoleResolver().lookupDevConsole("azure-secrets")).isPresent() && (json = (JsonObject)((DevConsole)dcAzure.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"azure-secrets", (Object)json);
        }
        return root;
    }

    private JsonObject collectServices() {
        JsonObject json;
        Optional dc;
        JsonObject root = new JsonObject();
        if (this.camelContext.hasComponent("platform-http") != null && (dc = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDevConsoleResolver().lookupDevConsole("platform-http")).isPresent() && (json = (JsonObject)((DevConsole)dc.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"platform-http", (Object)json);
        }
        if ((dc = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDevConsoleResolver().lookupDevConsole("netty")).isPresent() && (json = (JsonObject)((DevConsole)dc.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"netty", (Object)json);
        }
        if ((dc = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDevConsoleResolver().lookupDevConsole("mina")).isPresent() && (json = (JsonObject)((DevConsole)dc.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"mina", (Object)json);
        }
        if ((dc = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDevConsoleResolver().lookupDevConsole("mllp")).isPresent() && (json = (JsonObject)((DevConsole)dc.get()).call(DevConsole.MediaType.JSON)) != null) {
            root.put((Object)"mllp", (Object)json);
        }
        return root;
    }

    protected void doStop() throws Exception {
        if (this.lockFile != null) {
            FileUtil.deleteFile((File)this.lockFile);
        }
        if (this.statusFile != null) {
            FileUtil.deleteFile((File)this.statusFile);
        }
        if (this.actionFile != null) {
            FileUtil.deleteFile((File)this.actionFile);
        }
        if (this.outputFile != null) {
            FileUtil.deleteFile((File)this.outputFile);
        }
        if (this.executor != null) {
            this.camelContext.getExecutorServiceManager().shutdown((ExecutorService)this.executor);
            this.executor = null;
        }
    }

    private static String getPid() {
        try {
            return "" + ProcessHandle.current().pid();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static File createLockFile(String name) {
        File answer = null;
        if (name != null) {
            File dir = new File(System.getProperty("user.home"), ".camel");
            try {
                dir.mkdirs();
                answer = new File(dir, name);
                if (!answer.exists()) {
                    answer.createNewFile();
                }
                answer.deleteOnExit();
            }
            catch (Exception e) {
                answer = null;
            }
        }
        return answer;
    }
}

