/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cli.connector;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class LoggerHelper {
    private static final String LOG4J_MBEAN = "org.apache.logging.log4j2";

    private LoggerHelper() {
    }

    public static void changeLoggingLevel(String logger, String level) {
        if (logger == null || logger.isEmpty()) {
            logger = "root";
        }
        try {
            MBeanServer ms = ManagementFactory.getPlatformMBeanServer();
            if (ms != null) {
                Set<ObjectName> set = ms.queryNames(new ObjectName("org.apache.logging.log4j2:type=*,component=Loggers,name=*"), null);
                for (ObjectName on : set) {
                    if (!ms.isRegistered(on)) continue;
                    String name = (String)ms.getAttribute(on, "Name");
                    if (name == null || name.isEmpty()) {
                        name = "root";
                    }
                    if (!logger.equals(name)) continue;
                    ms.setAttribute(on, new Attribute("Level", level));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

