/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.cloud.ServiceChooser;
import org.apache.camel.cloud.ServiceChooserAware;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryAware;
import org.apache.camel.cloud.ServiceExpressionFactory;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.cloud.ServiceFilterAware;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.impl.cloud.DefaultServiceCallExpression;
import org.apache.camel.impl.cloud.DefaultServiceCallProcessor;
import org.apache.camel.impl.cloud.DefaultServiceLoadBalancer;
import org.apache.camel.impl.cloud.HealthyServiceFilter;
import org.apache.camel.impl.cloud.PassThroughServiceFilter;
import org.apache.camel.impl.cloud.RandomServiceChooser;
import org.apache.camel.impl.cloud.RoundRobinServiceChooser;
import org.apache.camel.impl.engine.TypedProcessorFactory;
import org.apache.camel.model.Model;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;
import org.apache.camel.util.function.ThrowingHelper;
import org.apache.camel.util.function.ThrowingSupplier;

public class ServiceCallProcessorFactory
extends TypedProcessorFactory<ServiceCallDefinition> {
    private volatile ServiceCallDefinition definition;

    public ServiceCallProcessorFactory() {
        super(ServiceCallDefinition.class);
    }

    public Processor doCreateProcessor(RouteContext routeContext, ServiceCallDefinition definition) throws Exception {
        ServiceCallConfigurationDefinition conf;
        String endpointUri;
        ServiceCallConfigurationDefinition conf2;
        String endpointScheme;
        this.definition = definition;
        CamelContext camelContext = routeContext.getCamelContext();
        ServiceDiscovery serviceDiscovery = this.retrieveServiceDiscovery(camelContext);
        ServiceFilter serviceFilter = this.retrieveServiceFilter(camelContext);
        ServiceChooser serviceChooser = this.retrieveServiceChooser(camelContext);
        ServiceLoadBalancer loadBalancer = this.retrieveLoadBalancer(camelContext);
        CamelContextAware.trySetCamelContext((Object)serviceDiscovery, (CamelContext)camelContext);
        CamelContextAware.trySetCamelContext((Object)serviceFilter, (CamelContext)camelContext);
        CamelContextAware.trySetCamelContext((Object)serviceChooser, (CamelContext)camelContext);
        CamelContextAware.trySetCamelContext((Object)loadBalancer, (CamelContext)camelContext);
        if (loadBalancer instanceof ServiceDiscoveryAware) {
            ((ServiceDiscoveryAware)loadBalancer).setServiceDiscovery(serviceDiscovery);
        }
        if (loadBalancer instanceof ServiceFilterAware) {
            ((ServiceFilterAware)loadBalancer).setServiceFilter(serviceFilter);
        }
        if (loadBalancer instanceof ServiceChooserAware) {
            ((ServiceChooserAware)loadBalancer).setServiceChooser(serviceChooser);
        }
        if ((endpointScheme = definition.getComponent()) == null && (conf2 = this.retrieveConfig(camelContext)) != null) {
            endpointScheme = conf2.getComponent();
        }
        if (endpointScheme == null && (conf2 = this.retrieveDefaultConfig(camelContext)) != null) {
            endpointScheme = conf2.getComponent();
        }
        if ((endpointUri = definition.getUri()) == null && (conf = this.retrieveConfig(camelContext)) != null) {
            endpointUri = conf.getUri();
        }
        if (endpointUri == null && (conf = this.retrieveDefaultConfig(camelContext)) != null) {
            endpointUri = conf.getUri();
        }
        ObjectHelper.notNull((Object)definition.getName(), (String)"Service name");
        endpointScheme = (String)ThrowingHelper.applyIfNotEmpty((Object)endpointScheme, arg_0 -> ((CamelContext)camelContext).resolvePropertyPlaceholders(arg_0), () -> "http");
        endpointUri = (String)ThrowingHelper.applyIfNotEmpty((Object)endpointUri, arg_0 -> ((CamelContext)camelContext).resolvePropertyPlaceholders(arg_0), () -> null);
        return new DefaultServiceCallProcessor(camelContext, camelContext.resolvePropertyPlaceholders(definition.getName()), endpointScheme, endpointUri, definition.getPattern(), loadBalancer, this.retrieveExpression(camelContext, endpointScheme));
    }

    private ServiceCallConfigurationDefinition retrieveDefaultConfig(CamelContext camelContext) {
        ServiceCallConfigurationDefinition config = ((Model)camelContext.getExtension(Model.class)).getServiceCallConfiguration(null);
        if (config == null) {
            config = (ServiceCallConfigurationDefinition)CamelContextHelper.lookup((CamelContext)camelContext, (String)"service-call-configuration", ServiceCallConfigurationDefinition.class);
        }
        if (config == null) {
            config = (ServiceCallConfigurationDefinition)CamelContextHelper.findByType((CamelContext)camelContext, ServiceCallConfigurationDefinition.class);
        }
        return config;
    }

    private ServiceCallConfigurationDefinition retrieveConfig(CamelContext camelContext) {
        ServiceCallConfigurationDefinition config = null;
        if (this.definition.getConfigurationRef() != null && (config = (ServiceCallConfigurationDefinition)CamelContextHelper.lookup((CamelContext)camelContext, (String)this.definition.getConfigurationRef(), ServiceCallConfigurationDefinition.class)) == null) {
            config = ((Model)camelContext.getExtension(Model.class)).getServiceCallConfiguration(this.definition.getConfigurationRef());
        }
        return config;
    }

    private ServiceDiscovery retrieveServiceDiscovery(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceDiscovery answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getServiceDiscoveryConfiguration() != null ? config.getServiceDiscoveryConfiguration().newInstance(camelContext) : this.retrieve(ServiceDiscovery.class, camelContext, () -> ((ServiceCallConfigurationDefinition)config).getServiceDiscovery(), () -> ((ServiceCallConfigurationDefinition)config).getServiceDiscoveryRef());
        }
        return answer;
    }

    private ServiceDiscovery retrieveServiceDiscovery(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> this.definition.getServiceDiscoveryConfiguration() != null ? this.definition.getServiceDiscoveryConfiguration().newInstance(camelContext) : null, () -> this.retrieve(ServiceDiscovery.class, camelContext, () -> ((ServiceCallDefinition)this.definition).getServiceDiscovery(), () -> ((ServiceCallDefinition)this.definition).getServiceDiscoveryRef()), () -> this.retrieveServiceDiscovery(camelContext, this::retrieveConfig), () -> this.retrieveServiceDiscovery(camelContext, this::retrieveDefaultConfig), () -> (ServiceDiscovery)CamelContextHelper.findByType((CamelContext)camelContext, ServiceDiscovery.class), () -> (ServiceDiscovery)CamelContextHelper.lookup((CamelContext)camelContext, (String)"service-discovery", ServiceDiscovery.class)}).orElseGet(() -> null);
    }

    private ServiceFilter retrieveServiceFilter(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceFilter answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null && (answer = config.getServiceFilterConfiguration() != null ? config.getServiceFilterConfiguration().newInstance(camelContext) : this.retrieve(ServiceFilter.class, camelContext, () -> ((ServiceCallConfigurationDefinition)config).getServiceFilter(), () -> ((ServiceCallConfigurationDefinition)config).getServiceFilterRef())) == null) {
            String ref = config.getServiceFilterRef();
            if (ObjectHelper.equal((Object)"healthy", (Object)ref, (boolean)true)) {
                answer = new HealthyServiceFilter();
            } else if (ObjectHelper.equal((Object)"pass-through", (Object)ref, (boolean)true)) {
                answer = new PassThroughServiceFilter();
            } else if (ObjectHelper.equal((Object)"passthrough", (Object)ref, (boolean)true)) {
                answer = new PassThroughServiceFilter();
            }
        }
        return answer;
    }

    private ServiceFilter retrieveServiceFilter(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> this.definition.getServiceFilterConfiguration() != null ? this.definition.getServiceFilterConfiguration().newInstance(camelContext) : null, () -> this.retrieve(ServiceFilter.class, camelContext, () -> ((ServiceCallDefinition)this.definition).getServiceFilter(), () -> ((ServiceCallDefinition)this.definition).getServiceFilterRef()), () -> this.retrieveServiceFilter(camelContext, this::retrieveConfig), () -> this.retrieveServiceFilter(camelContext, this::retrieveDefaultConfig), () -> (ServiceFilter)CamelContextHelper.findByType((CamelContext)camelContext, ServiceFilter.class), () -> (ServiceFilter)CamelContextHelper.lookup((CamelContext)camelContext, (String)"service-filter", ServiceFilter.class)}).orElseGet(() -> new HealthyServiceFilter());
    }

    private ServiceChooser retrieveServiceChooser(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceChooser answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = this.retrieve(ServiceChooser.class, camelContext, () -> ((ServiceCallConfigurationDefinition)config).getServiceChooser(), () -> ((ServiceCallConfigurationDefinition)config).getServiceChooserRef());
            if (answer == null) {
                String ref = config.getServiceChooserRef();
                if (ObjectHelper.equal((Object)"roundrobin", (Object)ref, (boolean)true)) {
                    answer = new RoundRobinServiceChooser();
                } else if (ObjectHelper.equal((Object)"round-robin", (Object)ref, (boolean)true)) {
                    answer = new RoundRobinServiceChooser();
                } else if (ObjectHelper.equal((Object)"random", (Object)ref, (boolean)true)) {
                    answer = new RandomServiceChooser();
                }
            }
        }
        return answer;
    }

    private ServiceChooser retrieveServiceChooser(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> this.retrieve(ServiceChooser.class, camelContext, () -> ((ServiceCallDefinition)this.definition).getServiceChooser(), () -> ((ServiceCallDefinition)this.definition).getServiceChooserRef()), () -> this.retrieveServiceChooser(camelContext, this::retrieveConfig), () -> this.retrieveServiceChooser(camelContext, this::retrieveDefaultConfig), () -> (ServiceChooser)CamelContextHelper.findByType((CamelContext)camelContext, ServiceChooser.class), () -> (ServiceChooser)CamelContextHelper.lookup((CamelContext)camelContext, (String)"service-chooser", ServiceChooser.class)}).orElseGet(() -> new RoundRobinServiceChooser());
    }

    private ServiceLoadBalancer retrieveLoadBalancer(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        ServiceLoadBalancer answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getLoadBalancerConfiguration() != null ? config.getLoadBalancerConfiguration().newInstance(camelContext) : this.retrieve(ServiceLoadBalancer.class, camelContext, () -> ((ServiceCallConfigurationDefinition)config).getLoadBalancer(), () -> ((ServiceCallConfigurationDefinition)config).getLoadBalancerRef());
        }
        return answer;
    }

    private ServiceLoadBalancer retrieveLoadBalancer(CamelContext camelContext) throws Exception {
        return Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> this.definition.getLoadBalancerConfiguration() != null ? this.definition.getLoadBalancerConfiguration().newInstance(camelContext) : null, () -> this.retrieve(ServiceLoadBalancer.class, camelContext, () -> ((ServiceCallDefinition)this.definition).getLoadBalancer(), () -> ((ServiceCallDefinition)this.definition).getLoadBalancerRef()), () -> this.retrieveLoadBalancer(camelContext, this::retrieveConfig), () -> this.retrieveLoadBalancer(camelContext, this::retrieveDefaultConfig), () -> (ServiceLoadBalancer)CamelContextHelper.findByType((CamelContext)camelContext, ServiceLoadBalancer.class), () -> (ServiceLoadBalancer)CamelContextHelper.lookup((CamelContext)camelContext, (String)"load-balancer", ServiceLoadBalancer.class)}).orElseGet(() -> new DefaultServiceLoadBalancer());
    }

    private Expression retrieveExpression(CamelContext camelContext, Function<CamelContext, ServiceCallConfigurationDefinition> function) throws Exception {
        Expression answer = null;
        ServiceCallConfigurationDefinition config = function.apply(camelContext);
        if (config != null) {
            answer = config.getExpressionConfiguration() != null ? config.getExpressionConfiguration().newInstance(camelContext) : this.retrieve(Expression.class, camelContext, () -> ((ServiceCallConfigurationDefinition)config).getExpression(), () -> ((ServiceCallConfigurationDefinition)config).getExpressionRef());
        }
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression retrieveExpression(CamelContext camelContext, String component) throws Exception {
        Optional expression = Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> this.definition.getExpressionConfiguration() != null ? this.definition.getExpressionConfiguration().newInstance(camelContext) : null, () -> this.retrieve(Expression.class, camelContext, () -> ((ServiceCallDefinition)this.definition).getExpression(), () -> ((ServiceCallDefinition)this.definition).getExpressionRef()), () -> this.retrieveExpression(camelContext, this::retrieveConfig), () -> this.retrieveExpression(camelContext, this::retrieveDefaultConfig), () -> (Expression)CamelContextHelper.lookup((CamelContext)camelContext, (String)"service-call-expression", Expression.class)});
        if (expression.isPresent()) {
            return (Expression)expression.get();
        }
        String lookupName = component + "-service-expression";
        ServiceExpressionFactory factory = (ServiceExpressionFactory)CamelContextHelper.lookup((CamelContext)camelContext, (String)lookupName, ServiceExpressionFactory.class);
        if (factory != null) {
            return (Expression)factory.newInstance(camelContext);
        }
        Class type = null;
        try {
            type = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(lookupName).orElse(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ObjectHelper.isNotEmpty(type)) {
            if (!ServiceExpressionFactory.class.isAssignableFrom(type)) throw new IllegalArgumentException("Resolving Expression: " + lookupName + " detected type conflict: Not a ServiceExpressionFactory implementation. Found: " + type.getName());
            factory = (ServiceExpressionFactory)camelContext.getInjector().newInstance(type, false);
            return (Expression)factory.newInstance(camelContext);
        } else {
            factory = context -> new DefaultServiceCallExpression();
        }
        return (Expression)factory.newInstance(camelContext);
    }

    private <T> T retrieve(Class<T> type, CamelContext camelContext, Supplier<T> instanceSupplier, Supplier<String> refSupplier) {
        String ref;
        Object answer = null;
        if (instanceSupplier != null) {
            answer = instanceSupplier.get();
        }
        if (answer == null && refSupplier != null && (ref = refSupplier.get()) != null) {
            answer = CamelContextHelper.lookup((CamelContext)camelContext, (String)ref, type);
        }
        return (T)answer;
    }
}

