/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.crypto.CryptoOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.jsse.KeyStoreParameters;

@UriParams
public class DigitalSignatureConfiguration
implements Cloneable,
CamelContextAware {
    private CamelContext context;
    @UriPath
    @Metadata(required=true)
    private CryptoOperation cryptoOperation;
    @UriPath
    @Metadata(required=true)
    private String name;
    @UriParam(secret=true)
    private PrivateKey privateKey;
    @UriParam(label="advanced")
    private KeyStoreParameters keyStoreParameters;
    @UriParam
    private KeyStore keystore;
    @UriParam(label="advanced", secret=true)
    private SecureRandom secureRandom;
    @UriParam(defaultValue="SHA256withRSA")
    private String algorithm = "SHA256withRSA";
    @UriParam(label="advanced", defaultValue="2048")
    private Integer bufferSize = 2048;
    @UriParam
    private String provider;
    @UriParam
    private String signatureHeaderName;
    @UriParam
    private String alias;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="advanced")
    private PublicKey publicKey;
    @UriParam(label="advanced")
    private Certificate certificate;
    @UriParam
    private String publicKeyName;
    @UriParam
    private String certificateName;
    @UriParam(secret=true)
    private String privateKeyName;
    @UriParam
    private String keystoreName;
    @UriParam
    private String secureRandomName;
    @UriParam(label="advanced", defaultValue="true")
    private boolean clearHeaders = true;

    public DigitalSignatureConfiguration copy() {
        try {
            return (DigitalSignatureConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
        this.setKeystoreName(this.keystoreName);
        this.setPublicKeyName(this.publicKeyName);
        this.setPrivateKeyName(this.privateKeyName);
        this.setCertificateName(this.certificateName);
        this.setSecureRandomName(this.secureRandomName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public PrivateKey getPrivateKey() {
        return this.getPrivateKey(this.alias, this.password.toCharArray());
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.getPrivateKey(alias, this.password.toCharArray());
    }

    public PrivateKey getPrivateKey(String alias, char[] password) {
        PrivateKey pk = null;
        if (alias != null && this.keystore != null) {
            try {
                pk = (PrivateKey)this.keystore.getKey(alias, password);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        if (pk == null) {
            pk = this.privateKey;
        }
        return pk;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyName() {
        return this.privateKeyName;
    }

    public void setPrivateKeyName(String privateKeyName) {
        PrivateKey pk;
        if (this.context != null && privateKeyName != null && (pk = (PrivateKey)this.context.getRegistry().lookupByNameAndType(privateKeyName, PrivateKey.class)) != null) {
            this.setPrivateKey(pk);
        }
        if (privateKeyName != null) {
            this.privateKeyName = privateKeyName;
        }
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public String getPublicKeyName() {
        return this.publicKeyName;
    }

    public void setPublicKeyName(String publicKeyName) {
        PublicKey pk;
        if (this.context != null && publicKeyName != null && (pk = (PublicKey)this.context.getRegistry().lookupByNameAndType(publicKeyName, PublicKey.class)) != null) {
            this.setPublicKey(pk);
        }
        if (publicKeyName != null) {
            this.publicKeyName = publicKeyName;
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Certificate getCertificate(String alias) throws Exception {
        Certificate cert = null;
        if (alias != null && this.keystore != null) {
            cert = this.keystore.getCertificate(alias);
        }
        if (cert == null) {
            cert = this.certificate;
        }
        return cert;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public void setCertificateName(String certificateName) {
        Certificate certificate;
        if (this.context != null && certificateName != null && (certificate = (Certificate)this.context.getRegistry().lookupByNameAndType(certificateName, Certificate.class)) != null) {
            this.setCertificate(certificate);
        }
        if (certificateName != null) {
            this.certificateName = certificateName;
        }
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeyStore keystore) {
        this.keystore = keystore;
    }

    public String getKeystoreName() {
        return this.keystoreName;
    }

    public void setKeystoreName(String keystoreName) {
        KeyStore keystore;
        if (this.context != null && keystoreName != null && (keystore = (KeyStore)this.context.getRegistry().lookupByNameAndType(keystoreName, KeyStore.class)) != null) {
            this.setKeystore(keystore);
        }
        if (keystoreName != null) {
            this.keystoreName = keystoreName;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public KeyStoreParameters getKeyStoreParameters() {
        return this.keyStoreParameters;
    }

    public void setKeyStoreParameters(KeyStoreParameters keyStoreParameters) {
        this.keyStoreParameters = keyStoreParameters;
        if (keyStoreParameters != null) {
            try {
                this.keystore = keyStoreParameters.createKeyStore();
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public String getSecureRandomName() {
        return this.secureRandomName;
    }

    public void setSecureRandomName(String randomName) {
        if (this.context != null && randomName != null) {
            SecureRandom random = (SecureRandom)this.context.getRegistry().lookupByNameAndType(randomName, SecureRandom.class);
            if (this.keystore != null) {
                this.setSecureRandom(random);
            }
        }
        if (randomName != null) {
            this.secureRandomName = randomName;
        }
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSignatureHeaderName() {
        return this.signatureHeaderName != null ? this.signatureHeaderName : "CamelDigitalSignature";
    }

    public void setSignatureHeaderName(String signatureHeaderName) {
        this.signatureHeaderName = signatureHeaderName;
    }

    public boolean isClearHeaders() {
        return this.clearHeaders;
    }

    public void setClearHeaders(boolean clearHeaders) {
        this.clearHeaders = clearHeaders;
    }

    public void setCryptoOperation(String operation) {
        this.cryptoOperation = CryptoOperation.valueOf(operation);
    }

    public void setCryptoOperation(CryptoOperation operation) {
        this.cryptoOperation = operation;
    }

    public CryptoOperation getCryptoOperation() {
        return this.cryptoOperation;
    }
}

