/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.Map;
import org.apache.camel.component.cxf.interceptors.RawMessageWSDLGetOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.w3c.dom.Document;

public class RawMessageWSDLGetInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final RawMessageWSDLGetInterceptor INSTANCE = new RawMessageWSDLGetInterceptor();
    public static final String DOCUMENT_HOLDER = RawMessageWSDLGetInterceptor.class.getName() + ".documentHolder";

    public RawMessageWSDLGetInterceptor() {
        super("read");
        this.getAfter().add(EndpointSelectionInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String query = (String)message.get((Object)Message.QUERY_STRING);
        if (!"GET".equals(method) || StringUtils.isEmpty((String)query)) {
            return;
        }
        String baseUri = (String)message.get((Object)"org.apache.cxf.request.url");
        String ctx = (String)message.get((Object)Message.PATH_INFO);
        Map map = UrlUtils.parseQueryString((String)query);
        if (this.isRecognizedQuery(map, baseUri, ctx, message.getExchange().getEndpoint().getEndpointInfo())) {
            Document doc = this.getDocument(message, baseUri, map, ctx);
            Endpoint e = (Endpoint)message.getExchange().get(Endpoint.class);
            MessageImpl mout = new MessageImpl();
            mout.setExchange(message.getExchange());
            mout = e.getBinding().createMessage((Message)mout);
            mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain((Exchange)message.getExchange()));
            message.getExchange().setOutMessage((Message)mout);
            mout.put((Object)DOCUMENT_HOLDER, (Object)doc);
            for (Interceptor inInterceptor : mout.getInterceptorChain()) {
                AbstractPhaseInterceptor interceptor;
                if (inInterceptor instanceof AbstractPhaseInterceptor && ((interceptor = (AbstractPhaseInterceptor)inInterceptor).getPhase().equals("prepare-send") || interceptor.getPhase().equals("pre-stream"))) continue;
                mout.getInterceptorChain().remove(inInterceptor);
            }
            mout.getInterceptorChain().add((Interceptor)RawMessageWSDLGetOutInterceptor.INSTANCE);
            message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(Message message, String base, Map<String, String> params, String ctxUri) {
        Endpoint endpoint = message.getExchange().getEndpoint();
        synchronized (endpoint) {
            return new WSDLGetUtils().getDocument(message, base, params, ctxUri, message.getExchange().getEndpoint().getEndpointInfo());
        }
    }

    private boolean isRecognizedQuery(Map<String, String> map, String baseUri, String ctx, EndpointInfo endpointInfo) {
        return map.containsKey("wsdl") || map.containsKey("xsd");
    }
}

