/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public interface AS2EndpointBuilderFactory {
    public static AS2EndpointBuilder as2(String path) {
        class AS2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements AS2EndpointBuilder,
        AdvancedAS2EndpointBuilder {
            public AS2EndpointBuilderImpl(String path) {
                super("as2", path);
            }
        }
        return new AS2EndpointBuilderImpl(path);
    }

    public static interface AS2Builders {
        default public AS2EndpointBuilder as2(String path) {
            return AS2EndpointBuilderFactory.as2(path);
        }
    }

    public static enum AS2SignatureAlgorithm {
        SHA3_224WITHRSA,
        SHA3_256WITHRSA,
        SHA3_384withRSA,
        SHA3_512WITHRSA,
        MD5WITHRSA,
        SHA1WITHRSA,
        MD2WITHRSA,
        SHA224WITHRSA,
        SHA256WITHRSA,
        SHA384WITHRSA,
        SHA512WITHRSA,
        RIPEMD128WITHRSA,
        RIPEMD160WITHRSA,
        RIPEMD256WITHRSA,
        SHA224WITHDSA,
        SHA256WITHDSA,
        SHA384WITHDSA,
        SHA512WITHDSA,
        SHA3_224WITHDSA,
        SHA3_256WITHDSA,
        SHA3_384WITHDSA,
        SHA3_512WITHDSA,
        SHA1WITHDSA,
        SHA3_224WITHECDSA,
        SHA3_256WITHECDSA,
        SHA3_384WITHECDSA,
        SHA3_512WITHECDSA,
        SHA1WITHECDSA,
        SHA224WITHECDSA,
        SHA256WITHECDSA,
        SHA384WITHECDSA,
        SHA512WITHECDSA,
        SHA1WITHPLAIN_ECDSA,
        SHA224WITHPLAIN_ECDSA,
        SHA256WITHPLAIN_ECDSA,
        SHA384WITHPLAIN_ECDSA,
        SHA512WITHPLAIN_ECDSA,
        RIPEMD160WITHPLAIN_ECDSA,
        SHA1WITHRSAANDMGF1,
        SHA224WITHRSAANDMGF1,
        SHA256WITHRSAANDMGF1,
        SHA384WITHRSAANDMGF1,
        SHA512WITHRSAANDMGF1,
        SHA3_224WITHRSAANDMGF1,
        SHA3_256WITHRSAANDMGF1,
        SHA3_384WITHRSAANDMGF1,
        SHA3_512WITHRSAANDMGF1;

    }

    public static enum AS2EncryptionAlgorithm {
        AES128_CBC,
        AES192_CBC,
        AES256_CBC,
        AES128_CCM,
        AES192_CCM,
        AES256_CCM,
        AES128_GCM,
        AES192_GCM,
        AES256_GCM,
        CAMELLIA128_CBC,
        CAMELLIA192_CBC,
        CAMELLIA256_CBC,
        CAST5_CBC,
        DES_CBC,
        DES_EDE3_CBC,
        GOST28147_GCFB,
        IDEA_CBC,
        RC2_CBC,
        RC4,
        SEED_CBC;

    }

    public static enum AS2CompressionAlgorithm {
        ZLIB;

    }

    public static enum AS2MessageStructure {
        PLAIN,
        SIGNED,
        ENCRYPTED,
        SIGNED_ENCRYPTED,
        PLAIN_COMPRESSED,
        SIGNED_COMPRESSED,
        ENCRYPTED_COMPRESSED,
        ENCRYPTED_COMPRESSED_SIGNED;

    }

    public static interface AdvancedAS2EndpointBuilder
    extends AdvancedAS2EndpointConsumerBuilder,
    AdvancedAS2EndpointProducerBuilder {
        @Override
        default public AS2EndpointBuilder basic() {
            return (AS2EndpointBuilder)((Object)this);
        }

        @Override
        default public AdvancedAS2EndpointBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        @Override
        default public AdvancedAS2EndpointBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        @Override
        default public AdvancedAS2EndpointBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        @Override
        default public AdvancedAS2EndpointBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public static interface AS2EndpointBuilder
    extends AS2EndpointConsumerBuilder,
    AS2EndpointProducerBuilder {
        @Override
        default public AdvancedAS2EndpointBuilder advanced() {
            return (AdvancedAS2EndpointBuilder)((Object)this);
        }

        @Override
        default public AS2EndpointBuilder as2From(String as2From) {
            this.doSetProperty("as2From", as2From);
            return this;
        }

        @Override
        default public AS2EndpointBuilder as2MessageStructure(AS2MessageStructure as2MessageStructure) {
            this.doSetProperty("as2MessageStructure", (Object)as2MessageStructure);
            return this;
        }

        @Override
        default public AS2EndpointBuilder as2MessageStructure(String as2MessageStructure) {
            this.doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }

        @Override
        default public AS2EndpointBuilder as2To(String as2To) {
            this.doSetProperty("as2To", as2To);
            return this;
        }

        @Override
        default public AS2EndpointBuilder as2Version(String as2Version) {
            this.doSetProperty("as2Version", as2Version);
            return this;
        }

        @Override
        default public AS2EndpointBuilder clientFqdn(String clientFqdn) {
            this.doSetProperty("clientFqdn", clientFqdn);
            return this;
        }

        @Override
        default public AS2EndpointBuilder compressionAlgorithm(AS2CompressionAlgorithm compressionAlgorithm) {
            this.doSetProperty("compressionAlgorithm", (Object)compressionAlgorithm);
            return this;
        }

        @Override
        default public AS2EndpointBuilder compressionAlgorithm(String compressionAlgorithm) {
            this.doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }

        @Override
        default public AS2EndpointBuilder decryptingPrivateKey(PrivateKey decryptingPrivateKey) {
            this.doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }

        @Override
        default public AS2EndpointBuilder decryptingPrivateKey(String decryptingPrivateKey) {
            this.doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }

        @Override
        default public AS2EndpointBuilder dispositionNotificationTo(String dispositionNotificationTo) {
            this.doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }

        @Override
        default public AS2EndpointBuilder ediMessageTransferEncoding(String ediMessageTransferEncoding) {
            this.doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }

        @Override
        default public AS2EndpointBuilder ediMessageType(Object ediMessageType) {
            this.doSetProperty("ediMessageType", ediMessageType);
            return this;
        }

        @Override
        default public AS2EndpointBuilder ediMessageType(String ediMessageType) {
            this.doSetProperty("ediMessageType", ediMessageType);
            return this;
        }

        @Override
        default public AS2EndpointBuilder encryptingAlgorithm(AS2EncryptionAlgorithm encryptingAlgorithm) {
            this.doSetProperty("encryptingAlgorithm", (Object)encryptingAlgorithm);
            return this;
        }

        @Override
        default public AS2EndpointBuilder encryptingAlgorithm(String encryptingAlgorithm) {
            this.doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }

        @Override
        default public AS2EndpointBuilder encryptingCertificateChain(Certificate[] encryptingCertificateChain) {
            this.doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }

        @Override
        default public AS2EndpointBuilder encryptingCertificateChain(String encryptingCertificateChain) {
            this.doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }

        @Override
        default public AS2EndpointBuilder from(String from) {
            this.doSetProperty("from", from);
            return this;
        }

        @Override
        default public AS2EndpointBuilder inBody(String inBody) {
            this.doSetProperty("inBody", inBody);
            return this;
        }

        @Override
        default public AS2EndpointBuilder mdnMessageTemplate(String mdnMessageTemplate) {
            this.doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }

        @Override
        default public AS2EndpointBuilder requestUri(String requestUri) {
            this.doSetProperty("requestUri", requestUri);
            return this;
        }

        @Override
        default public AS2EndpointBuilder server(String server) {
            this.doSetProperty("server", server);
            return this;
        }

        @Override
        default public AS2EndpointBuilder serverFqdn(String serverFqdn) {
            this.doSetProperty("serverFqdn", serverFqdn);
            return this;
        }

        @Override
        default public AS2EndpointBuilder serverPortNumber(Integer serverPortNumber) {
            this.doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }

        @Override
        default public AS2EndpointBuilder serverPortNumber(String serverPortNumber) {
            this.doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }

        @Override
        default public AS2EndpointBuilder signedReceiptMicAlgorithms(String[] signedReceiptMicAlgorithms) {
            this.doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }

        @Override
        default public AS2EndpointBuilder signedReceiptMicAlgorithms(String signedReceiptMicAlgorithms) {
            this.doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }

        @Override
        default public AS2EndpointBuilder signingAlgorithm(AS2SignatureAlgorithm signingAlgorithm) {
            this.doSetProperty("signingAlgorithm", (Object)signingAlgorithm);
            return this;
        }

        @Override
        default public AS2EndpointBuilder signingAlgorithm(String signingAlgorithm) {
            this.doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }

        @Override
        default public AS2EndpointBuilder signingCertificateChain(Certificate[] signingCertificateChain) {
            this.doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }

        @Override
        default public AS2EndpointBuilder signingCertificateChain(String signingCertificateChain) {
            this.doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }

        @Override
        default public AS2EndpointBuilder signingPrivateKey(PrivateKey signingPrivateKey) {
            this.doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }

        @Override
        default public AS2EndpointBuilder signingPrivateKey(String signingPrivateKey) {
            this.doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }

        @Override
        default public AS2EndpointBuilder subject(String subject) {
            this.doSetProperty("subject", subject);
            return this;
        }

        @Override
        default public AS2EndpointBuilder targetHostname(String targetHostname) {
            this.doSetProperty("targetHostname", targetHostname);
            return this;
        }

        @Override
        default public AS2EndpointBuilder targetPortNumber(Integer targetPortNumber) {
            this.doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }

        @Override
        default public AS2EndpointBuilder targetPortNumber(String targetPortNumber) {
            this.doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }

        @Override
        default public AS2EndpointBuilder userAgent(String userAgent) {
            this.doSetProperty("userAgent", userAgent);
            return this;
        }
    }

    public static interface AdvancedAS2EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AS2EndpointProducerBuilder basic() {
            return (AS2EndpointProducerBuilder)((Object)this);
        }

        default public AdvancedAS2EndpointProducerBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedAS2EndpointProducerBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedAS2EndpointProducerBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedAS2EndpointProducerBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public static interface AS2EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedAS2EndpointProducerBuilder advanced() {
            return (AdvancedAS2EndpointProducerBuilder)((Object)this);
        }

        default public AS2EndpointProducerBuilder as2From(String as2From) {
            this.doSetProperty("as2From", as2From);
            return this;
        }

        default public AS2EndpointProducerBuilder as2MessageStructure(AS2MessageStructure as2MessageStructure) {
            this.doSetProperty("as2MessageStructure", (Object)as2MessageStructure);
            return this;
        }

        default public AS2EndpointProducerBuilder as2MessageStructure(String as2MessageStructure) {
            this.doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }

        default public AS2EndpointProducerBuilder as2To(String as2To) {
            this.doSetProperty("as2To", as2To);
            return this;
        }

        default public AS2EndpointProducerBuilder as2Version(String as2Version) {
            this.doSetProperty("as2Version", as2Version);
            return this;
        }

        default public AS2EndpointProducerBuilder clientFqdn(String clientFqdn) {
            this.doSetProperty("clientFqdn", clientFqdn);
            return this;
        }

        default public AS2EndpointProducerBuilder compressionAlgorithm(AS2CompressionAlgorithm compressionAlgorithm) {
            this.doSetProperty("compressionAlgorithm", (Object)compressionAlgorithm);
            return this;
        }

        default public AS2EndpointProducerBuilder compressionAlgorithm(String compressionAlgorithm) {
            this.doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }

        default public AS2EndpointProducerBuilder decryptingPrivateKey(PrivateKey decryptingPrivateKey) {
            this.doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }

        default public AS2EndpointProducerBuilder decryptingPrivateKey(String decryptingPrivateKey) {
            this.doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }

        default public AS2EndpointProducerBuilder dispositionNotificationTo(String dispositionNotificationTo) {
            this.doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }

        default public AS2EndpointProducerBuilder ediMessageTransferEncoding(String ediMessageTransferEncoding) {
            this.doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }

        default public AS2EndpointProducerBuilder ediMessageType(Object ediMessageType) {
            this.doSetProperty("ediMessageType", ediMessageType);
            return this;
        }

        default public AS2EndpointProducerBuilder ediMessageType(String ediMessageType) {
            this.doSetProperty("ediMessageType", ediMessageType);
            return this;
        }

        default public AS2EndpointProducerBuilder encryptingAlgorithm(AS2EncryptionAlgorithm encryptingAlgorithm) {
            this.doSetProperty("encryptingAlgorithm", (Object)encryptingAlgorithm);
            return this;
        }

        default public AS2EndpointProducerBuilder encryptingAlgorithm(String encryptingAlgorithm) {
            this.doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }

        default public AS2EndpointProducerBuilder encryptingCertificateChain(Certificate[] encryptingCertificateChain) {
            this.doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }

        default public AS2EndpointProducerBuilder encryptingCertificateChain(String encryptingCertificateChain) {
            this.doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }

        default public AS2EndpointProducerBuilder from(String from) {
            this.doSetProperty("from", from);
            return this;
        }

        default public AS2EndpointProducerBuilder inBody(String inBody) {
            this.doSetProperty("inBody", inBody);
            return this;
        }

        default public AS2EndpointProducerBuilder mdnMessageTemplate(String mdnMessageTemplate) {
            this.doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }

        default public AS2EndpointProducerBuilder requestUri(String requestUri) {
            this.doSetProperty("requestUri", requestUri);
            return this;
        }

        default public AS2EndpointProducerBuilder server(String server) {
            this.doSetProperty("server", server);
            return this;
        }

        default public AS2EndpointProducerBuilder serverFqdn(String serverFqdn) {
            this.doSetProperty("serverFqdn", serverFqdn);
            return this;
        }

        default public AS2EndpointProducerBuilder serverPortNumber(Integer serverPortNumber) {
            this.doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }

        default public AS2EndpointProducerBuilder serverPortNumber(String serverPortNumber) {
            this.doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }

        default public AS2EndpointProducerBuilder signedReceiptMicAlgorithms(String[] signedReceiptMicAlgorithms) {
            this.doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }

        default public AS2EndpointProducerBuilder signedReceiptMicAlgorithms(String signedReceiptMicAlgorithms) {
            this.doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }

        default public AS2EndpointProducerBuilder signingAlgorithm(AS2SignatureAlgorithm signingAlgorithm) {
            this.doSetProperty("signingAlgorithm", (Object)signingAlgorithm);
            return this;
        }

        default public AS2EndpointProducerBuilder signingAlgorithm(String signingAlgorithm) {
            this.doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }

        default public AS2EndpointProducerBuilder signingCertificateChain(Certificate[] signingCertificateChain) {
            this.doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }

        default public AS2EndpointProducerBuilder signingCertificateChain(String signingCertificateChain) {
            this.doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }

        default public AS2EndpointProducerBuilder signingPrivateKey(PrivateKey signingPrivateKey) {
            this.doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }

        default public AS2EndpointProducerBuilder signingPrivateKey(String signingPrivateKey) {
            this.doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }

        default public AS2EndpointProducerBuilder subject(String subject) {
            this.doSetProperty("subject", subject);
            return this;
        }

        default public AS2EndpointProducerBuilder targetHostname(String targetHostname) {
            this.doSetProperty("targetHostname", targetHostname);
            return this;
        }

        default public AS2EndpointProducerBuilder targetPortNumber(Integer targetPortNumber) {
            this.doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }

        default public AS2EndpointProducerBuilder targetPortNumber(String targetPortNumber) {
            this.doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }

        default public AS2EndpointProducerBuilder userAgent(String userAgent) {
            this.doSetProperty("userAgent", userAgent);
            return this;
        }

        default public AS2EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AS2EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface AdvancedAS2EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AS2EndpointConsumerBuilder basic() {
            return (AS2EndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedAS2EndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder pollStrategy(PollingConsumerPollStrategy pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder pollStrategy(String pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedAS2EndpointConsumerBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public static interface AS2EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedAS2EndpointConsumerBuilder advanced() {
            return (AdvancedAS2EndpointConsumerBuilder)((Object)this);
        }

        default public AS2EndpointConsumerBuilder as2From(String as2From) {
            this.doSetProperty("as2From", as2From);
            return this;
        }

        default public AS2EndpointConsumerBuilder as2MessageStructure(AS2MessageStructure as2MessageStructure) {
            this.doSetProperty("as2MessageStructure", (Object)as2MessageStructure);
            return this;
        }

        default public AS2EndpointConsumerBuilder as2MessageStructure(String as2MessageStructure) {
            this.doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }

        default public AS2EndpointConsumerBuilder as2To(String as2To) {
            this.doSetProperty("as2To", as2To);
            return this;
        }

        default public AS2EndpointConsumerBuilder as2Version(String as2Version) {
            this.doSetProperty("as2Version", as2Version);
            return this;
        }

        default public AS2EndpointConsumerBuilder clientFqdn(String clientFqdn) {
            this.doSetProperty("clientFqdn", clientFqdn);
            return this;
        }

        default public AS2EndpointConsumerBuilder compressionAlgorithm(AS2CompressionAlgorithm compressionAlgorithm) {
            this.doSetProperty("compressionAlgorithm", (Object)compressionAlgorithm);
            return this;
        }

        default public AS2EndpointConsumerBuilder compressionAlgorithm(String compressionAlgorithm) {
            this.doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }

        default public AS2EndpointConsumerBuilder decryptingPrivateKey(PrivateKey decryptingPrivateKey) {
            this.doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }

        default public AS2EndpointConsumerBuilder decryptingPrivateKey(String decryptingPrivateKey) {
            this.doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }

        default public AS2EndpointConsumerBuilder dispositionNotificationTo(String dispositionNotificationTo) {
            this.doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }

        default public AS2EndpointConsumerBuilder ediMessageTransferEncoding(String ediMessageTransferEncoding) {
            this.doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }

        default public AS2EndpointConsumerBuilder ediMessageType(Object ediMessageType) {
            this.doSetProperty("ediMessageType", ediMessageType);
            return this;
        }

        default public AS2EndpointConsumerBuilder ediMessageType(String ediMessageType) {
            this.doSetProperty("ediMessageType", ediMessageType);
            return this;
        }

        default public AS2EndpointConsumerBuilder encryptingAlgorithm(AS2EncryptionAlgorithm encryptingAlgorithm) {
            this.doSetProperty("encryptingAlgorithm", (Object)encryptingAlgorithm);
            return this;
        }

        default public AS2EndpointConsumerBuilder encryptingAlgorithm(String encryptingAlgorithm) {
            this.doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }

        default public AS2EndpointConsumerBuilder encryptingCertificateChain(Certificate[] encryptingCertificateChain) {
            this.doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }

        default public AS2EndpointConsumerBuilder encryptingCertificateChain(String encryptingCertificateChain) {
            this.doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }

        default public AS2EndpointConsumerBuilder from(String from) {
            this.doSetProperty("from", from);
            return this;
        }

        default public AS2EndpointConsumerBuilder inBody(String inBody) {
            this.doSetProperty("inBody", inBody);
            return this;
        }

        default public AS2EndpointConsumerBuilder mdnMessageTemplate(String mdnMessageTemplate) {
            this.doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }

        default public AS2EndpointConsumerBuilder requestUri(String requestUri) {
            this.doSetProperty("requestUri", requestUri);
            return this;
        }

        default public AS2EndpointConsumerBuilder server(String server) {
            this.doSetProperty("server", server);
            return this;
        }

        default public AS2EndpointConsumerBuilder serverFqdn(String serverFqdn) {
            this.doSetProperty("serverFqdn", serverFqdn);
            return this;
        }

        default public AS2EndpointConsumerBuilder serverPortNumber(Integer serverPortNumber) {
            this.doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }

        default public AS2EndpointConsumerBuilder serverPortNumber(String serverPortNumber) {
            this.doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }

        default public AS2EndpointConsumerBuilder signedReceiptMicAlgorithms(String[] signedReceiptMicAlgorithms) {
            this.doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }

        default public AS2EndpointConsumerBuilder signedReceiptMicAlgorithms(String signedReceiptMicAlgorithms) {
            this.doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }

        default public AS2EndpointConsumerBuilder signingAlgorithm(AS2SignatureAlgorithm signingAlgorithm) {
            this.doSetProperty("signingAlgorithm", (Object)signingAlgorithm);
            return this;
        }

        default public AS2EndpointConsumerBuilder signingAlgorithm(String signingAlgorithm) {
            this.doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }

        default public AS2EndpointConsumerBuilder signingCertificateChain(Certificate[] signingCertificateChain) {
            this.doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }

        default public AS2EndpointConsumerBuilder signingCertificateChain(String signingCertificateChain) {
            this.doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }

        default public AS2EndpointConsumerBuilder signingPrivateKey(PrivateKey signingPrivateKey) {
            this.doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }

        default public AS2EndpointConsumerBuilder signingPrivateKey(String signingPrivateKey) {
            this.doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }

        default public AS2EndpointConsumerBuilder subject(String subject) {
            this.doSetProperty("subject", subject);
            return this;
        }

        default public AS2EndpointConsumerBuilder targetHostname(String targetHostname) {
            this.doSetProperty("targetHostname", targetHostname);
            return this;
        }

        default public AS2EndpointConsumerBuilder targetPortNumber(Integer targetPortNumber) {
            this.doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }

        default public AS2EndpointConsumerBuilder targetPortNumber(String targetPortNumber) {
            this.doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }

        default public AS2EndpointConsumerBuilder userAgent(String userAgent) {
            this.doSetProperty("userAgent", userAgent);
            return this;
        }

        default public AS2EndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AS2EndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AS2EndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public AS2EndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public AS2EndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public AS2EndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public AS2EndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public AS2EndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public AS2EndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public AS2EndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public AS2EndpointConsumerBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public AS2EndpointConsumerBuilder delay(String delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public AS2EndpointConsumerBuilder greedy(boolean greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public AS2EndpointConsumerBuilder greedy(String greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public AS2EndpointConsumerBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public AS2EndpointConsumerBuilder initialDelay(String initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public AS2EndpointConsumerBuilder repeatCount(long repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public AS2EndpointConsumerBuilder repeatCount(String repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public AS2EndpointConsumerBuilder runLoggingLevel(LoggingLevel runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public AS2EndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public AS2EndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public AS2EndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public AS2EndpointConsumerBuilder scheduler(String scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public AS2EndpointConsumerBuilder schedulerProperties(Map<String, Object> schedulerProperties) {
            this.doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }

        default public AS2EndpointConsumerBuilder schedulerProperties(String schedulerProperties) {
            this.doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }

        default public AS2EndpointConsumerBuilder startScheduler(boolean startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public AS2EndpointConsumerBuilder startScheduler(String startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public AS2EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            this.doSetProperty("timeUnit", (Object)timeUnit);
            return this;
        }

        default public AS2EndpointConsumerBuilder timeUnit(String timeUnit) {
            this.doSetProperty("timeUnit", timeUnit);
            return this;
        }

        default public AS2EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public AS2EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }
}

