/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

public interface ECSEndpointBuilderFactory {
    public static ECSEndpointBuilder awsEcs(String path) {
        class ECSEndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements ECSEndpointBuilder,
        AdvancedECSEndpointBuilder {
            public ECSEndpointBuilderImpl(String path) {
                super("aws-ecs", path);
            }
        }
        return new ECSEndpointBuilderImpl(path);
    }

    public static interface ECSBuilders {
        default public ECSEndpointBuilder awsEcs(String path) {
            return ECSEndpointBuilderFactory.awsEcs(path);
        }
    }

    public static enum Protocol {
        http,
        https;

    }

    public static enum ECSOperations {
        listClusters,
        describeCluster,
        createCluster,
        deleteCluster;

    }

    public static interface AdvancedECSEndpointBuilder
    extends EndpointProducerBuilder {
        default public ECSEndpointBuilder basic() {
            return (ECSEndpointBuilder)((Object)this);
        }

        default public AdvancedECSEndpointBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedECSEndpointBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedECSEndpointBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedECSEndpointBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public static interface ECSEndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedECSEndpointBuilder advanced() {
            return (AdvancedECSEndpointBuilder)((Object)this);
        }

        default public ECSEndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public ECSEndpointBuilder ecsClient(Object ecsClient) {
            this.doSetProperty("ecsClient", ecsClient);
            return this;
        }

        default public ECSEndpointBuilder ecsClient(String ecsClient) {
            this.doSetProperty("ecsClient", ecsClient);
            return this;
        }

        default public ECSEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public ECSEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public ECSEndpointBuilder operation(ECSOperations operation) {
            this.doSetProperty("operation", (Object)operation);
            return this;
        }

        default public ECSEndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public ECSEndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public ECSEndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public ECSEndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public ECSEndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", (Object)proxyProtocol);
            return this;
        }

        default public ECSEndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public ECSEndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public ECSEndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

