/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public interface S3EndpointBuilderFactory {
    public static S3EndpointBuilder awsS3(String path) {
        class S3EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements S3EndpointBuilder,
        AdvancedS3EndpointBuilder {
            public S3EndpointBuilderImpl(String path) {
                super("aws-s3", path);
            }
        }
        return new S3EndpointBuilderImpl(path);
    }

    public static interface S3Builders {
        default public S3EndpointBuilder awsS3(String path) {
            return S3EndpointBuilderFactory.awsS3(path);
        }
    }

    public static enum S3Operations {
        copyObject,
        listObjects,
        deleteObject,
        deleteBucket,
        listBuckets,
        downloadLink,
        getObject,
        getObjectRange;

    }

    public static enum Protocol {
        http,
        https;

    }

    public static interface AdvancedS3EndpointBuilder
    extends AdvancedS3EndpointConsumerBuilder,
    AdvancedS3EndpointProducerBuilder {
        @Override
        default public S3EndpointBuilder basic() {
            return (S3EndpointBuilder)((Object)this);
        }

        @Override
        default public AdvancedS3EndpointBuilder encryptionMaterials(Object encryptionMaterials) {
            this.doSetProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder encryptionMaterials(String encryptionMaterials) {
            this.doSetProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder useEncryption(boolean useEncryption) {
            this.doSetProperty("useEncryption", useEncryption);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder useEncryption(String useEncryption) {
            this.doSetProperty("useEncryption", useEncryption);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder accelerateModeEnabled(boolean accelerateModeEnabled) {
            this.doSetProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder accelerateModeEnabled(String accelerateModeEnabled) {
            this.doSetProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder chunkedEncodingDisabled(boolean chunkedEncodingDisabled) {
            this.doSetProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder chunkedEncodingDisabled(String chunkedEncodingDisabled) {
            this.doSetProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder dualstackEnabled(boolean dualstackEnabled) {
            this.doSetProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder dualstackEnabled(String dualstackEnabled) {
            this.doSetProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder forceGlobalBucketAccessEnabled(boolean forceGlobalBucketAccessEnabled) {
            this.doSetProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder forceGlobalBucketAccessEnabled(String forceGlobalBucketAccessEnabled) {
            this.doSetProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder payloadSigningEnabled(boolean payloadSigningEnabled) {
            this.doSetProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }

        @Override
        default public AdvancedS3EndpointBuilder payloadSigningEnabled(String payloadSigningEnabled) {
            this.doSetProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
    }

    public static interface S3EndpointBuilder
    extends S3EndpointConsumerBuilder,
    S3EndpointProducerBuilder {
        @Override
        default public AdvancedS3EndpointBuilder advanced() {
            return (AdvancedS3EndpointBuilder)((Object)this);
        }

        @Override
        default public S3EndpointBuilder amazonS3Client(Object amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        @Override
        default public S3EndpointBuilder amazonS3Client(String amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        @Override
        default public S3EndpointBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        @Override
        default public S3EndpointBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        @Override
        default public S3EndpointBuilder pathStyleAccess(boolean pathStyleAccess) {
            this.doSetProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }

        @Override
        default public S3EndpointBuilder pathStyleAccess(String pathStyleAccess) {
            this.doSetProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }

        @Override
        default public S3EndpointBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        @Override
        default public S3EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        @Override
        default public S3EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        @Override
        default public S3EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        @Override
        default public S3EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", (Object)proxyProtocol);
            return this;
        }

        @Override
        default public S3EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        @Override
        default public S3EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        @Override
        default public S3EndpointBuilder useIAMCredentials(boolean useIAMCredentials) {
            this.doSetProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }

        @Override
        default public S3EndpointBuilder useIAMCredentials(String useIAMCredentials) {
            this.doSetProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }

        @Override
        default public S3EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        @Override
        default public S3EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    public static interface AdvancedS3EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public S3EndpointProducerBuilder basic() {
            return (S3EndpointProducerBuilder)((Object)this);
        }

        default public AdvancedS3EndpointProducerBuilder encryptionMaterials(Object encryptionMaterials) {
            this.doSetProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder encryptionMaterials(String encryptionMaterials) {
            this.doSetProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder useEncryption(boolean useEncryption) {
            this.doSetProperty("useEncryption", useEncryption);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder useEncryption(String useEncryption) {
            this.doSetProperty("useEncryption", useEncryption);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder awsKMSKeyId(String awsKMSKeyId) {
            this.doSetProperty("awsKMSKeyId", awsKMSKeyId);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder useAwsKMS(boolean useAwsKMS) {
            this.doSetProperty("useAwsKMS", useAwsKMS);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder useAwsKMS(String useAwsKMS) {
            this.doSetProperty("useAwsKMS", useAwsKMS);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder accelerateModeEnabled(boolean accelerateModeEnabled) {
            this.doSetProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder accelerateModeEnabled(String accelerateModeEnabled) {
            this.doSetProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder chunkedEncodingDisabled(boolean chunkedEncodingDisabled) {
            this.doSetProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder chunkedEncodingDisabled(String chunkedEncodingDisabled) {
            this.doSetProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder dualstackEnabled(boolean dualstackEnabled) {
            this.doSetProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder dualstackEnabled(String dualstackEnabled) {
            this.doSetProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder forceGlobalBucketAccessEnabled(boolean forceGlobalBucketAccessEnabled) {
            this.doSetProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder forceGlobalBucketAccessEnabled(String forceGlobalBucketAccessEnabled) {
            this.doSetProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder payloadSigningEnabled(boolean payloadSigningEnabled) {
            this.doSetProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }

        default public AdvancedS3EndpointProducerBuilder payloadSigningEnabled(String payloadSigningEnabled) {
            this.doSetProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
    }

    public static interface S3EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedS3EndpointProducerBuilder advanced() {
            return (AdvancedS3EndpointProducerBuilder)((Object)this);
        }

        default public S3EndpointProducerBuilder amazonS3Client(Object amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public S3EndpointProducerBuilder amazonS3Client(String amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public S3EndpointProducerBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public S3EndpointProducerBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public S3EndpointProducerBuilder pathStyleAccess(boolean pathStyleAccess) {
            this.doSetProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }

        default public S3EndpointProducerBuilder pathStyleAccess(String pathStyleAccess) {
            this.doSetProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }

        default public S3EndpointProducerBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public S3EndpointProducerBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public S3EndpointProducerBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public S3EndpointProducerBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public S3EndpointProducerBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", (Object)proxyProtocol);
            return this;
        }

        default public S3EndpointProducerBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public S3EndpointProducerBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public S3EndpointProducerBuilder useIAMCredentials(boolean useIAMCredentials) {
            this.doSetProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }

        default public S3EndpointProducerBuilder useIAMCredentials(String useIAMCredentials) {
            this.doSetProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }

        default public S3EndpointProducerBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public S3EndpointProducerBuilder deleteAfterWrite(String deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public S3EndpointProducerBuilder keyName(String keyName) {
            this.doSetProperty("keyName", keyName);
            return this;
        }

        default public S3EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public S3EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public S3EndpointProducerBuilder multiPartUpload(boolean multiPartUpload) {
            this.doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }

        default public S3EndpointProducerBuilder multiPartUpload(String multiPartUpload) {
            this.doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }

        default public S3EndpointProducerBuilder operation(S3Operations operation) {
            this.doSetProperty("operation", (Object)operation);
            return this;
        }

        default public S3EndpointProducerBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public S3EndpointProducerBuilder partSize(long partSize) {
            this.doSetProperty("partSize", partSize);
            return this;
        }

        default public S3EndpointProducerBuilder partSize(String partSize) {
            this.doSetProperty("partSize", partSize);
            return this;
        }

        default public S3EndpointProducerBuilder serverSideEncryption(String serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        default public S3EndpointProducerBuilder storageClass(String storageClass) {
            this.doSetProperty("storageClass", storageClass);
            return this;
        }

        default public S3EndpointProducerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public S3EndpointProducerBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    public static interface AdvancedS3EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public S3EndpointConsumerBuilder basic() {
            return (S3EndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedS3EndpointConsumerBuilder encryptionMaterials(Object encryptionMaterials) {
            this.doSetProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder encryptionMaterials(String encryptionMaterials) {
            this.doSetProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder useEncryption(boolean useEncryption) {
            this.doSetProperty("useEncryption", useEncryption);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder useEncryption(String useEncryption) {
            this.doSetProperty("useEncryption", useEncryption);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder autocloseBody(boolean autocloseBody) {
            this.doSetProperty("autocloseBody", autocloseBody);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder autocloseBody(String autocloseBody) {
            this.doSetProperty("autocloseBody", autocloseBody);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder pollStrategy(PollingConsumerPollStrategy pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder pollStrategy(String pollStrategy) {
            this.doSetProperty("pollStrategy", pollStrategy);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder basicPropertyBinding(String basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder accelerateModeEnabled(boolean accelerateModeEnabled) {
            this.doSetProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder accelerateModeEnabled(String accelerateModeEnabled) {
            this.doSetProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder chunkedEncodingDisabled(boolean chunkedEncodingDisabled) {
            this.doSetProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder chunkedEncodingDisabled(String chunkedEncodingDisabled) {
            this.doSetProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder dualstackEnabled(boolean dualstackEnabled) {
            this.doSetProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder dualstackEnabled(String dualstackEnabled) {
            this.doSetProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder forceGlobalBucketAccessEnabled(boolean forceGlobalBucketAccessEnabled) {
            this.doSetProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder forceGlobalBucketAccessEnabled(String forceGlobalBucketAccessEnabled) {
            this.doSetProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder payloadSigningEnabled(boolean payloadSigningEnabled) {
            this.doSetProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }

        default public AdvancedS3EndpointConsumerBuilder payloadSigningEnabled(String payloadSigningEnabled) {
            this.doSetProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
    }

    public static interface S3EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedS3EndpointConsumerBuilder advanced() {
            return (AdvancedS3EndpointConsumerBuilder)((Object)this);
        }

        default public S3EndpointConsumerBuilder amazonS3Client(Object amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public S3EndpointConsumerBuilder amazonS3Client(String amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public S3EndpointConsumerBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public S3EndpointConsumerBuilder autoCreateBucket(String autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public S3EndpointConsumerBuilder pathStyleAccess(boolean pathStyleAccess) {
            this.doSetProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }

        default public S3EndpointConsumerBuilder pathStyleAccess(String pathStyleAccess) {
            this.doSetProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }

        default public S3EndpointConsumerBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public S3EndpointConsumerBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public S3EndpointConsumerBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public S3EndpointConsumerBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public S3EndpointConsumerBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", (Object)proxyProtocol);
            return this;
        }

        default public S3EndpointConsumerBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public S3EndpointConsumerBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public S3EndpointConsumerBuilder useIAMCredentials(boolean useIAMCredentials) {
            this.doSetProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }

        default public S3EndpointConsumerBuilder useIAMCredentials(String useIAMCredentials) {
            this.doSetProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }

        default public S3EndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public S3EndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public S3EndpointConsumerBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public S3EndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public S3EndpointConsumerBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public S3EndpointConsumerBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        default public S3EndpointConsumerBuilder includeBody(boolean includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public S3EndpointConsumerBuilder includeBody(String includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public S3EndpointConsumerBuilder maxConnections(int maxConnections) {
            this.doSetProperty("maxConnections", maxConnections);
            return this;
        }

        default public S3EndpointConsumerBuilder maxConnections(String maxConnections) {
            this.doSetProperty("maxConnections", maxConnections);
            return this;
        }

        default public S3EndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public S3EndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            this.doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }

        default public S3EndpointConsumerBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public S3EndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public S3EndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            this.doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }

        default public S3EndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public S3EndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            this.doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }

        default public S3EndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public S3EndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            this.doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }

        default public S3EndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public S3EndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            this.doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }

        default public S3EndpointConsumerBuilder delay(long delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public S3EndpointConsumerBuilder delay(String delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public S3EndpointConsumerBuilder greedy(boolean greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public S3EndpointConsumerBuilder greedy(String greedy) {
            this.doSetProperty("greedy", greedy);
            return this;
        }

        default public S3EndpointConsumerBuilder initialDelay(long initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public S3EndpointConsumerBuilder initialDelay(String initialDelay) {
            this.doSetProperty("initialDelay", initialDelay);
            return this;
        }

        default public S3EndpointConsumerBuilder repeatCount(long repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public S3EndpointConsumerBuilder repeatCount(String repeatCount) {
            this.doSetProperty("repeatCount", repeatCount);
            return this;
        }

        default public S3EndpointConsumerBuilder runLoggingLevel(LoggingLevel runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public S3EndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            this.doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }

        default public S3EndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public S3EndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            this.doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }

        default public S3EndpointConsumerBuilder scheduler(String scheduler) {
            this.doSetProperty("scheduler", scheduler);
            return this;
        }

        default public S3EndpointConsumerBuilder schedulerProperties(Map<String, Object> schedulerProperties) {
            this.doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }

        default public S3EndpointConsumerBuilder schedulerProperties(String schedulerProperties) {
            this.doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }

        default public S3EndpointConsumerBuilder startScheduler(boolean startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public S3EndpointConsumerBuilder startScheduler(String startScheduler) {
            this.doSetProperty("startScheduler", startScheduler);
            return this;
        }

        default public S3EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            this.doSetProperty("timeUnit", (Object)timeUnit);
            return this;
        }

        default public S3EndpointConsumerBuilder timeUnit(String timeUnit) {
            this.doSetProperty("timeUnit", timeUnit);
            return this;
        }

        default public S3EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public S3EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            this.doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }

        default public S3EndpointConsumerBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public S3EndpointConsumerBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

