/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Access Atomix's group messaging.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AtomixMessagingEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Atomix Messaging component.
     */
    public interface AtomixMessagingEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAtomixMessagingEndpointConsumerBuilder advanced() {
            return (AdvancedAtomixMessagingEndpointConsumerBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: &lt;code&gt;io.atomix.AtomixClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder atomix(Object atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.AtomixClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder atomix(String atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType&lt;/code&gt; type.
         * 
         * Default: ALL
         * Group: common
         * 
         * @param broadcastType the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder broadcastType(
                BroadcastType broadcastType) {
            doSetProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType&lt;/code&gt; type.
         * 
         * Default: ALL
         * Group: common
         * 
         * @param broadcastType the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder broadcastType(
                String broadcastType) {
            doSetProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The messaging channel name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param channelName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder channelName(
                String channelName) {
            doSetProperty("channelName", channelName);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action&lt;/code&gt; type.
         * 
         * Default: DIRECT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder defaultAction(
                Action defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action&lt;/code&gt; type.
         * 
         * Default: DIRECT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder defaultAction(
                String defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The Atomix Group member name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param memberName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder memberName(
                String memberName) {
            doSetProperty("memberName", memberName);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;io.atomix.catalyst.transport.Address&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder nodes(List<Object> nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;io.atomix.catalyst.transport.Address&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder nodes(String nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * The class name (fqn) of the Atomix transport.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.atomix.catalyst.transport.netty.NettyTransport
         * Group: common
         * 
         * @param transportClassName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder transportClassName(
                String transportClassName) {
            doSetProperty("transportClassName", transportClassName);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Atomix Messaging
     * component.
     */
    public interface AdvancedAtomixMessagingEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AtomixMessagingEndpointConsumerBuilder basic() {
            return (AtomixMessagingEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder ephemeral(
                boolean ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder ephemeral(
                String ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a:
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder readConsistency(
                ReadConsistency readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder readConsistency(
                String readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder resourceConfigs(
                Map<String, Properties> resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder resourceConfigs(
                String resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder resourceOptions(
                Map<String, Properties> resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointConsumerBuilder resourceOptions(
                String resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Atomix Messaging component.
     */
    public interface AtomixMessagingEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAtomixMessagingEndpointProducerBuilder advanced() {
            return (AdvancedAtomixMessagingEndpointProducerBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: &lt;code&gt;io.atomix.AtomixClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder atomix(Object atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.AtomixClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder atomix(String atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType&lt;/code&gt; type.
         * 
         * Default: ALL
         * Group: common
         * 
         * @param broadcastType the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder broadcastType(
                BroadcastType broadcastType) {
            doSetProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType&lt;/code&gt; type.
         * 
         * Default: ALL
         * Group: common
         * 
         * @param broadcastType the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder broadcastType(
                String broadcastType) {
            doSetProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The messaging channel name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param channelName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder channelName(
                String channelName) {
            doSetProperty("channelName", channelName);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action&lt;/code&gt; type.
         * 
         * Default: DIRECT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder defaultAction(
                Action defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action&lt;/code&gt; type.
         * 
         * Default: DIRECT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder defaultAction(
                String defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The Atomix Group member name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param memberName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder memberName(
                String memberName) {
            doSetProperty("memberName", memberName);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;io.atomix.catalyst.transport.Address&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder nodes(List<Object> nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;io.atomix.catalyst.transport.Address&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder nodes(String nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder resultHeader(
                String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * The class name (fqn) of the Atomix transport.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.atomix.catalyst.transport.netty.NettyTransport
         * Group: common
         * 
         * @param transportClassName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder transportClassName(
                String transportClassName) {
            doSetProperty("transportClassName", transportClassName);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Atomix Messaging
     * component.
     */
    public interface AdvancedAtomixMessagingEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AtomixMessagingEndpointProducerBuilder basic() {
            return (AtomixMessagingEndpointProducerBuilder) this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder ephemeral(
                boolean ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder ephemeral(
                String ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a:
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder readConsistency(
                ReadConsistency readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder readConsistency(
                String readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder resourceConfigs(
                Map<String, Properties> resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder resourceConfigs(
                String resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder resourceOptions(
                Map<String, Properties> resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointProducerBuilder resourceOptions(
                String resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Atomix Messaging component.
     */
    public interface AtomixMessagingEndpointBuilder
            extends
                AtomixMessagingEndpointConsumerBuilder,
                AtomixMessagingEndpointProducerBuilder {
        default AdvancedAtomixMessagingEndpointBuilder advanced() {
            return (AdvancedAtomixMessagingEndpointBuilder) this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option is a: &lt;code&gt;io.atomix.AtomixClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder atomix(Object atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The Atomix instance to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.AtomixClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param atomix the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder atomix(String atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType&lt;/code&gt; type.
         * 
         * Default: ALL
         * Group: common
         * 
         * @param broadcastType the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder broadcastType(
                BroadcastType broadcastType) {
            doSetProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The broadcast type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType&lt;/code&gt; type.
         * 
         * Default: ALL
         * Group: common
         * 
         * @param broadcastType the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder broadcastType(
                String broadcastType) {
            doSetProperty("broadcastType", broadcastType);
            return this;
        }
        /**
         * The messaging channel name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param channelName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder channelName(String channelName) {
            doSetProperty("channelName", channelName);
            return this;
        }
        /**
         * The Atomix configuration uri.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * The default action.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action&lt;/code&gt; type.
         * 
         * Default: DIRECT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder defaultAction(
                Action defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The default action.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action&lt;/code&gt; type.
         * 
         * Default: DIRECT
         * Group: common
         * 
         * @param defaultAction the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder defaultAction(
                String defaultAction) {
            doSetProperty("defaultAction", defaultAction);
            return this;
        }
        /**
         * The Atomix Group member name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param memberName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder memberName(String memberName) {
            doSetProperty("memberName", memberName);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;io.atomix.catalyst.transport.Address&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder nodes(List<Object> nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The address of the nodes composing the cluster.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;io.atomix.catalyst.transport.Address&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nodes the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder nodes(String nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * The header that wil carry the result.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param resultHeader the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder resultHeader(String resultHeader) {
            doSetProperty("resultHeader", resultHeader);
            return this;
        }
        /**
         * The class name (fqn) of the Atomix transport.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.atomix.catalyst.transport.netty.NettyTransport
         * Group: common
         * 
         * @param transportClassName the value to set
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder transportClassName(
                String transportClassName) {
            doSetProperty("transportClassName", transportClassName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Atomix Messaging component.
     */
    public interface AdvancedAtomixMessagingEndpointBuilder
            extends
                AdvancedAtomixMessagingEndpointConsumerBuilder,
                AdvancedAtomixMessagingEndpointProducerBuilder {
        default AtomixMessagingEndpointBuilder basic() {
            return (AtomixMessagingEndpointBuilder) this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder defaultResourceConfig(
                Properties defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The cluster wide default resource configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceConfig the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder defaultResourceConfig(
                String defaultResourceConfig) {
            doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder defaultResourceOptions(
                Properties defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * The local default resource options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param defaultResourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder defaultResourceOptions(
                String defaultResourceOptions) {
            doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder ephemeral(
                boolean ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * Sets if the local member should join groups as PersistentMember or
         * not. If set to ephemeral the local member will receive an auto
         * generated ID thus the local one is ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ephemeral the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder ephemeral(
                String ephemeral) {
            doSetProperty("ephemeral", ephemeral);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option is a:
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder readConsistency(
                ReadConsistency readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * The read consistency level.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.atomix.resource.ReadConsistency&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readConsistency the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder readConsistency(
                String readConsistency) {
            doSetProperty("readConsistency", readConsistency);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder resourceConfigs(
                Map<String, Properties> resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Cluster wide resources configuration.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceConfigs the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder resourceConfigs(
                String resourceConfigs) {
            doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder resourceOptions(
                Map<String, Properties> resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
        /**
         * Local resources configurations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.util.Properties&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param resourceOptions the value to set
         * @return the dsl builder
         */
        default AdvancedAtomixMessagingEndpointBuilder resourceOptions(
                String resourceOptions) {
            doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$BroadcastType</code> enum.
     */
    enum BroadcastType {
        ALL,
        RANDOM;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.atomix.client.messaging.AtomixMessaging$Action</code> enum.
     */
    enum Action {
        DIRECT,
        BROADCAST;
    }

    /**
     * Proxy enum for <code>io.atomix.resource.ReadConsistency</code> enum.
     */
    enum ReadConsistency {
        ATOMIC,
        ATOMIC_LEASE,
        SEQUENTIAL,
        LOCAL;
    }

    public interface AtomixMessagingBuilders {
        /**
         * Atomix Messaging (camel-atomix)
         * Access Atomix's group messaging.
         * 
         * Category: clustering
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-atomix
         * 
         * Syntax: <code>atomix-messaging:resourceName</code>
         * 
         * Path parameter: resourceName (required)
         * The distributed resource name
         * 
         * @param path resourceName
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder atomixMessaging(String path) {
            return AtomixMessagingEndpointBuilderFactory.endpointBuilder("atomix-messaging", path);
        }
        /**
         * Atomix Messaging (camel-atomix)
         * Access Atomix's group messaging.
         * 
         * Category: clustering
         * Since: 2.20
         * Maven coordinates: org.apache.camel:camel-atomix
         * 
         * Syntax: <code>atomix-messaging:resourceName</code>
         * 
         * Path parameter: resourceName (required)
         * The distributed resource name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path resourceName
         * @return the dsl builder
         */
        default AtomixMessagingEndpointBuilder atomixMessaging(
                String componentName,
                String path) {
            return AtomixMessagingEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static AtomixMessagingEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class AtomixMessagingEndpointBuilderImpl extends AbstractEndpointBuilder implements AtomixMessagingEndpointBuilder, AdvancedAtomixMessagingEndpointBuilder {
            public AtomixMessagingEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new AtomixMessagingEndpointBuilderImpl(path);
    }
}