/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Capture changes from an SQL Server database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DebeziumSqlserverEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Debezium SQL Server Connector component.
     */
    public interface DebeziumSqlserverEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDebeziumSqlserverEndpointBuilder advanced() {
            return (AdvancedDebeziumSqlserverEndpointBuilder) this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         */
        default DebeziumSqlserverEndpointBuilder additionalProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalProperties", "additionalProperties." + key, value);
            return this;
        }
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: common
         */
        default DebeziumSqlserverEndpointBuilder additionalProperties(Map values) {
            doSetMultiValueProperties("additionalProperties", "additionalProperties.", values);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder internalKeyConverter(
                String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder internalValueConverter(
                String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default:
         * io.debezium.embedded.spi.OffsetCommitPolicy.PeriodicCommitOffsetPolicy
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetCommitPolicy(
                String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5s
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetCommitTimeoutMs(
                long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 5s
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetCommitTimeoutMs(
                String offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 60s
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetFlushIntervalMs(
                long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 60s
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetFlushIntervalMs(
                String offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetStorage(
                String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetStorageFileName(
                String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetStoragePartitions(
                int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetStoragePartitions(
                String offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetStorageReplicationFactor(
                int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetStorageReplicationFactor(
                String offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumSqlserverEndpointBuilder offsetStorageTopic(
                String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * Regular expressions matching columns to exclude from change events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder columnBlacklist(
                String columnBlacklist) {
            doSetProperty("columnBlacklist", columnBlacklist);
            return this;
        }
        /**
         * Regular expressions matching columns to include in change events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder columnWhitelist(
                String columnWhitelist) {
            doSetProperty("columnWhitelist", columnWhitelist);
            return this;
        }
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder converters(String converters) {
            doSetProperty("converters", converters);
            return this;
        }
        /**
         * The name of the database the connector should be monitoring. When
         * working with a multi-tenant set-up, must be set to the CDB name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseDbname(
                String databaseDbname) {
            doSetProperty("databaseDbname", databaseDbname);
            return this;
        }
        /**
         * The name of the DatabaseHistory class that should be used to store
         * and recover database schema changes. The configuration properties for
         * the history are prefixed with the 'database.history.' string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: io.debezium.relational.history.FileDatabaseHistory
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHistory(
                String databaseHistory) {
            doSetProperty("databaseHistory", databaseHistory);
            return this;
        }
        /**
         * The path to the file that will be used to record the database
         * history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHistoryFileFilename(
                String databaseHistoryFileFilename) {
            doSetProperty("databaseHistoryFileFilename", databaseHistoryFileFilename);
            return this;
        }
        /**
         * A list of host/port pairs that the connector will use for
         * establishing the initial connection to the Kafka cluster for
         * retrieving database schema history previously stored by the
         * connector. This should point to the same Kafka cluster used by the
         * Kafka Connect process.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHistoryKafkaBootstrapServers(
                String databaseHistoryKafkaBootstrapServers) {
            doSetProperty("databaseHistoryKafkaBootstrapServers", databaseHistoryKafkaBootstrapServers);
            return this;
        }
        /**
         * The number of attempts in a row that no data are returned from Kafka
         * before recover completes. The maximum amount of time to wait after
         * receiving no data is (recovery.attempts) x
         * (recovery.poll.interval.ms).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 100
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHistoryKafkaRecoveryAttempts(
                int databaseHistoryKafkaRecoveryAttempts) {
            doSetProperty("databaseHistoryKafkaRecoveryAttempts", databaseHistoryKafkaRecoveryAttempts);
            return this;
        }
        /**
         * The number of attempts in a row that no data are returned from Kafka
         * before recover completes. The maximum amount of time to wait after
         * receiving no data is (recovery.attempts) x
         * (recovery.poll.interval.ms).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 100
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHistoryKafkaRecoveryAttempts(
                String databaseHistoryKafkaRecoveryAttempts) {
            doSetProperty("databaseHistoryKafkaRecoveryAttempts", databaseHistoryKafkaRecoveryAttempts);
            return this;
        }
        /**
         * The number of milliseconds to wait while polling for persisted data
         * during recovery.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 100ms
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHistoryKafkaRecoveryPollIntervalMs(
                int databaseHistoryKafkaRecoveryPollIntervalMs) {
            doSetProperty("databaseHistoryKafkaRecoveryPollIntervalMs", databaseHistoryKafkaRecoveryPollIntervalMs);
            return this;
        }
        /**
         * The number of milliseconds to wait while polling for persisted data
         * during recovery.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 100ms
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHistoryKafkaRecoveryPollIntervalMs(
                String databaseHistoryKafkaRecoveryPollIntervalMs) {
            doSetProperty("databaseHistoryKafkaRecoveryPollIntervalMs", databaseHistoryKafkaRecoveryPollIntervalMs);
            return this;
        }
        /**
         * The name of the topic for the database schema history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHistoryKafkaTopic(
                String databaseHistoryKafkaTopic) {
            doSetProperty("databaseHistoryKafkaTopic", databaseHistoryKafkaTopic);
            return this;
        }
        /**
         * Resolvable hostname or IP address of the SQL Server database server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseHostname(
                String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
        /**
         * Password of the SQL Server database user to be used when connecting
         * to the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databasePassword(
                String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
        /**
         * Port of the SQL Server database server.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1433
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Port of the SQL Server database server.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1433
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databasePort(
                String databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Unique name that identifies the database server and all recorded
         * offsets, and that is used as a prefix for all schemas and topics.
         * Each distinct installation should have a separate namespace and be
         * monitored by at most one Debezium connector.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseServerName(
                String databaseServerName) {
            doSetProperty("databaseServerName", databaseServerName);
            return this;
        }
        /**
         * The timezone of the server used to correctly shift the commit
         * transaction timestamp on the client sideOptions include: Any valid
         * Java ZoneId.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseServerTimezone(
                String databaseServerTimezone) {
            doSetProperty("databaseServerTimezone", databaseServerTimezone);
            return this;
        }
        /**
         * Name of the SQL Server database user to be used when connecting to
         * the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder databaseUser(
                String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including:'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: precise
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder decimalHandlingMode(
                String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including:'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped;'ignore' the problematic event will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: fail
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder eventProcessingFailureHandlingMode(
                String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder heartbeatIntervalMs(
                int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder heartbeatIntervalMs(
                String heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: __debezium-heartbeat
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder heartbeatTopicsPrefix(
                String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s).The default is 'true'. This is
         * independent of how the connector internally records database history.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder includeSchemaChanges(
                boolean includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s).The default is 'true'. This is
         * independent of how the connector internally records database history.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder includeSchemaChanges(
                String includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 2048
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 2048
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder maxBatchSize(
                String maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8192
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8192
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder maxQueueSize(
                String maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':',where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector,and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key.Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder messageKeyColumns(
                String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
        /**
         * Frequency in milliseconds to wait for new change events to appear
         * after receiving no events. Defaults to 500ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500ms
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder pollIntervalMs(
                long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Frequency in milliseconds to wait for new change events to appear
         * after receiving no events. Defaults to 500ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500ms
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder pollIntervalMs(
                String pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder provideTransactionMetadata(
                boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder provideTransactionMetadata(
                String provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * Whether field names will be sanitized to Avro naming conventions.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder sanitizeFieldNames(
                boolean sanitizeFieldNames) {
            doSetProperty("sanitizeFieldNames", sanitizeFieldNames);
            return this;
        }
        /**
         * Whether field names will be sanitized to Avro naming conventions.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder sanitizeFieldNames(
                String sanitizeFieldNames) {
            doSetProperty("sanitizeFieldNames", sanitizeFieldNames);
            return this;
        }
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'i' for inserts; 'u' for updates; 'd' for deletes. By
         * default, no operations will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder skippedOperations(
                String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
        /**
         * The number of milliseconds to delay before a snapshot will begin.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotDelayMs(
                long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The number of milliseconds to delay before a snapshot will begin.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0ms
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotDelayMs(
                String snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotFetchSize(
                int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotFetchSize(
                String snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * Controls which transaction isolation level is used and how long the
         * connector locks the monitored tables. The default is
         * 'repeatable_read', which means that repeatable read isolation level
         * is used. In addition, exclusive locks are taken only during schema
         * snapshot. Using a value of 'exclusive' ensures that the connector
         * holds the exclusive lock (and thus prevents any reads and updates)
         * for all monitored tables during the entire snapshot duration. When
         * 'snapshot' is specified, connector runs the initial snapshot in
         * SNAPSHOT isolation level, which guarantees snapshot consistency. In
         * addition, neither table nor row-level locks are held. When
         * 'read_committed' is specified, connector runs the initial snapshot in
         * READ COMMITTED isolation level. No long-running locks are taken, so
         * that initial snapshot does not prevent other transactions from
         * updating table rows. Snapshot consistency is not guaranteed.In
         * 'read_uncommitted' mode neither table nor row-level locks are
         * acquired, but connector does not guarantee snapshot consistency.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: repeatable_read
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotIsolationMode(
                String snapshotIsolationMode) {
            doSetProperty("snapshotIsolationMode", snapshotIsolationMode);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 10s
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotLockTimeoutMs(
                long snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 10s
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotLockTimeoutMs(
                String snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Options include: 'initial' (the default) to specify the connector
         * should run a snapshot only when no offsets are available for the
         * logical server name; 'schema_only' to specify the connector should
         * run a snapshot of the schema when no offsets are available for the
         * logical server name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: initial
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotMode(
                String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * thespecific connectors . Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder snapshotSelectStatementOverrides(
                String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
        /**
         * A version of the format of the publicly visible source part in the
         * message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: v2
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder sourceStructVersion(
                String sourceStructVersion) {
            doSetProperty("sourceStructVersion", sourceStructVersion);
            return this;
        }
        /**
         * Configures the criteria of the attached timestamp within the source
         * record (ts_ms).Options include:'commit', (default) the source
         * timestamp is set to the instant where the record was committed in the
         * database'processing', the source timestamp is set to the instant
         * where the record was processed by Debezium.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: commit
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder sourceTimestampMode(
                String sourceTimestampMode) {
            doSetProperty("sourceTimestampMode", sourceTimestampMode);
            return this;
        }
        /**
         * Description is not available here, please check Debezium website for
         * corresponding key 'table.blacklist' description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder tableBlacklist(
                String tableBlacklist) {
            doSetProperty("tableBlacklist", tableBlacklist);
            return this;
        }
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder tableIgnoreBuiltin(
                boolean tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder tableIgnoreBuiltin(
                String tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder tableWhitelist(
                String tableWhitelist) {
            doSetProperty("tableWhitelist", tableWhitelist);
            return this;
        }
        /**
         * Time, date, and timestamps can be represented with different kinds of
         * precisions, including:'adaptive' (the default) bases the precision of
         * time, date, and timestamp values on the database column's precision;
         * 'adaptive_time_microseconds' like 'adaptive' mode, but TIME fields
         * always use microseconds precision;'connect' always represents time,
         * date, and timestamp values using Kafka Connect's built-in
         * representations for Time, Date, and Timestamp, which uses millisecond
         * precision regardless of the database columns' precision .
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: adaptive
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder timePrecisionMode(
                String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsquenttombstone event (true) or only by a delete event (false).
         * Emitting the tombstone event (the default behavior) allows Kafka to
         * completely delete all events pertaining to the given key once the
         * source record got deleted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder tombstonesOnDelete(
                boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsquenttombstone event (true) or only by a delete event (false).
         * Emitting the tombstone event (the default behavior) allows Kafka to
         * completely delete all events pertaining to the given key once the
         * source record got deleted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: sqlserver
         */
        default DebeziumSqlserverEndpointBuilder tombstonesOnDelete(
                String tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Debezium SQL Server Connector
     * component.
     */
    public interface AdvancedDebeziumSqlserverEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default DebeziumSqlserverEndpointBuilder basic() {
            return (DebeziumSqlserverEndpointBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumSqlserverEndpointBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumSqlserverEndpointBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumSqlserverEndpointBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumSqlserverEndpointBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDebeziumSqlserverEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDebeziumSqlserverEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDebeziumSqlserverEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedDebeziumSqlserverEndpointBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface DebeziumSqlserverBuilders {
        /**
         * Debezium SQL Server Connector (camel-debezium-sqlserver)
         * Capture changes from an SQL Server database.
         * 
         * Category: database,sql
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
         * 
         * Syntax: <code>debezium-sqlserver:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param path name
         */
        default DebeziumSqlserverEndpointBuilder debeziumSqlserver(String path) {
            return DebeziumSqlserverEndpointBuilderFactory.endpointBuilder("debezium-sqlserver", path);
        }
        /**
         * Debezium SQL Server Connector (camel-debezium-sqlserver)
         * Capture changes from an SQL Server database.
         * 
         * Category: database,sql
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
         * 
         * Syntax: <code>debezium-sqlserver:name</code>
         * 
         * Path parameter: name (required)
         * Unique name for the connector. Attempting to register again with the
         * same name will fail.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         */
        default DebeziumSqlserverEndpointBuilder debeziumSqlserver(
                String componentName,
                String path) {
            return DebeziumSqlserverEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static DebeziumSqlserverEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class DebeziumSqlserverEndpointBuilderImpl extends AbstractEndpointBuilder implements DebeziumSqlserverEndpointBuilder, AdvancedDebeziumSqlserverEndpointBuilder {
            public DebeziumSqlserverEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DebeziumSqlserverEndpointBuilderImpl(path);
    }
}