/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The azure-eventhubs component that integrates Azure Event Hubs using AMQP
 * protocol. Azure EventHubs is a highly scalable publish-subscribe service that
 * can ingest millions of events per second and stream them to multiple
 * consumers.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface EventHubsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Event Hubs component.
     */
    public interface EventHubsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedEventHubsEndpointConsumerBuilder advanced() {
            return (AdvancedEventHubsEndpointConsumerBuilder) this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpRetryOptions</code>
         * type.
         * 
         * Group: common
         */
        default EventHubsEndpointConsumerBuilder amqpRetryOptions(
                Object amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpRetryOptions</code> type.
         * 
         * Group: common
         */
        default EventHubsEndpointConsumerBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpTransportType</code>
         * type.
         * 
         * Default: AMQP
         * Group: common
         */
        default EventHubsEndpointConsumerBuilder amqpTransportType(
                AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpTransportType</code> type.
         * 
         * Default: AMQP
         * Group: common
         */
        default EventHubsEndpointConsumerBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default EventHubsEndpointConsumerBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default EventHubsEndpointConsumerBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore, this sets access
         * key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder blobAccessKey(
                String blobAccessKey) {
            doSetProperty("blobAccessKey", blobAccessKey);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore, this sets Azure
         * account name to be used for authentication with azure blob services.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder blobAccountName(
                String blobAccountName) {
            doSetProperty("blobAccountName", blobAccountName);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore, this sets the blob
         * container that shall be used by the BlobCheckpointStore to store the
         * checkpoint offsets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder blobContainerName(
                String blobContainerName) {
            doSetProperty("blobContainerName", blobContainerName);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore,
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * <code>com.azure.storage.common.StorageSharedKeyCredential</code>
         * type.
         * 
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder blobStorageSharedKeyCredential(
                Object blobStorageSharedKeyCredential) {
            doSetProperty("blobStorageSharedKeyCredential", blobStorageSharedKeyCredential);
            return this;
        }
        /**
         * In case you chose the default BlobCheckpointStore,
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * <code>com.azure.storage.common.StorageSharedKeyCredential</code>
         * type.
         * 
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder blobStorageSharedKeyCredential(
                String blobStorageSharedKeyCredential) {
            doSetProperty("blobStorageSharedKeyCredential", blobStorageSharedKeyCredential);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the CheckpointStore the EventProcessorClient will use for
         * storing partition ownership and checkpoint information. Users can,
         * optionally, provide their own implementation of CheckpointStore which
         * will store ownership and checkpoint information. By default it set to
         * use
         * com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore which stores all checkpoint offsets into Azure Blob Storage.
         * 
         * The option is a:
         * <code>com.azure.messaging.eventhubs.CheckpointStore</code> type.
         * 
         * Default: BlobCheckpointStore
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder checkpointStore(
                Object checkpointStore) {
            doSetProperty("checkpointStore", checkpointStore);
            return this;
        }
        /**
         * Sets the CheckpointStore the EventProcessorClient will use for
         * storing partition ownership and checkpoint information. Users can,
         * optionally, provide their own implementation of CheckpointStore which
         * will store ownership and checkpoint information. By default it set to
         * use
         * com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore which stores all checkpoint offsets into Azure Blob Storage.
         * 
         * The option will be converted to a
         * <code>com.azure.messaging.eventhubs.CheckpointStore</code> type.
         * 
         * Default: BlobCheckpointStore
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder checkpointStore(
                String checkpointStore) {
            doSetProperty("checkpointStore", checkpointStore);
            return this;
        }
        /**
         * Sets the name of the consumer group this consumer is associated with.
         * Events are read in the context of this group. The name of the
         * consumer group that is created by default is {link
         * #DEFAULT_CONSUMER_GROUP_NAME $Default}.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: $Default
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder consumerGroupName(
                String consumerGroupName) {
            doSetProperty("consumerGroupName", consumerGroupName);
            return this;
        }
        /**
         * Sets the map containing the event position to use for each partition
         * if a checkpoint for the partition does not exist in CheckpointStore.
         * This map is keyed off of the partition id. If there is no checkpoint
         * in CheckpointStore and there is no entry in this map, the processing
         * of the partition will start from {link EventPosition#latest() latest}
         * position.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * com.azure.messaging.eventhubs.models.EventPosition&gt;</code> type.
         * 
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder eventPosition(
                Map<String, Object> eventPosition) {
            doSetProperty("eventPosition", eventPosition);
            return this;
        }
        /**
         * Sets the map containing the event position to use for each partition
         * if a checkpoint for the partition does not exist in CheckpointStore.
         * This map is keyed off of the partition id. If there is no checkpoint
         * in CheckpointStore and there is no entry in this map, the processing
         * of the partition will start from {link EventPosition#latest() latest}
         * position.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String,
         * com.azure.messaging.eventhubs.models.EventPosition&gt;</code> type.
         * 
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder eventPosition(
                String eventPosition) {
            doSetProperty("eventPosition", eventPosition);
            return this;
        }
        /**
         * Sets the count used by the receiver to control the number of events
         * the Event Hub consumer will actively receive and queue locally
         * without regard to whether a receive operation is currently active.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 500
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder prefetchCount(int prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Sets the count used by the receiver to control the number of events
         * the Event Hub consumer will actively receive and queue locally
         * without regard to whether a receive operation is currently active.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 500
         * Group: consumer
         */
        default EventHubsEndpointConsumerBuilder prefetchCount(
                String prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Instead of supplying namespace, sharedAccessKey, sharedAccessName ...
         * etc, you can just supply the connection string for your eventHub. The
         * connection string for EventHubs already include all the necessary
         * information to connection to your EventHub. To learn on how to
         * generate the connection string, take a look at this documentation:
         * https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointConsumerBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * The generated value for the SharedAccessName.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointConsumerBuilder sharedAccessKey(
                String sharedAccessKey) {
            doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }
        /**
         * The name you chose for your EventHubs SAS keys.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointConsumerBuilder sharedAccessName(
                String sharedAccessName) {
            doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Event Hubs
     * component.
     */
    public interface AdvancedEventHubsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default EventHubsEndpointConsumerBuilder basic() {
            return (EventHubsEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedEventHubsEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedEventHubsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedEventHubsEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedEventHubsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Event Hubs component.
     */
    public interface EventHubsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedEventHubsEndpointProducerBuilder advanced() {
            return (AdvancedEventHubsEndpointProducerBuilder) this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpRetryOptions</code>
         * type.
         * 
         * Group: common
         */
        default EventHubsEndpointProducerBuilder amqpRetryOptions(
                Object amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpRetryOptions</code> type.
         * 
         * Group: common
         */
        default EventHubsEndpointProducerBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpTransportType</code>
         * type.
         * 
         * Default: AMQP
         * Group: common
         */
        default EventHubsEndpointProducerBuilder amqpTransportType(
                AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpTransportType</code> type.
         * 
         * Default: AMQP
         * Group: common
         */
        default EventHubsEndpointProducerBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default EventHubsEndpointProducerBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default EventHubsEndpointProducerBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default EventHubsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default EventHubsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets the identifier of the Event Hub partition that the {link
         * EventData events} will be sent to. If the identifier is not
         * specified, the Event Hubs service will be responsible for routing
         * events that are sent to an available partition.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default EventHubsEndpointProducerBuilder partitionId(String partitionId) {
            doSetProperty("partitionId", partitionId);
            return this;
        }
        /**
         * Sets a hashing key to be provided for the batch of events, which
         * instructs the Event Hubs service to map this key to a specific
         * partition. The selection of a partition is stable for a given
         * partition hashing key. Should any other batches of events be sent
         * using the same exact partition hashing key, the Event Hubs service
         * will route them all to the same partition. This should be specified
         * only when there is a need to group events by partition, but there is
         * flexibility into which partition they are routed. If ensuring that a
         * batch of events is sent only to a specific partition, it is
         * recommended that the {link #setPartitionId(String) identifier of the
         * position be specified directly} when sending the batch.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default EventHubsEndpointProducerBuilder partitionKey(
                String partitionKey) {
            doSetProperty("partitionKey", partitionKey);
            return this;
        }
        /**
         * Sets the EventHubProducerAsyncClient.An asynchronous producer
         * responsible for transmitting EventData to a specific Event Hub,
         * grouped together in batches. Depending on the {link
         * CreateBatchOptions options} specified when creating an
         * {linkEventDataBatch}, the events may be automatically routed to an
         * available partition or specific to a partition. Use by this component
         * to produce the data in camel producer.
         * 
         * The option is a:
         * <code>com.azure.messaging.eventhubs.EventHubProducerAsyncClient</code> type.
         * 
         * Group: producer
         */
        default EventHubsEndpointProducerBuilder producerAsyncClient(
                Object producerAsyncClient) {
            doSetProperty("producerAsyncClient", producerAsyncClient);
            return this;
        }
        /**
         * Sets the EventHubProducerAsyncClient.An asynchronous producer
         * responsible for transmitting EventData to a specific Event Hub,
         * grouped together in batches. Depending on the {link
         * CreateBatchOptions options} specified when creating an
         * {linkEventDataBatch}, the events may be automatically routed to an
         * available partition or specific to a partition. Use by this component
         * to produce the data in camel producer.
         * 
         * The option will be converted to a
         * <code>com.azure.messaging.eventhubs.EventHubProducerAsyncClient</code> type.
         * 
         * Group: producer
         */
        default EventHubsEndpointProducerBuilder producerAsyncClient(
                String producerAsyncClient) {
            doSetProperty("producerAsyncClient", producerAsyncClient);
            return this;
        }
        /**
         * Instead of supplying namespace, sharedAccessKey, sharedAccessName ...
         * etc, you can just supply the connection string for your eventHub. The
         * connection string for EventHubs already include all the necessary
         * information to connection to your EventHub. To learn on how to
         * generate the connection string, take a look at this documentation:
         * https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointProducerBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * The generated value for the SharedAccessName.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointProducerBuilder sharedAccessKey(
                String sharedAccessKey) {
            doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }
        /**
         * The name you chose for your EventHubs SAS keys.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointProducerBuilder sharedAccessName(
                String sharedAccessName) {
            doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Event Hubs
     * component.
     */
    public interface AdvancedEventHubsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default EventHubsEndpointProducerBuilder basic() {
            return (EventHubsEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Azure Event Hubs component.
     */
    public interface EventHubsEndpointBuilder
            extends
                EventHubsEndpointConsumerBuilder,
                EventHubsEndpointProducerBuilder {
        default AdvancedEventHubsEndpointBuilder advanced() {
            return (AdvancedEventHubsEndpointBuilder) this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpRetryOptions</code>
         * type.
         * 
         * Group: common
         */
        default EventHubsEndpointBuilder amqpRetryOptions(
                Object amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the retry policy for EventHubAsyncClient. If not specified, the
         * default retry options are used.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpRetryOptions</code> type.
         * 
         * Group: common
         */
        default EventHubsEndpointBuilder amqpRetryOptions(
                String amqpRetryOptions) {
            doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option is a: <code>com.azure.core.amqp.AmqpTransportType</code>
         * type.
         * 
         * Default: AMQP
         * Group: common
         */
        default EventHubsEndpointBuilder amqpTransportType(
                AmqpTransportType amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Sets the transport type by which all the communication with Azure
         * Event Hubs occurs. Default value is AmqpTransportType#AMQP.
         * 
         * The option will be converted to a
         * <code>com.azure.core.amqp.AmqpTransportType</code> type.
         * 
         * Default: AMQP
         * Group: common
         */
        default EventHubsEndpointBuilder amqpTransportType(
                String amqpTransportType) {
            doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default EventHubsEndpointBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default EventHubsEndpointBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Instead of supplying namespace, sharedAccessKey, sharedAccessName ...
         * etc, you can just supply the connection string for your eventHub. The
         * connection string for EventHubs already include all the necessary
         * information to connection to your EventHub. To learn on how to
         * generate the connection string, take a look at this documentation:
         * https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointBuilder connectionString(
                String connectionString) {
            doSetProperty("connectionString", connectionString);
            return this;
        }
        /**
         * The generated value for the SharedAccessName.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointBuilder sharedAccessKey(String sharedAccessKey) {
            doSetProperty("sharedAccessKey", sharedAccessKey);
            return this;
        }
        /**
         * The name you chose for your EventHubs SAS keys.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default EventHubsEndpointBuilder sharedAccessName(
                String sharedAccessName) {
            doSetProperty("sharedAccessName", sharedAccessName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Event Hubs component.
     */
    public interface AdvancedEventHubsEndpointBuilder
            extends
                AdvancedEventHubsEndpointConsumerBuilder,
                AdvancedEventHubsEndpointProducerBuilder {
        default EventHubsEndpointBuilder basic() {
            return (EventHubsEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedEventHubsEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for <code>com.azure.core.amqp.AmqpTransportType</code> enum.
     */
    enum AmqpTransportType {
        AMQP,
        AMQP_WEB_SOCKETS;
    }

    public interface EventHubsBuilders {
        /**
         * Azure Event Hubs (camel-azure-eventhubs)
         * The azure-eventhubs component that integrates Azure Event Hubs using
         * AMQP protocol. Azure EventHubs is a highly scalable publish-subscribe
         * service that can ingest millions of events per second and stream them
         * to multiple consumers.
         * 
         * Category: cloud,messaging
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-azure-eventhubs
         * 
         * Syntax: <code>azure-eventhubs:namespace/eventHubName</code>
         * 
         * Path parameter: namespace
         * EventHubs namespace created in Azure Portal
         * 
         * Path parameter: eventHubName
         * EventHubs name under a specific namcespace
         * 
         * @param path namespace/eventHubName
         */
        default EventHubsEndpointBuilder azureEventhubs(String path) {
            return EventHubsEndpointBuilderFactory.endpointBuilder("azure-eventhubs", path);
        }
        /**
         * Azure Event Hubs (camel-azure-eventhubs)
         * The azure-eventhubs component that integrates Azure Event Hubs using
         * AMQP protocol. Azure EventHubs is a highly scalable publish-subscribe
         * service that can ingest millions of events per second and stream them
         * to multiple consumers.
         * 
         * Category: cloud,messaging
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-azure-eventhubs
         * 
         * Syntax: <code>azure-eventhubs:namespace/eventHubName</code>
         * 
         * Path parameter: namespace
         * EventHubs namespace created in Azure Portal
         * 
         * Path parameter: eventHubName
         * EventHubs name under a specific namcespace
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path namespace/eventHubName
         */
        default EventHubsEndpointBuilder azureEventhubs(
                String componentName,
                String path) {
            return EventHubsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static EventHubsEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class EventHubsEndpointBuilderImpl extends AbstractEndpointBuilder implements EventHubsEndpointBuilder, AdvancedEventHubsEndpointBuilder {
            public EventHubsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new EventHubsEndpointBuilderImpl(path);
    }
}