/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Service;
import org.apache.camel.language.groovy.GroovyExpression;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.TypedLanguageSupport;
import org.codehaus.groovy.runtime.InvokerHelper;

@Language(value="groovy")
public class GroovyLanguage
extends TypedLanguageSupport
implements ScriptingLanguage {
    private final boolean loadExternalResource;
    private final Map<String, GroovyClassService> scriptCache;

    private GroovyLanguage(Map<String, GroovyClassService> scriptCache, boolean loadExternalResource) {
        this.scriptCache = scriptCache;
        this.loadExternalResource = loadExternalResource;
    }

    public GroovyLanguage() {
        this(LRUCacheFactory.newLRUSoftCache((int)16, (int)1000, (boolean)true), true);
    }

    public static GroovyExpression groovy(String expression) {
        return new GroovyLanguage().createExpression(expression);
    }

    public GroovyExpression createPredicate(String expression) {
        return this.createExpression(expression);
    }

    public GroovyExpression createExpression(String expression) {
        expression = this.loadResource(expression);
        return new GroovyExpression(expression);
    }

    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        Class clazz;
        if (this.loadExternalResource) {
            script = this.loadResource(script);
        }
        if ((clazz = this.getScriptFromCache(script)) == null) {
            ClassLoader cl = this.getCamelContext().getApplicationContextClassLoader();
            GroovyShell shell = new GroovyShell(cl);
            clazz = shell.getClassLoader().parseClass(script);
            this.addScriptToCache(script, clazz);
        }
        Script gs = (Script)ObjectHelper.newInstance(clazz, Script.class);
        if (bindings != null) {
            gs.setBinding(new Binding(bindings));
        }
        Object value = gs.run();
        return (T)this.getCamelContext().getTypeConverter().convertTo(resultType, value);
    }

    Class<Script> getScriptFromCache(String script) {
        GroovyClassService cached = this.scriptCache.get(script);
        if (cached == null) {
            return null;
        }
        return cached.script;
    }

    void addScriptToCache(String script, Class<Script> scriptClass) {
        this.scriptCache.put(script, new GroovyClassService(scriptClass));
    }

    private static final class GroovyClassService
    implements Service {
        private final Class<Script> script;

        private GroovyClassService(Class<Script> script) {
            this.script = script;
        }

        public void start() {
        }

        public void stop() {
            InvokerHelper.removeClass(this.script);
        }
    }

    public static class Builder {
        private final Map<String, GroovyClassService> cache = new HashMap<String, GroovyClassService>();

        public void addScript(String content, Class<Script> scriptClass) {
            this.cache.put(content, new GroovyClassService(scriptClass));
        }

        public GroovyLanguage build() {
            return new GroovyLanguage(Collections.unmodifiableMap(this.cache), false);
        }
    }
}

