/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hawtdb;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.component.hawtdb.HawtDBCamelCodec;
import org.apache.camel.component.hawtdb.HawtDBFile;
import org.apache.camel.component.hawtdb.Work;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.OptimisticUpdateException;
import org.fusesource.hawtdb.api.SortedIndex;
import org.fusesource.hawtdb.api.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtDBAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository,
OptimisticLockingAggregationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(HawtDBAggregationRepository.class);
    private HawtDBFile hawtDBFile;
    private String persistentFileName;
    private String repositoryName;
    private int bufferSize = 0x800000;
    private boolean sync = true;
    private short pageSize = (short)512;
    private boolean returnOldExchange;
    private HawtDBCamelCodec codec = new HawtDBCamelCodec();
    private long recoveryInterval = 5000L;
    private boolean useRecovery = true;
    private int maximumRedeliveries;
    private String deadLetterUri;
    private boolean allowSerializedHeaders;

    public HawtDBAggregationRepository() {
    }

    public HawtDBAggregationRepository(String repositoryName) {
        StringHelper.notEmpty((String)repositoryName, (String)"repositoryName");
        this.repositoryName = repositoryName;
    }

    public HawtDBAggregationRepository(String repositoryName, String persistentFileName) {
        StringHelper.notEmpty((String)repositoryName, (String)"repositoryName");
        StringHelper.notEmpty((String)persistentFileName, (String)"persistentFileName");
        this.repositoryName = repositoryName;
        this.persistentFileName = persistentFileName;
    }

    public HawtDBAggregationRepository(String repositoryName, HawtDBFile hawtDBFile) {
        StringHelper.notEmpty((String)repositoryName, (String)"repositoryName");
        ObjectHelper.notNull((Object)((Object)hawtDBFile), (String)"hawtDBFile");
        this.hawtDBFile = hawtDBFile;
        this.repositoryName = repositoryName;
    }

    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        return this.doAdd(camelContext, key, exchange, true);
    }

    public Exchange add(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) throws OptimisticLockingAggregationRepository.OptimisticLockingException {
        try {
            return this.doAdd(camelContext, key, newExchange, false);
        }
        catch (OptimisticUpdateException e) {
            throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
        }
    }

    protected Exchange doAdd(CamelContext camelContext, final String key, Exchange exchange, boolean handleOptimisticLockingException) {
        LOG.debug("Adding key [{}] -> {}", (Object)key, (Object)exchange);
        try {
            final Buffer keyBuffer = this.codec.marshallKey(key);
            final Buffer exchangeBuffer = this.codec.marshallExchange(camelContext, exchange, this.allowSerializedHeaders);
            Buffer rc = this.hawtDBFile.execute(new Work<Buffer>(){

                @Override
                public Buffer execute(Transaction tx) {
                    SortedIndex<Buffer, Buffer> index = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, HawtDBAggregationRepository.this.repositoryName, true);
                    Buffer buffer = (Buffer)index.put((Object)keyBuffer, (Object)exchangeBuffer);
                    LOG.trace("Added key index {}", (Object)keyBuffer);
                    return buffer;
                }

                public String toString() {
                    return "Adding key [" + key + "]";
                }
            }, handleOptimisticLockingException);
            if (rc == null) {
                return null;
            }
            if (this.isReturnOldExchange()) {
                return this.codec.unmarshallExchange(camelContext, rc);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error adding to repository " + this.repositoryName + " with key " + key, e);
        }
        return null;
    }

    public Exchange get(CamelContext camelContext, final String key) {
        Exchange answer = null;
        try {
            final Buffer keyBuffer = this.codec.marshallKey(key);
            Buffer rc = this.hawtDBFile.execute(new Work<Buffer>(){

                @Override
                public Buffer execute(Transaction tx) {
                    SortedIndex<Buffer, Buffer> index = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, HawtDBAggregationRepository.this.repositoryName, false);
                    if (index == null) {
                        return null;
                    }
                    Buffer buffer = (Buffer)index.get((Object)keyBuffer);
                    LOG.trace("Getting key index {}", (Object)keyBuffer);
                    return buffer;
                }

                public String toString() {
                    return "Getting key [" + key + "]";
                }
            });
            if (rc != null) {
                answer = this.codec.unmarshallExchange(camelContext, rc);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting key " + key + " from repository " + this.repositoryName, e);
        }
        LOG.debug("Getting key  [{}] -> {}", (Object)key, (Object)answer);
        return answer;
    }

    public void remove(CamelContext camelContext, final String key, Exchange exchange) {
        LOG.debug("Removing key [{}]", (Object)key);
        try {
            final Buffer keyBuffer = this.codec.marshallKey(key);
            final Buffer confirmKeyBuffer = this.codec.marshallKey(exchange.getExchangeId());
            final Buffer exchangeBuffer = this.codec.marshallExchange(camelContext, exchange, this.allowSerializedHeaders);
            this.hawtDBFile.execute(new Work<Buffer>(){

                @Override
                public Buffer execute(Transaction tx) {
                    SortedIndex<Buffer, Buffer> index = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, HawtDBAggregationRepository.this.repositoryName, true);
                    Buffer buffer = (Buffer)index.remove((Object)keyBuffer);
                    LOG.trace("Removed key index {} -> {}", (Object)keyBuffer, (Object)buffer);
                    SortedIndex<Buffer, Buffer> indexCompleted = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, HawtDBAggregationRepository.this.getRepositoryNameCompleted(), true);
                    indexCompleted.put((Object)confirmKeyBuffer, (Object)exchangeBuffer);
                    LOG.trace("Added confirm index {}", (Object)confirmKeyBuffer);
                    return null;
                }

                public String toString() {
                    return "Removing key [" + key + "]";
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error removing key " + key + " from repository " + this.repositoryName, e);
        }
    }

    public void confirm(CamelContext camelContext, final String exchangeId) {
        LOG.debug("Confirming exchangeId [{}]", (Object)exchangeId);
        try {
            final Buffer confirmKeyBuffer = this.codec.marshallKey(exchangeId);
            this.hawtDBFile.execute(new Work<Buffer>(){

                @Override
                public Buffer execute(Transaction tx) {
                    SortedIndex<Buffer, Buffer> indexCompleted = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, HawtDBAggregationRepository.this.getRepositoryNameCompleted(), true);
                    Buffer buffer = (Buffer)indexCompleted.remove((Object)confirmKeyBuffer);
                    LOG.trace("Removed confirm index {} -> {}", (Object)confirmKeyBuffer, (Object)buffer);
                    return buffer;
                }

                public String toString() {
                    return "Confirming exchangeId [" + exchangeId + "]";
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error confirming exchangeId " + exchangeId + " from repository " + this.repositoryName, e);
        }
    }

    public Set<String> getKeys() {
        final LinkedHashSet keys = new LinkedHashSet();
        this.hawtDBFile.execute(new Work<Buffer>(){

            @Override
            public Buffer execute(Transaction tx) {
                if (!HawtDBAggregationRepository.this.isRunAllowed()) {
                    return null;
                }
                SortedIndex<Buffer, Buffer> index = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, HawtDBAggregationRepository.this.repositoryName, false);
                if (index == null) {
                    return null;
                }
                Iterator it = index.iterator();
                while (it.hasNext() && HawtDBAggregationRepository.this.isRunAllowed()) {
                    String key;
                    Map.Entry entry = (Map.Entry)it.next();
                    Buffer keyBuffer = (Buffer)entry.getKey();
                    try {
                        key = HawtDBAggregationRepository.this.codec.unmarshallKey(keyBuffer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error unmarshalling key: " + keyBuffer, e);
                    }
                    if (key == null) continue;
                    LOG.trace("getKey [{}]", (Object)key);
                    keys.add(key);
                }
                return null;
            }

            public String toString() {
                return "getKeys";
            }
        });
        return Collections.unmodifiableSet(keys);
    }

    public Set<String> scan(CamelContext camelContext) {
        final LinkedHashSet<String> answer = new LinkedHashSet<String>();
        this.hawtDBFile.execute(new Work<Buffer>(){

            @Override
            public Buffer execute(Transaction tx) {
                if (!HawtDBAggregationRepository.this.isRunAllowed()) {
                    return null;
                }
                SortedIndex<Buffer, Buffer> indexCompleted = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, HawtDBAggregationRepository.this.getRepositoryNameCompleted(), false);
                if (indexCompleted == null) {
                    return null;
                }
                Iterator it = indexCompleted.iterator();
                while (it.hasNext() && HawtDBAggregationRepository.this.isRunAllowed()) {
                    String exchangeId;
                    Map.Entry entry = (Map.Entry)it.next();
                    Buffer keyBuffer = (Buffer)entry.getKey();
                    try {
                        exchangeId = HawtDBAggregationRepository.this.codec.unmarshallKey(keyBuffer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error unmarshalling confirm key: " + keyBuffer, e);
                    }
                    if (exchangeId == null) continue;
                    LOG.trace("Scan exchangeId [{}]", (Object)exchangeId);
                    answer.add(exchangeId);
                }
                return null;
            }

            public String toString() {
                return "Scan";
            }
        });
        if (answer.size() == 0) {
            LOG.trace("Scanned and found no exchange to recover.");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Scanned and found {} exchange(s) to recover (note some of them may already be in progress).", (Object)answer.size());
        }
        return answer;
    }

    public Exchange recover(CamelContext camelContext, final String exchangeId) {
        Exchange answer = null;
        try {
            final Buffer confirmKeyBuffer = this.codec.marshallKey(exchangeId);
            Buffer rc = this.hawtDBFile.execute(new Work<Buffer>(){

                @Override
                public Buffer execute(Transaction tx) {
                    SortedIndex<Buffer, Buffer> indexCompleted = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, HawtDBAggregationRepository.this.getRepositoryNameCompleted(), false);
                    if (indexCompleted == null) {
                        return null;
                    }
                    return (Buffer)indexCompleted.get((Object)confirmKeyBuffer);
                }

                public String toString() {
                    return "Recovering exchangeId [" + exchangeId + "]";
                }
            });
            if (rc != null) {
                answer = this.codec.unmarshallExchange(camelContext, rc);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error recovering exchangeId " + exchangeId + " from repository " + this.repositoryName, e);
        }
        LOG.debug("Recovering exchangeId [{}] -> {}", (Object)exchangeId, (Object)answer);
        return answer;
    }

    private int size(final String repositoryName) {
        int answer = this.hawtDBFile.execute(new Work<Integer>(){

            @Override
            public Integer execute(Transaction tx) {
                SortedIndex<Buffer, Buffer> index = HawtDBAggregationRepository.this.hawtDBFile.getRepositoryIndex(tx, repositoryName, false);
                return index != null ? index.size() : 0;
            }

            public String toString() {
                return "Size[" + repositoryName + "]";
            }
        });
        LOG.debug("Size of repository [{}] -> {}", (Object)repositoryName, (Object)answer);
        return answer;
    }

    public HawtDBFile getHawtDBFile() {
        return this.hawtDBFile;
    }

    public void setHawtDBFile(HawtDBFile hawtDBFile) {
        this.hawtDBFile = hawtDBFile;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private String getRepositoryNameCompleted() {
        return this.repositoryName + "-completed";
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getPersistentFileName() {
        return this.persistentFileName;
    }

    public void setPersistentFileName(String persistentFileName) {
        this.persistentFileName = persistentFileName;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isReturnOldExchange() {
        return this.returnOldExchange;
    }

    public void setReturnOldExchange(boolean returnOldExchange) {
        this.returnOldExchange = returnOldExchange;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public short getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(short pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    protected void doStart() throws Exception {
        if (this.hawtDBFile == null && this.persistentFileName != null) {
            this.hawtDBFile = new HawtDBFile();
            this.hawtDBFile.setFile(new File(this.persistentFileName));
            this.hawtDBFile.setSync(this.isSync());
            if (this.getBufferSize() != null) {
                this.hawtDBFile.setMappingSegementSize(this.getBufferSize());
            }
            if (this.getPageSize() > 0) {
                this.hawtDBFile.setPageSize(this.getPageSize());
            }
        }
        ObjectHelper.notNull((Object)((Object)this.hawtDBFile), (String)"Either set a persistentFileName or a hawtDBFile");
        ObjectHelper.notNull((Object)this.repositoryName, (String)"repositoryName");
        ServiceHelper.startService((Service)this.hawtDBFile);
        int current = this.size(this.getRepositoryName());
        int completed = this.size(this.getRepositoryNameCompleted());
        if (current > 0) {
            LOG.info("On startup there are " + current + " aggregate exchanges (not completed) in repository: " + this.getRepositoryName());
        } else {
            LOG.info("On startup there are no existing aggregate exchanges (not completed) in repository: " + this.getRepositoryName());
        }
        if (completed > 0) {
            LOG.warn("On startup there are " + completed + " completed exchanges to be recovered in repository: " + this.getRepositoryNameCompleted());
        } else {
            LOG.info("On startup there are no completed exchanges to be recovered in repository: " + this.getRepositoryNameCompleted());
        }
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.hawtDBFile));
    }
}

