/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;

public class HttpMessage
extends DefaultMessage {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final HttpCommonEndpoint endpoint;

    public HttpMessage(Exchange exchange, HttpCommonEndpoint endpoint, HttpServletRequest request, HttpServletResponse response) {
        this.setExchange(exchange);
        this.endpoint = endpoint;
        this.request = request;
        this.response = response;
        this.setHeader("CamelHttpServletRequest", request);
        this.setHeader("CamelHttpServletResponse", response);
        Boolean flag = (Boolean)exchange.getProperty("CamelSkipWwwFormUrlEncoding", Boolean.class);
        if (flag != null && flag.booleanValue()) {
            this.setHeader("CamelSkipWwwFormUrlEncoding", Boolean.TRUE);
        }
        endpoint.getHttpBinding().readRequest(request, this);
    }

    private HttpMessage(HttpServletRequest request, HttpServletResponse response, Exchange exchange, HttpCommonEndpoint endpoint) {
        this.request = request;
        this.response = response;
        this.setExchange(this.getExchange());
        this.endpoint = endpoint;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    protected Object createBody() {
        try {
            return this.endpoint.getHttpBinding().parseBody(this);
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public HttpMessage newInstance() {
        return new HttpMessage(this.request, this.response, this.getExchange(), this.endpoint);
    }

    public String toString() {
        return "HttpMessage@" + ObjectHelper.getIdentityHashCode((Object)((Object)this));
    }
}

