/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hystrix.processor;

import com.netflix.hystrix.HystrixCommand;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixProcessorCommandFallbackViaNetwork
extends HystrixCommand<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(HystrixProcessorCommandFallbackViaNetwork.class);
    private final Exchange exchange;
    private final Processor processor;

    public HystrixProcessorCommandFallbackViaNetwork(HystrixCommand.Setter setter, Exchange exchange, Processor processor) {
        super(setter);
        this.exchange = exchange;
        this.processor = processor;
    }

    protected Message getFallback() {
        return null;
    }

    protected Message run() throws Exception {
        LOG.debug("Running fallback processor: {} with exchange: {}", (Object)this.processor, (Object)this.exchange);
        try {
            this.processor.process(this.exchange);
        }
        catch (Throwable e) {
            this.exchange.setException(e);
        }
        if (this.exchange.getException() != null) {
            throw this.exchange.getException();
        }
        LOG.debug("Running fallback processor: {} with exchange: {} done", (Object)this.processor, (Object)this.exchange);
        return this.exchange.getMessage();
    }
}

