/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.RestBindingJaxbDataFormatFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.PropertyBindingSupport;

@JdkService(value="rest-binding-jaxb-dataformat-factory")
public class JaxbRestBindingJaxbDataFormatFactory
implements RestBindingJaxbDataFormatFactory {
    public void setupJaxb(CamelContext camelContext, RestConfiguration config, String type, String outType, DataFormat jaxb, DataFormat outJaxb) throws Exception {
        String typeName;
        GeneratedPropertyConfigurer configurer = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer("jaxb-dataformat-configurer", camelContext);
        if (configurer == null) {
            throw new IllegalStateException("Cannot find configurer for dataformat: jaxb");
        }
        PropertyBindingSupport.Builder builder = PropertyBindingSupport.build().withCamelContext(camelContext).withConfigurer((PropertyConfigurer)configurer).withTarget((Object)jaxb);
        if (type != null) {
            typeName = type.endsWith("[]") ? type.substring(0, type.length() - 2) : type;
            builder.withProperty("contextPath", (Object)typeName);
            builder.withProperty("contextPathIsClassName", (Object)"true");
        }
        this.setAdditionalConfiguration(config, "xml.in.", builder);
        builder.bind();
        builder = PropertyBindingSupport.build().withCamelContext(camelContext).withConfigurer((PropertyConfigurer)configurer).withTarget((Object)outJaxb);
        if (outType != null) {
            typeName = outType.endsWith("[]") ? outType.substring(0, outType.length() - 2) : outType;
            builder.withProperty("contextPath", (Object)typeName);
            builder.withProperty("contextPathIsClassName", (Object)"true");
        } else if (type != null) {
            typeName = type.endsWith("[]") ? type.substring(0, type.length() - 2) : type;
            builder.withProperty("contextPath", (Object)typeName);
            builder.withProperty("contextPathIsClassName", (Object)"true");
        }
        this.setAdditionalConfiguration(config, "xml.out.", builder);
        builder.bind();
    }

    private void setAdditionalConfiguration(RestConfiguration config, String prefix, PropertyBindingSupport.Builder builder) throws Exception {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap copy = new HashMap();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            builder.withProperties(copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }
}

