/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.workitem;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.jbpm.workitem.AbstractCamelCommand;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.api.executor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalContextCamelCommand
extends AbstractCamelCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalContextCamelCommand.class);
    private final ProducerTemplate globalContextProducerTemplate;

    public GlobalContextCamelCommand() {
        CamelContext globalCamelContext = (CamelContext)ServiceRegistry.get().service("GlobalCamelService");
        this.globalContextProducerTemplate = globalCamelContext.createProducerTemplate();
    }

    @Override
    protected ProducerTemplate getProducerTemplate(CommandContext ctx) {
        return this.globalContextProducerTemplate;
    }

    public void close() {
        try {
            this.globalContextProducerTemplate.stop();
        }
        catch (Exception e) {
            LOGGER.warn("Error encountered while closing the Camel Producer Template.", (Throwable)e);
        }
    }
}

