/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.SeekPolicy;
import org.apache.camel.component.kafka.consumer.support.KafkaConsumerResumeAdapter;
import org.apache.camel.component.kafka.consumer.support.KafkaResumable;
import org.apache.camel.component.kafka.consumer.support.OffsetKafkaConsumerResumeAdapter;
import org.apache.camel.component.kafka.consumer.support.SeekPolicyKafkaConsumerResumeAdapter;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResumeStrategyFactory {
    private static final NoOpKafkaConsumerResumeAdapter NO_OP_RESUME_STRATEGY = new NoOpKafkaConsumerResumeAdapter();
    private static final Logger LOG = LoggerFactory.getLogger(ResumeStrategyFactory.class);

    private ResumeStrategyFactory() {
    }

    public static KafkaConsumerResumeAdapter resolveResumeAdapter(KafkaConsumer kafkaConsumer) {
        ResumeStrategy resumeStrategy = kafkaConsumer.getResumeStrategy();
        if (resumeStrategy != null) {
            KafkaConsumerResumeAdapter adapter = (KafkaConsumerResumeAdapter)resumeStrategy.getAdapter(KafkaConsumerResumeAdapter.class);
            assert (adapter != null);
            return adapter;
        }
        KafkaConfiguration configuration = kafkaConsumer.getEndpoint().getConfiguration();
        return ResumeStrategyFactory.resolveBuiltinResumeAdapters(configuration);
    }

    private static KafkaConsumerResumeAdapter resolveBuiltinResumeAdapters(KafkaConfiguration configuration) {
        LOG.debug("No resume strategy was provided ... checking for built-ins ...");
        StateRepository<String, String> offsetRepository = configuration.getOffsetRepository();
        SeekPolicy seekTo = configuration.getSeekTo();
        if (offsetRepository != null) {
            LOG.info("Using resume from offset strategy");
            return new OffsetKafkaConsumerResumeAdapter(offsetRepository);
        }
        if (seekTo != null) {
            LOG.info("Using resume from seek policy strategy with seeking from {}", (Object)seekTo);
            return new SeekPolicyKafkaConsumerResumeAdapter(seekTo);
        }
        LOG.info("Using NO-OP resume strategy");
        return NO_OP_RESUME_STRATEGY;
    }

    private static class NoOpKafkaConsumerResumeAdapter
    implements KafkaConsumerResumeAdapter {
        private NoOpKafkaConsumerResumeAdapter() {
        }

        @Override
        public void setConsumer(Consumer<?, ?> consumer) {
        }

        @Override
        public void setKafkaResumable(KafkaResumable kafkaResumable) {
        }

        public void resume() {
        }
    }
}

