/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MailProducer.class);
    private final JavaMailSender defaultSender;

    public MailProducer(MailEndpoint endpoint, JavaMailSender sender) {
        super((Endpoint)endpoint);
        this.defaultSender = sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        JavaMailSender mailSender = this.getSender(exchange);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            MimeMessage mimeMessage;
            Object body;
            ClassLoader applicationClassLoader = this.getEndpoint().getCamelContext().getApplicationContextClassLoader();
            if (applicationClassLoader != null) {
                Thread.currentThread().setContextClassLoader(applicationClassLoader);
            }
            if ((body = exchange.getIn().getBody()) instanceof MimeMessage) {
                mimeMessage = (MimeMessage)body;
            } else {
                mimeMessage = new MimeMessage(mailSender.getSession());
                this.getEndpoint().getBinding().populateMailMessage(this.getEndpoint(), mimeMessage, exchange);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending MimeMessage: {}", (Object)MailUtils.dumpMessage((Message)mimeMessage));
            }
            mailSender.send(mimeMessage);
            exchange.getIn().setHeader("CamelMailMessageId", (Object)mimeMessage.getMessageID());
        }
        catch (IOException | MessagingException e) {
            exchange.setException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        callback.done(true);
        return true;
    }

    public MailEndpoint getEndpoint() {
        return (MailEndpoint)super.getEndpoint();
    }

    protected JavaMailSender getSender(Exchange exchange) {
        Map additional = URISupport.extractProperties((Map)exchange.getMessage().getHeaders(), (String)"mail.smtp.");
        if (additional.isEmpty()) {
            LOG.trace("Using default JavaMailSender");
            return this.defaultSender;
        }
        LOG.debug("Creating new JavaMailSender to include additional {} java mail properties", (Object)additional.size());
        JavaMailSender customSender = this.getEndpoint().getConfiguration().createJavaMailSender();
        additional.forEach((k, v) -> {
            if (v != null) {
                customSender.addAdditionalJavaMailProperty("mail.smtp." + k, v.toString());
            }
        });
        return customSender;
    }
}

