/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics.messagehistory;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.metrics.messagehistory.MetricsMessageHistoryMBean;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.service.ServiceSupport;

@ManagedResource(description="MetricsMessageHistory")
public final class MetricsMessageHistoryService
extends ServiceSupport
implements CamelContextAware,
StaticService,
MetricsMessageHistoryMBean {
    private CamelContext camelContext;
    private MetricRegistry metricsRegistry;
    private JmxReporter reporter;
    private boolean useJmx;
    private String jmxDomain = "org.apache.camel.metrics";
    private boolean prettyPrint;
    private TimeUnit rateUnit = TimeUnit.SECONDS;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private transient ObjectMapper mapper;
    private transient ObjectMapper secondsMapper;

    public MetricRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setMetricsRegistry(MetricRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isUseJmx() {
        return this.useJmx;
    }

    public void setUseJmx(boolean useJmx) {
        this.useJmx = useJmx;
    }

    public String getJmxDomain() {
        return this.jmxDomain;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    public void setRateUnit(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.metricsRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            this.metricsRegistry = (MetricRegistry)camelRegistry.lookupByNameAndType("metricRegistry", MetricRegistry.class);
            if (this.metricsRegistry == null) {
                this.metricsRegistry = new MetricRegistry();
            }
        }
        this.mapper = new ObjectMapper().registerModule((Module)new MetricsModule(this.getRateUnit(), this.getDurationUnit(), false));
        this.secondsMapper = this.getRateUnit() == TimeUnit.SECONDS && this.getDurationUnit() == TimeUnit.SECONDS ? this.mapper : new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.SECONDS, false));
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.useJmx) {
            ManagementAgent agent = this.getCamelContext().getManagementStrategy().getManagementAgent();
            if (agent != null) {
                MBeanServer server = agent.getMBeanServer();
                if (server != null) {
                    this.reporter = JmxReporter.forRegistry((MetricRegistry)this.metricsRegistry).registerWith(server).inDomain(this.jmxDomain).build();
                    this.reporter.start();
                }
            } else {
                throw new IllegalStateException("CamelContext has not enabled JMX");
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.reporter != null) {
            this.reporter.stop();
            this.reporter = null;
        }
    }

    @Override
    public String dumpStatisticsAsJson() {
        ObjectWriter writer = this.mapper.writer();
        if (this.isPrettyPrint()) {
            writer = writer.withDefaultPrettyPrinter();
        }
        try {
            return writer.writeValueAsString((Object)this.getMetricsRegistry());
        }
        catch (JsonProcessingException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public String dumpStatisticsAsJsonTimeUnitSeconds() {
        ObjectWriter writer = this.secondsMapper.writer();
        if (this.isPrettyPrint()) {
            writer = writer.withDefaultPrettyPrinter();
        }
        try {
            return writer.writeValueAsString((Object)this.getMetricsRegistry());
        }
        catch (JsonProcessingException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public void reset() {
        this.metricsRegistry.removeMatching(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return true;
            }
        });
    }
}

