/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.List;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.microprofile.metrics.AbstractMicroProfileMetricsProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsEndpoint;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsHistogramProducer
extends AbstractMicroProfileMetricsProducer<Histogram> {
    public MicroProfileMetricsHistogramProducer(MicroProfileMetricsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MicroProfileMetricsEndpoint endpoint, Histogram histogram) {
        Long value = this.getLongHeader(exchange.getIn(), "CamelMicroProfileMetricsHistogramValue", endpoint.getValue());
        if (value != null) {
            histogram.update(value.longValue());
        }
    }

    @Override
    protected Function<MetricRegistry, Histogram> registerMetric(Metadata metadata, List<Tag> tags) {
        return metricRegistry -> metricRegistry.histogram(metadata, tags.toArray(new Tag[0]));
    }
}

