/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.StreamCache;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockExpressionClause;
import org.apache.camel.component.mock.MockExpressionClauseSupport;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.component.mock.TimeClause;
import org.apache.camel.support.PredicateAssertHelper;

public abstract class AssertionClause
extends MockExpressionClauseSupport<MockValueBuilder>
implements Runnable {
    protected final MockEndpoint mock;
    protected volatile int currentIndex;
    private final Set<Predicate> predicates = new LinkedHashSet<Predicate>();
    private final Expression previous = new PreviousTimestamp();
    private final Expression next = new NextTimestamp();

    public AssertionClause(MockEndpoint mock) {
        super(null);
        this.mock = mock;
    }

    @Override
    public MockValueBuilder expression(Expression expression) {
        super.expression(expression);
        return new PredicateValueBuilder(expression);
    }

    @Override
    public MockValueBuilder language(ExpressionFactory expression) {
        super.expression(expression.createExpression(this.mock.getCamelContext()));
        return new PredicateValueBuilder(this.getExpressionValue());
    }

    public AssertionClause predicate(Predicate predicate) {
        this.addPredicate(predicate);
        return this;
    }

    public MockExpressionClause<AssertionClause> predicate() {
        MockExpressionClause<AssertionClause> clause = new MockExpressionClause<AssertionClause>(this);
        this.addPredicate(clause);
        return clause;
    }

    public TimeClause arrives() {
        final TimeClause clause = new TimeClause(this.previous, this.next);
        this.addPredicate(new Predicate(){

            public boolean matches(Exchange exchange) {
                return clause.matches(exchange);
            }

            public String toString() {
                return "arrives " + clause.toString() + " exchange";
            }
        });
        return clause;
    }

    protected void applyAssertionOn(MockEndpoint endpoint, int index, Exchange exchange) {
        for (Predicate predicate : this.predicates) {
            Object value;
            this.currentIndex = index;
            if (exchange != null && (value = exchange.getMessage().getBody()) instanceof StreamCache) {
                ((StreamCache)value).reset();
            }
            predicate.init(endpoint.getCamelContext());
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)("Assertion error at index " + index + " on mock " + endpoint.getEndpointUri() + " with predicate: "), (Exchange)exchange);
        }
    }

    protected void addPredicate(Predicate predicate) {
        this.predicates.add(predicate);
    }

    public final class PredicateValueBuilder
    extends MockValueBuilder {
        public PredicateValueBuilder(Expression expression) {
            super(expression);
        }

        @Override
        protected Predicate onNewPredicate(Predicate predicate) {
            predicate = super.onNewPredicate(predicate);
            AssertionClause.this.addPredicate(predicate);
            return predicate;
        }

        @Override
        protected MockValueBuilder onNewValueBuilder(Expression exp) {
            return new PredicateValueBuilder(exp);
        }
    }

    private final class NextTimestamp
    implements Expression {
        private NextTimestamp() {
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            Date answer = null;
            if (AssertionClause.this.currentIndex < AssertionClause.this.mock.getReceivedCounter() - 1) {
                answer = (Date)AssertionClause.this.mock.getReceivedExchanges().get(AssertionClause.this.currentIndex + 1).getProperty("CamelReceivedTimestamp", Date.class);
            }
            return (T)answer;
        }
    }

    private final class PreviousTimestamp
    implements Expression {
        private PreviousTimestamp() {
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            Date answer = null;
            if (AssertionClause.this.currentIndex > 0 && AssertionClause.this.mock.getReceivedCounter() > 0) {
                answer = (Date)AssertionClause.this.mock.getReceivedExchanges().get(AssertionClause.this.currentIndex - 1).getProperty("CamelReceivedTimestamp", Date.class);
            }
            return (T)answer;
        }
    }
}

