/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class NettyComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private NettyConfiguration getOrCreateConfiguration(NettyComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new NettyConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        NettyComponent target = (NettyComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowdefaultcodec": 
            case "allowDefaultCodec": {
                this.getOrCreateConfiguration(target).setAllowDefaultCodec((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                this.getOrCreateConfiguration(target).setAllowSerializedHeaders((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoappenddelimiter": 
            case "autoAppendDelimiter": {
                this.getOrCreateConfiguration(target).setAutoAppendDelimiter((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "backlog": {
                this.getOrCreateConfiguration(target).setBacklog((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bosscount": 
            case "bossCount": {
                this.getOrCreateConfiguration(target).setBossCount((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "bossgroup": 
            case "bossGroup": {
                this.getOrCreateConfiguration(target).setBossGroup((EventLoopGroup)NettyComponentConfigurer.property((CamelContext)camelContext, EventLoopGroup.class, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "broadcast": {
                this.getOrCreateConfiguration(target).setBroadcast((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "channelgroup": 
            case "channelGroup": {
                this.getOrCreateConfiguration(target).setChannelGroup((ChannelGroup)NettyComponentConfigurer.property((CamelContext)camelContext, ChannelGroup.class, (Object)value));
                return true;
            }
            case "clientinitializerfactory": 
            case "clientInitializerFactory": {
                this.getOrCreateConfiguration(target).setClientInitializerFactory((ClientInitializerFactory)((Object)NettyComponentConfigurer.property((CamelContext)camelContext, ClientInitializerFactory.class, (Object)value)));
                return true;
            }
            case "clientmode": 
            case "clientMode": {
                this.getOrCreateConfiguration(target).setClientMode((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((NettyConfiguration)NettyComponentConfigurer.property((CamelContext)camelContext, NettyConfiguration.class, (Object)value));
                return true;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                this.getOrCreateConfiguration(target).setConnectTimeout((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "correlationmanager": 
            case "correlationManager": {
                this.getOrCreateConfiguration(target).setCorrelationManager((NettyCamelStateCorrelationManager)NettyComponentConfigurer.property((CamelContext)camelContext, NettyCamelStateCorrelationManager.class, (Object)value));
                return true;
            }
            case "decodermaxlinelength": 
            case "decoderMaxLineLength": {
                this.getOrCreateConfiguration(target).setDecoderMaxLineLength((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "decoders": {
                this.getOrCreateConfiguration(target).setDecoders((List)NettyComponentConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "delimiter": {
                this.getOrCreateConfiguration(target).setDelimiter((TextLineDelimiter)((Object)NettyComponentConfigurer.property((CamelContext)camelContext, TextLineDelimiter.class, (Object)value)));
                return true;
            }
            case "disconnect": {
                this.getOrCreateConfiguration(target).setDisconnect((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disconnectonnoreply": 
            case "disconnectOnNoReply": {
                this.getOrCreateConfiguration(target).setDisconnectOnNoReply((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "enabledprotocols": 
            case "enabledProtocols": {
                this.getOrCreateConfiguration(target).setEnabledProtocols((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "encoders": {
                this.getOrCreateConfiguration(target).setEncoders((List)NettyComponentConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "encoding": {
                this.getOrCreateConfiguration(target).setEncoding((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "executorservice": 
            case "executorService": {
                target.setExecutorService((EventExecutorGroup)NettyComponentConfigurer.property((CamelContext)camelContext, EventExecutorGroup.class, (Object)value));
                return true;
            }
            case "keepalive": 
            case "keepAlive": {
                this.getOrCreateConfiguration(target).setKeepAlive((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keystorefile": 
            case "keyStoreFile": {
                this.getOrCreateConfiguration(target).setKeyStoreFile((File)NettyComponentConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "keystoreformat": 
            case "keyStoreFormat": {
                this.getOrCreateConfiguration(target).setKeyStoreFormat((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keystoreresource": 
            case "keyStoreResource": {
                this.getOrCreateConfiguration(target).setKeyStoreResource((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazychannelcreation": 
            case "lazyChannelCreation": {
                this.getOrCreateConfiguration(target).setLazyChannelCreation((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maximumpoolsize": 
            case "maximumPoolSize": {
                target.setMaximumPoolSize((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "nativetransport": 
            case "nativeTransport": {
                this.getOrCreateConfiguration(target).setNativeTransport((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "needclientauth": 
            case "needClientAuth": {
                this.getOrCreateConfiguration(target).setNeedClientAuth((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "nettyserverbootstrapfactory": 
            case "nettyServerBootstrapFactory": {
                this.getOrCreateConfiguration(target).setNettyServerBootstrapFactory((NettyServerBootstrapFactory)NettyComponentConfigurer.property((CamelContext)camelContext, NettyServerBootstrapFactory.class, (Object)value));
                return true;
            }
            case "networkinterface": 
            case "networkInterface": {
                this.getOrCreateConfiguration(target).setNetworkInterface((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "noreplyloglevel": 
            case "noReplyLogLevel": {
                this.getOrCreateConfiguration(target).setNoReplyLogLevel((LoggingLevel)NettyComponentConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "options": {
                this.getOrCreateConfiguration(target).setOptions((Map)NettyComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "passphrase": {
                this.getOrCreateConfiguration(target).setPassphrase((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "producerpoolenabled": 
            case "producerPoolEnabled": {
                this.getOrCreateConfiguration(target).setProducerPoolEnabled((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "producerpoolmaxactive": 
            case "producerPoolMaxActive": {
                this.getOrCreateConfiguration(target).setProducerPoolMaxActive((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "producerpoolmaxidle": 
            case "producerPoolMaxIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMaxIdle((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "producerpoolminevictableidle": 
            case "producerPoolMinEvictableIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMinEvictableIdle((Long)NettyComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "producerpoolminidle": 
            case "producerPoolMinIdle": {
                this.getOrCreateConfiguration(target).setProducerPoolMinIdle((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                this.getOrCreateConfiguration(target).setReceiveBufferSize((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "receivebuffersizepredictor": 
            case "receiveBufferSizePredictor": {
                this.getOrCreateConfiguration(target).setReceiveBufferSizePredictor((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "reconnect": {
                this.getOrCreateConfiguration(target).setReconnect((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "reconnectinterval": 
            case "reconnectInterval": {
                this.getOrCreateConfiguration(target).setReconnectInterval((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                this.getOrCreateConfiguration(target).setRequestTimeout((Long)NettyComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "reuseaddress": 
            case "reuseAddress": {
                this.getOrCreateConfiguration(target).setReuseAddress((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "reusechannel": 
            case "reuseChannel": {
                this.getOrCreateConfiguration(target).setReuseChannel((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "securityprovider": 
            case "securityProvider": {
                this.getOrCreateConfiguration(target).setSecurityProvider((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                this.getOrCreateConfiguration(target).setSendBufferSize((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "serverclosedchannelexceptioncaughtloglevel": 
            case "serverClosedChannelExceptionCaughtLogLevel": {
                this.getOrCreateConfiguration(target).setServerClosedChannelExceptionCaughtLogLevel((LoggingLevel)NettyComponentConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "serverexceptioncaughtloglevel": 
            case "serverExceptionCaughtLogLevel": {
                this.getOrCreateConfiguration(target).setServerExceptionCaughtLogLevel((LoggingLevel)NettyComponentConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "serverinitializerfactory": 
            case "serverInitializerFactory": {
                this.getOrCreateConfiguration(target).setServerInitializerFactory((ServerInitializerFactory)((Object)NettyComponentConfigurer.property((CamelContext)camelContext, ServerInitializerFactory.class, (Object)value)));
                return true;
            }
            case "ssl": {
                this.getOrCreateConfiguration(target).setSsl((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sslclientcertheaders": 
            case "sslClientCertHeaders": {
                this.getOrCreateConfiguration(target).setSslClientCertHeaders((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters((SSLContextParameters)NettyComponentConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "sslhandler": 
            case "sslHandler": {
                this.getOrCreateConfiguration(target).setSslHandler((SslHandler)NettyComponentConfigurer.property((CamelContext)camelContext, SslHandler.class, (Object)value));
                return true;
            }
            case "sync": {
                this.getOrCreateConfiguration(target).setSync((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                this.getOrCreateConfiguration(target).setTcpNoDelay((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "textline": {
                this.getOrCreateConfiguration(target).setTextline((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transferexchange": 
            case "transferExchange": {
                this.getOrCreateConfiguration(target).setTransferExchange((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "truststorefile": 
            case "trustStoreFile": {
                this.getOrCreateConfiguration(target).setTrustStoreFile((File)NettyComponentConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "truststoreresource": 
            case "trustStoreResource": {
                this.getOrCreateConfiguration(target).setTrustStoreResource((String)NettyComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "udpbytearraycodec": 
            case "udpByteArrayCodec": {
                this.getOrCreateConfiguration(target).setUdpByteArrayCodec((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "udpconnectionlesssending": 
            case "udpConnectionlessSending": {
                this.getOrCreateConfiguration(target).setUdpConnectionlessSending((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usebytebuf": 
            case "useByteBuf": {
                this.getOrCreateConfiguration(target).setUseByteBuf((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usingexecutorservice": 
            case "usingExecutorService": {
                this.getOrCreateConfiguration(target).setUsingExecutorService((Boolean)NettyComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "workercount": 
            case "workerCount": {
                this.getOrCreateConfiguration(target).setWorkerCount((Integer)NettyComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "workergroup": 
            case "workerGroup": {
                this.getOrCreateConfiguration(target).setWorkerGroup((EventLoopGroup)NettyComponentConfigurer.property((CamelContext)camelContext, EventLoopGroup.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("allowDefaultCodec", Boolean.TYPE);
        answer.put("allowSerializedHeaders", Boolean.TYPE);
        answer.put("autoAppendDelimiter", Boolean.TYPE);
        answer.put("backlog", Integer.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bossCount", Integer.TYPE);
        answer.put("bossGroup", EventLoopGroup.class);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("broadcast", Boolean.TYPE);
        answer.put("channelGroup", ChannelGroup.class);
        answer.put("clientInitializerFactory", ClientInitializerFactory.class);
        answer.put("clientMode", Boolean.TYPE);
        answer.put("configuration", NettyConfiguration.class);
        answer.put("connectTimeout", Integer.TYPE);
        answer.put("correlationManager", NettyCamelStateCorrelationManager.class);
        answer.put("decoderMaxLineLength", Integer.TYPE);
        answer.put("decoders", List.class);
        answer.put("delimiter", TextLineDelimiter.class);
        answer.put("disconnect", Boolean.TYPE);
        answer.put("disconnectOnNoReply", Boolean.TYPE);
        answer.put("enabledProtocols", String.class);
        answer.put("encoders", List.class);
        answer.put("encoding", String.class);
        answer.put("executorService", EventExecutorGroup.class);
        answer.put("keepAlive", Boolean.TYPE);
        answer.put("keyStoreFile", File.class);
        answer.put("keyStoreFormat", String.class);
        answer.put("keyStoreResource", String.class);
        answer.put("lazyChannelCreation", Boolean.TYPE);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("maximumPoolSize", Integer.TYPE);
        answer.put("nativeTransport", Boolean.TYPE);
        answer.put("needClientAuth", Boolean.TYPE);
        answer.put("nettyServerBootstrapFactory", NettyServerBootstrapFactory.class);
        answer.put("networkInterface", String.class);
        answer.put("noReplyLogLevel", LoggingLevel.class);
        answer.put("options", Map.class);
        answer.put("passphrase", String.class);
        answer.put("producerPoolEnabled", Boolean.TYPE);
        answer.put("producerPoolMaxActive", Integer.TYPE);
        answer.put("producerPoolMaxIdle", Integer.TYPE);
        answer.put("producerPoolMinEvictableIdle", Long.TYPE);
        answer.put("producerPoolMinIdle", Integer.TYPE);
        answer.put("receiveBufferSize", Integer.TYPE);
        answer.put("receiveBufferSizePredictor", Integer.TYPE);
        answer.put("reconnect", Boolean.TYPE);
        answer.put("reconnectInterval", Integer.TYPE);
        answer.put("requestTimeout", Long.TYPE);
        answer.put("reuseAddress", Boolean.TYPE);
        answer.put("reuseChannel", Boolean.TYPE);
        answer.put("securityProvider", String.class);
        answer.put("sendBufferSize", Integer.TYPE);
        answer.put("serverClosedChannelExceptionCaughtLogLevel", LoggingLevel.class);
        answer.put("serverExceptionCaughtLogLevel", LoggingLevel.class);
        answer.put("serverInitializerFactory", ServerInitializerFactory.class);
        answer.put("ssl", Boolean.TYPE);
        answer.put("sslClientCertHeaders", Boolean.TYPE);
        answer.put("sslContextParameters", SSLContextParameters.class);
        answer.put("sslHandler", SslHandler.class);
        answer.put("sync", Boolean.TYPE);
        answer.put("tcpNoDelay", Boolean.TYPE);
        answer.put("textline", Boolean.TYPE);
        answer.put("transferExchange", Boolean.TYPE);
        answer.put("trustStoreFile", File.class);
        answer.put("trustStoreResource", String.class);
        answer.put("udpByteArrayCodec", Boolean.TYPE);
        answer.put("udpConnectionlessSending", Boolean.TYPE);
        answer.put("useByteBuf", Boolean.TYPE);
        answer.put("useGlobalSslContextParameters", Boolean.TYPE);
        answer.put("usingExecutorService", Boolean.TYPE);
        answer.put("workerCount", Integer.TYPE);
        answer.put("workerGroup", EventLoopGroup.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        NettyComponent target = (NettyComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowdefaultcodec": 
            case "allowDefaultCodec": {
                return this.getOrCreateConfiguration(target).isAllowDefaultCodec();
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return this.getOrCreateConfiguration(target).isAllowSerializedHeaders();
            }
            case "autoappenddelimiter": 
            case "autoAppendDelimiter": {
                return this.getOrCreateConfiguration(target).isAutoAppendDelimiter();
            }
            case "backlog": {
                return this.getOrCreateConfiguration(target).getBacklog();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bosscount": 
            case "bossCount": {
                return this.getOrCreateConfiguration(target).getBossCount();
            }
            case "bossgroup": 
            case "bossGroup": {
                return this.getOrCreateConfiguration(target).getBossGroup();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "broadcast": {
                return this.getOrCreateConfiguration(target).isBroadcast();
            }
            case "channelgroup": 
            case "channelGroup": {
                return this.getOrCreateConfiguration(target).getChannelGroup();
            }
            case "clientinitializerfactory": 
            case "clientInitializerFactory": {
                return this.getOrCreateConfiguration(target).getClientInitializerFactory();
            }
            case "clientmode": 
            case "clientMode": {
                return this.getOrCreateConfiguration(target).isClientMode();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return this.getOrCreateConfiguration(target).getConnectTimeout();
            }
            case "correlationmanager": 
            case "correlationManager": {
                return this.getOrCreateConfiguration(target).getCorrelationManager();
            }
            case "decodermaxlinelength": 
            case "decoderMaxLineLength": {
                return this.getOrCreateConfiguration(target).getDecoderMaxLineLength();
            }
            case "decoders": {
                return this.getOrCreateConfiguration(target).getDecoders();
            }
            case "delimiter": {
                return this.getOrCreateConfiguration(target).getDelimiter();
            }
            case "disconnect": {
                return this.getOrCreateConfiguration(target).isDisconnect();
            }
            case "disconnectonnoreply": 
            case "disconnectOnNoReply": {
                return this.getOrCreateConfiguration(target).isDisconnectOnNoReply();
            }
            case "enabledprotocols": 
            case "enabledProtocols": {
                return this.getOrCreateConfiguration(target).getEnabledProtocols();
            }
            case "encoders": {
                return this.getOrCreateConfiguration(target).getEncoders();
            }
            case "encoding": {
                return this.getOrCreateConfiguration(target).getEncoding();
            }
            case "executorservice": 
            case "executorService": {
                return target.getExecutorService();
            }
            case "keepalive": 
            case "keepAlive": {
                return this.getOrCreateConfiguration(target).isKeepAlive();
            }
            case "keystorefile": 
            case "keyStoreFile": {
                return this.getOrCreateConfiguration(target).getKeyStoreFile();
            }
            case "keystoreformat": 
            case "keyStoreFormat": {
                return this.getOrCreateConfiguration(target).getKeyStoreFormat();
            }
            case "keystoreresource": 
            case "keyStoreResource": {
                return this.getOrCreateConfiguration(target).getKeyStoreResource();
            }
            case "lazychannelcreation": 
            case "lazyChannelCreation": {
                return this.getOrCreateConfiguration(target).isLazyChannelCreation();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maximumpoolsize": 
            case "maximumPoolSize": {
                return target.getMaximumPoolSize();
            }
            case "nativetransport": 
            case "nativeTransport": {
                return this.getOrCreateConfiguration(target).isNativeTransport();
            }
            case "needclientauth": 
            case "needClientAuth": {
                return this.getOrCreateConfiguration(target).isNeedClientAuth();
            }
            case "nettyserverbootstrapfactory": 
            case "nettyServerBootstrapFactory": {
                return this.getOrCreateConfiguration(target).getNettyServerBootstrapFactory();
            }
            case "networkinterface": 
            case "networkInterface": {
                return this.getOrCreateConfiguration(target).getNetworkInterface();
            }
            case "noreplyloglevel": 
            case "noReplyLogLevel": {
                return this.getOrCreateConfiguration(target).getNoReplyLogLevel();
            }
            case "options": {
                return this.getOrCreateConfiguration(target).getOptions();
            }
            case "passphrase": {
                return this.getOrCreateConfiguration(target).getPassphrase();
            }
            case "producerpoolenabled": 
            case "producerPoolEnabled": {
                return this.getOrCreateConfiguration(target).isProducerPoolEnabled();
            }
            case "producerpoolmaxactive": 
            case "producerPoolMaxActive": {
                return this.getOrCreateConfiguration(target).getProducerPoolMaxActive();
            }
            case "producerpoolmaxidle": 
            case "producerPoolMaxIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMaxIdle();
            }
            case "producerpoolminevictableidle": 
            case "producerPoolMinEvictableIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMinEvictableIdle();
            }
            case "producerpoolminidle": 
            case "producerPoolMinIdle": {
                return this.getOrCreateConfiguration(target).getProducerPoolMinIdle();
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                return this.getOrCreateConfiguration(target).getReceiveBufferSize();
            }
            case "receivebuffersizepredictor": 
            case "receiveBufferSizePredictor": {
                return this.getOrCreateConfiguration(target).getReceiveBufferSizePredictor();
            }
            case "reconnect": {
                return this.getOrCreateConfiguration(target).isReconnect();
            }
            case "reconnectinterval": 
            case "reconnectInterval": {
                return this.getOrCreateConfiguration(target).getReconnectInterval();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return this.getOrCreateConfiguration(target).getRequestTimeout();
            }
            case "reuseaddress": 
            case "reuseAddress": {
                return this.getOrCreateConfiguration(target).isReuseAddress();
            }
            case "reusechannel": 
            case "reuseChannel": {
                return this.getOrCreateConfiguration(target).isReuseChannel();
            }
            case "securityprovider": 
            case "securityProvider": {
                return this.getOrCreateConfiguration(target).getSecurityProvider();
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                return this.getOrCreateConfiguration(target).getSendBufferSize();
            }
            case "serverclosedchannelexceptioncaughtloglevel": 
            case "serverClosedChannelExceptionCaughtLogLevel": {
                return this.getOrCreateConfiguration(target).getServerClosedChannelExceptionCaughtLogLevel();
            }
            case "serverexceptioncaughtloglevel": 
            case "serverExceptionCaughtLogLevel": {
                return this.getOrCreateConfiguration(target).getServerExceptionCaughtLogLevel();
            }
            case "serverinitializerfactory": 
            case "serverInitializerFactory": {
                return this.getOrCreateConfiguration(target).getServerInitializerFactory();
            }
            case "ssl": {
                return this.getOrCreateConfiguration(target).isSsl();
            }
            case "sslclientcertheaders": 
            case "sslClientCertHeaders": {
                return this.getOrCreateConfiguration(target).isSslClientCertHeaders();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "sslhandler": 
            case "sslHandler": {
                return this.getOrCreateConfiguration(target).getSslHandler();
            }
            case "sync": {
                return this.getOrCreateConfiguration(target).isSync();
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                return this.getOrCreateConfiguration(target).isTcpNoDelay();
            }
            case "textline": {
                return this.getOrCreateConfiguration(target).isTextline();
            }
            case "transferexchange": 
            case "transferExchange": {
                return this.getOrCreateConfiguration(target).isTransferExchange();
            }
            case "truststorefile": 
            case "trustStoreFile": {
                return this.getOrCreateConfiguration(target).getTrustStoreFile();
            }
            case "truststoreresource": 
            case "trustStoreResource": {
                return this.getOrCreateConfiguration(target).getTrustStoreResource();
            }
            case "udpbytearraycodec": 
            case "udpByteArrayCodec": {
                return this.getOrCreateConfiguration(target).isUdpByteArrayCodec();
            }
            case "udpconnectionlesssending": 
            case "udpConnectionlessSending": {
                return this.getOrCreateConfiguration(target).isUdpConnectionlessSending();
            }
            case "usebytebuf": 
            case "useByteBuf": {
                return this.getOrCreateConfiguration(target).isUseByteBuf();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
            case "usingexecutorservice": 
            case "usingExecutorService": {
                return this.getOrCreateConfiguration(target).isUsingExecutorService();
            }
            case "workercount": 
            case "workerCount": {
                return this.getOrCreateConfiguration(target).getWorkerCount();
            }
            case "workergroup": 
            case "workerGroup": {
                return this.getOrCreateConfiguration(target).getWorkerGroup();
            }
        }
        return null;
    }
}

