/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import java.util.Map;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.netty4.NettyComponent;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyEndpoint;
import org.apache.camel.component.netty4.NettyServerBootstrapFactory;
import org.apache.camel.component.netty4.http.HttpServerBootstrapFactory;
import org.apache.camel.component.netty4.http.JAASSecurityAuthenticator;
import org.apache.camel.component.netty4.http.NettyHttpBinding;
import org.apache.camel.component.netty4.http.NettyHttpComponent;
import org.apache.camel.component.netty4.http.NettyHttpConfiguration;
import org.apache.camel.component.netty4.http.NettyHttpConsumer;
import org.apache.camel.component.netty4.http.NettyHttpHelper;
import org.apache.camel.component.netty4.http.NettyHttpProducer;
import org.apache.camel.component.netty4.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty4.http.NettySharedHttpServer;
import org.apache.camel.http.common.cookie.CookieHandler;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.14.0", scheme="netty4-http", extendsScheme="netty4", title="Netty4 HTTP", syntax="netty4-http:protocol:host:port/path", consumerClass=NettyHttpConsumer.class, label="http", lenientProperties=true, excludeProperties="textline,delimiter,autoAppendDelimiter,decoderMaxLineLength,encoding,allowDefaultCodec,udpConnectionlessSending,networkInterface,clientMode,reconnect,reconnectInterval,useByteBuf,udpByteArrayCodec,broadcast,correlationManager")
public class NettyHttpEndpoint
extends NettyEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpEndpoint.class);
    @UriParam
    private NettyHttpConfiguration configuration;
    @UriParam(label="advanced", name="configuration", javaType="org.apache.camel.component.netty4.http.NettyHttpConfiguration", description="To use a custom configured NettyHttpConfiguration for configuring this endpoint.")
    private Object httpConfiguration;
    @UriParam(label="advanced")
    private NettyHttpBinding nettyHttpBinding;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="consumer,advanced")
    private boolean traceEnabled;
    @UriParam(label="consumer,advanced")
    private String httpMethodRestrict;
    @UriParam(label="consumer,advanced")
    private NettySharedHttpServer nettySharedHttpServer;
    @UriParam(label="consumer,security")
    private NettyHttpSecurityConfiguration securityConfiguration;
    @UriParam(label="consumer,security", prefix="securityConfiguration.", multiValue=true)
    private Map<String, Object> securityOptions;
    @UriParam(label="producer")
    private CookieHandler cookieHandler;

    public NettyHttpEndpoint(String endpointUri, NettyHttpComponent component, NettyConfiguration configuration) {
        super(endpointUri, (NettyComponent)component, configuration);
    }

    public NettyHttpComponent getComponent() {
        return (NettyHttpComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        NettyHttpConsumer answer = new NettyHttpConsumer(this, processor, this.getConfiguration());
        this.configureConsumer((Consumer)answer);
        if (this.nettySharedHttpServer != null) {
            answer.setNettyServerBootstrapFactory(this.nettySharedHttpServer.getServerBootstrapFactory());
            LOG.info("NettyHttpConsumer: {} is using NettySharedHttpServer on port: {}", (Object)answer, (Object)this.nettySharedHttpServer.getPort());
        } else {
            HttpServerBootstrapFactory factory = this.getComponent().getOrCreateHttpNettyServerBootstrapFactory(answer);
            answer.setNettyServerBootstrapFactory((NettyServerBootstrapFactory)factory);
            LOG.debug("Created NettyHttpConsumer: {} using HttpServerBootstrapFactory: {}", (Object)answer, (Object)factory);
        }
        return answer;
    }

    public Producer createProducer() throws Exception {
        NettyHttpProducer answer = new NettyHttpProducer(this, this.getConfiguration());
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        throw new UnsupportedOperationException("This component does not support polling consumer");
    }

    public Exchange createExchange(ChannelHandlerContext ctx, Object message) throws Exception {
        Exchange exchange = this.createExchange();
        FullHttpRequest request = (FullHttpRequest)message;
        Message in = this.getNettyHttpBinding().toCamelMessage(request, exchange, this.getConfiguration());
        exchange.setIn(in);
        this.updateMessageHeader(in, ctx);
        String contentType = (String)in.getHeader("Content-Type", String.class);
        String charset = NettyHttpHelper.getCharsetFromContentType(contentType);
        if (charset != null) {
            exchange.setProperty("CamelCharsetName", (Object)charset);
            in.setHeader("CamelHttpCharacterEncoding", (Object)charset);
        }
        return exchange;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        super.setConfiguration(configuration);
        this.configuration = (NettyHttpConfiguration)configuration;
    }

    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    public NettyHttpBinding getNettyHttpBinding() {
        return this.nettyHttpBinding;
    }

    public void setNettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
        this.nettyHttpBinding = nettyHttpBinding;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        this.getNettyHttpBinding().setHeaderFilterStrategy(headerFilterStrategy);
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public NettySharedHttpServer getNettySharedHttpServer() {
        return this.nettySharedHttpServer;
    }

    public void setNettySharedHttpServer(NettySharedHttpServer nettySharedHttpServer) {
        this.nettySharedHttpServer = nettySharedHttpServer;
    }

    public NettyHttpSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public Map<String, Object> getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(Map<String, Object> securityOptions) {
        this.securityOptions = securityOptions;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.nettyHttpBinding, (String)"nettyHttpBinding", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.headerFilterStrategy, (String)"headerFilterStrategy", (Object)((Object)this));
        if (this.securityConfiguration != null) {
            ObjectHelper.notEmpty((String)this.securityConfiguration.getRealm(), (String)"realm", (Object)this.securityConfiguration);
            ObjectHelper.notEmpty((String)this.securityConfiguration.getConstraint(), (String)"restricted", (Object)this.securityConfiguration);
            if (this.securityConfiguration.getSecurityAuthenticator() == null) {
                JAASSecurityAuthenticator jaas = new JAASSecurityAuthenticator();
                jaas.setName(this.securityConfiguration.getRealm());
                LOG.info("No SecurityAuthenticator configured, using JAASSecurityAuthenticator as authenticator: {}", (Object)jaas);
                this.securityConfiguration.setSecurityAuthenticator(jaas);
            }
        }
    }
}

