/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.properties.ClasspathPropertiesSource;
import org.apache.camel.component.properties.DefaultPropertiesLookup;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.EnvPropertiesFunction;
import org.apache.camel.component.properties.FilePropertiesSource;
import org.apache.camel.component.properties.LocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesEndpoint;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.RefPropertiesSource;
import org.apache.camel.component.properties.ServiceHostPropertiesFunction;
import org.apache.camel.component.properties.ServicePortPropertiesFunction;
import org.apache.camel.component.properties.ServicePropertiesFunction;
import org.apache.camel.component.properties.SysPropertiesFunction;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FilePathResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="properties")
@ManagedResource(description="Managed PropertiesComponent")
public class PropertiesComponent
extends DefaultComponent
implements org.apache.camel.spi.PropertiesComponent,
StaticService {
    public static final int SYSTEM_PROPERTIES_MODE_NEVER = 0;
    public static final int SYSTEM_PROPERTIES_MODE_FALLBACK = 1;
    public static final int SYSTEM_PROPERTIES_MODE_OVERRIDE = 2;
    public static final int ENVIRONMENT_VARIABLES_MODE_NEVER = 0;
    public static final int ENVIRONMENT_VARIABLES_MODE_FALLBACK = 1;
    public static final int ENVIRONMENT_VARIABLES_MODE_OVERRIDE = 2;
    public static final String OVERRIDE_PROPERTIES = PropertiesComponent.class.getName() + ".OverrideProperties";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesComponent.class);
    private final Map<String, PropertiesFunction> functions = new LinkedHashMap<String, PropertiesFunction>();
    private PropertiesParser propertiesParser = new DefaultPropertiesParser(this);
    private final PropertiesLookup propertiesLookup = new DefaultPropertiesLookup(this);
    private final List<PropertiesSource> sources = new ArrayList<PropertiesSource>();
    private List<PropertiesLocation> locations = Collections.emptyList();
    @Metadata
    private boolean ignoreMissingLocation;
    @Metadata
    private String encoding;
    @Metadata(defaultValue="true")
    private boolean defaultFallbackEnabled = true;
    @Metadata(label="advanced", defaultValue="{{")
    private String prefixToken = "{{";
    @Metadata(label="advanced", defaultValue="}}")
    private String suffixToken = "}}";
    @Metadata(label="advanced")
    private Properties initialProperties;
    @Metadata(label="advanced")
    private Properties overrideProperties;
    @Metadata(defaultValue="2", enums="0,1,2")
    private int systemPropertiesMode = 2;
    @Metadata(defaultValue="1", enums="0,1,2")
    private int environmentVariableMode = 2;

    public PropertiesComponent() {
        this.addFunction(new EnvPropertiesFunction());
        this.addFunction(new SysPropertiesFunction());
        this.addFunction(new ServicePropertiesFunction());
        this.addFunction(new ServiceHostPropertiesFunction());
        this.addFunction(new ServicePortPropertiesFunction());
    }

    public PropertiesComponent(String location) {
        this();
        this.setLocation(location);
    }

    public PropertiesComponent(String ... locations) {
        this();
        this.setLocations(locations);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String endpointUri = this.parseUri(remaining);
        if (LOG.isDebugEnabled()) {
            this.log.debug("Endpoint uri parsed as: {}", (Object)URISupport.sanitizeUri((String)endpointUri));
        }
        Endpoint delegate = this.getCamelContext().getEndpoint(endpointUri);
        PropertiesEndpoint answer = new PropertiesEndpoint(uri, delegate, (Component)this);
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    public String parseUri(String uri) {
        return this.parseUri(uri, this.propertiesLookup);
    }

    public Optional<String> resolveProperty(String key) {
        String value = this.parseUri(key, this.propertiesLookup);
        return Optional.of(value);
    }

    public Properties loadProperties() {
        OrderedProperties prop = new OrderedProperties();
        if (this.initialProperties != null) {
            prop.putAll((Map<?, ?>)this.initialProperties);
        }
        if (!this.sources.isEmpty()) {
            for (PropertiesSource ps : this.sources) {
                if (!(ps instanceof LoadablePropertiesSource)) continue;
                LoadablePropertiesSource lps = (LoadablePropertiesSource)ps;
                Properties p = lps.loadProperties();
                prop.putAll((Map<?, ?>)p);
            }
        }
        if (this.overrideProperties != null) {
            OrderedProperties override = new OrderedProperties();
            override.putAll((Map<?, ?>)prop);
            override.putAll((Map<?, ?>)this.overrideProperties);
            prop = override;
        }
        return prop;
    }

    protected String parseUri(String uri, PropertiesLookup properties) {
        if (!uri.contains(this.prefixToken) && !uri.startsWith(this.prefixToken)) {
            uri = this.prefixToken + uri;
        }
        if (!uri.contains(this.suffixToken) && !uri.endsWith(this.suffixToken)) {
            uri = uri + this.suffixToken;
        }
        this.log.trace("Parsing uri {}", (Object)uri);
        return this.propertiesParser.parseUri(uri, properties, this.prefixToken, this.suffixToken, this.defaultFallbackEnabled);
    }

    public List<String> getLocations() {
        if (this.locations.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.locations.stream().map(PropertiesLocation::toString).collect(Collectors.toList());
    }

    public void setLocations(List<PropertiesLocation> locations) {
        locations = this.parseLocations(locations);
        this.locations = Collections.unmodifiableList(locations);
        this.sources.removeIf(s -> s instanceof LocationPropertiesSource);
        for (PropertiesLocation loc : locations) {
            this.addPropertiesLocationsAsPropertiesSource(loc);
        }
    }

    public void setLocations(String[] locationStrings) {
        ArrayList<PropertiesLocation> locations = new ArrayList<PropertiesLocation>();
        if (locationStrings != null) {
            for (String locationString : locationStrings) {
                locations.add(new PropertiesLocation(locationString));
            }
        }
        this.setLocations((List<PropertiesLocation>)locations);
    }

    public void setLocations(Collection<String> locationStrings) {
        ArrayList<PropertiesLocation> locations = new ArrayList<PropertiesLocation>();
        if (locationStrings != null) {
            for (String locationString : locationStrings) {
                locations.add(new PropertiesLocation(locationString));
            }
        }
        this.setLocations((List<PropertiesLocation>)locations);
    }

    public void addLocation(String location) {
        if (location != null) {
            ArrayList<PropertiesLocation> newLocations = new ArrayList<PropertiesLocation>();
            for (String loc : location.split(",")) {
                newLocations.add(new PropertiesLocation(loc));
            }
            List<PropertiesLocation> current = this.locations;
            if (!current.isEmpty()) {
                newLocations.addAll(0, current);
            }
            this.setLocations((List<PropertiesLocation>)newLocations);
        }
    }

    public void setLocation(String location) {
        if (location != null) {
            this.setLocations(location.split(","));
        }
    }

    @ManagedAttribute(description="Encoding to use when loading properties file from the file system or classpath")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public PropertiesParser getPropertiesParser() {
        return this.propertiesParser;
    }

    public void setPropertiesParser(PropertiesParser propertiesParser) {
        this.propertiesParser = propertiesParser;
    }

    @ManagedAttribute(description="Whether to support using fallback values if a property cannot be found")
    public boolean isDefaultFallbackEnabled() {
        return this.defaultFallbackEnabled;
    }

    public void setDefaultFallbackEnabled(boolean defaultFallbackEnabled) {
        this.defaultFallbackEnabled = defaultFallbackEnabled;
    }

    @ManagedAttribute(description="Ignore missing location")
    public boolean isIgnoreMissingLocation() {
        return this.ignoreMissingLocation;
    }

    public void setIgnoreMissingLocation(boolean ignoreMissingLocation) {
        this.ignoreMissingLocation = ignoreMissingLocation;
    }

    @ManagedAttribute(description="Prefix token")
    public String getPrefixToken() {
        return this.prefixToken;
    }

    public void setPrefixToken(String prefixToken) {
        this.prefixToken = prefixToken == null ? "{{" : prefixToken;
    }

    @ManagedAttribute(description="Suffix token")
    public String getSuffixToken() {
        return this.suffixToken;
    }

    public void setSuffixToken(String suffixToken) {
        this.suffixToken = suffixToken == null ? "}}" : suffixToken;
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public Map<String, PropertiesFunction> getFunctions() {
        return this.functions;
    }

    public void addFunction(PropertiesFunction function) {
        this.functions.put(function.getName(), function);
    }

    public boolean hasFunction(String name) {
        return this.functions.containsKey(name);
    }

    @ManagedAttribute(description="System properties mode")
    public int getSystemPropertiesMode() {
        return this.systemPropertiesMode;
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
    }

    @ManagedAttribute(description="Environment variable mode")
    public int getEnvironmentVariableMode() {
        return this.environmentVariableMode;
    }

    public void setEnvironmentVariableMode(int environmentVariableMode) {
        this.environmentVariableMode = environmentVariableMode;
    }

    public void addPropertiesSource(PropertiesSource propertiesSource) {
        if (propertiesSource instanceof CamelContextAware) {
            ((CamelContextAware)propertiesSource).setCamelContext(this.getCamelContext());
        }
        this.sources.add(propertiesSource);
        if (!this.isNew()) {
            ServiceHelper.initService((Object)propertiesSource);
        }
    }

    public List<PropertiesSource> getSources() {
        return this.sources;
    }

    protected void doInit() throws Exception {
        super.doInit();
        try {
            FactoryFinder factoryFinder = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinder("META-INF/services/org/apache/camel");
            Class type = factoryFinder.findClass("properties-source-factory");
            if (type != null) {
                Object obj = this.getCamelContext().getInjector().newInstance(type, false);
                if (obj instanceof PropertiesSource) {
                    PropertiesSource ps = (PropertiesSource)obj;
                    this.addPropertiesSource(ps);
                    LOG.info("PropertiesComponent added custom PropertiesSource: {}", (Object)ps);
                } else if (obj != null) {
                    LOG.warn("PropertiesComponent cannot add custom PropertiesSource as the type is not a org.apache.camel.component.properties.PropertiesSource but: " + type.getName());
                }
            }
        }
        catch (NoFactoryAvailableException factoryFinder) {
        }
        catch (Exception e) {
            LOG.debug("Error discovering and using custom PropertiesSource due to " + e.getMessage() + ". This exception is ignored", (Throwable)e);
        }
        ServiceHelper.initService(this.sources);
    }

    protected void doStart() throws Exception {
        this.sources.sort((Comparator<PropertiesSource>)OrderedComparator.get());
        ServiceHelper.startService(this.sources);
        if (this.systemPropertiesMode != 0 && this.systemPropertiesMode != 1 && this.systemPropertiesMode != 2) {
            throw new IllegalArgumentException("Option systemPropertiesMode has invalid value: " + this.systemPropertiesMode);
        }
        if (this.environmentVariableMode != 0 && this.environmentVariableMode != 1 && this.environmentVariableMode != 2) {
            throw new IllegalArgumentException("Option environmentVariableMode has invalid value: " + this.environmentVariableMode);
        }
        if (this.propertiesParser instanceof DefaultPropertiesParser) {
            ((DefaultPropertiesParser)this.propertiesParser).setPropertiesComponent(this);
        }
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.sources);
    }

    private void addPropertiesLocationsAsPropertiesSource(PropertiesLocation location) {
        if ("ref".equals(location.getResolver())) {
            this.addPropertiesSource(new RefPropertiesSource(this, location));
        } else if ("file".equals(location.getResolver())) {
            this.addPropertiesSource(new FilePropertiesSource(this, location));
        } else if ("classpath".equals(location.getResolver())) {
            this.addPropertiesSource(new ClasspathPropertiesSource(this, location));
        }
    }

    private List<PropertiesLocation> parseLocations(List<PropertiesLocation> locations) {
        ArrayList<PropertiesLocation> answer = new ArrayList<PropertiesLocation>();
        for (PropertiesLocation location : locations) {
            this.log.trace("Parsing location: {}", (Object)location);
            try {
                String path = FilePathResolver.resolvePath((String)location.getPath());
                this.log.debug("Parsed location: {}", (Object)path);
                if (!ObjectHelper.isNotEmpty((Object)path)) continue;
                answer.add(new PropertiesLocation(location.getResolver(), path, location.isOptional()));
            }
            catch (IllegalArgumentException e) {
                if (!this.ignoreMissingLocation && !location.isOptional()) {
                    throw e;
                }
                this.log.debug("Ignored missing location: {}", (Object)location);
            }
        }
        return answer;
    }
}

