/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class QuartzEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":groupName/triggerName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "quartz".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "groupName", "Camel", false, copy);
        uri = this.buildPathParameter(syntax, uri, "triggerName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(22);
        props.add("cron");
        props.add("basicPropertyBinding");
        props.add("triggerName");
        props.add("customCalendar");
        props.add("synchronous");
        props.add("exchangePattern");
        props.add("deleteJob");
        props.add("pauseJob");
        props.add("triggerStartDelay");
        props.add("autoStartScheduler");
        props.add("groupName");
        props.add("bridgeErrorHandler");
        props.add("prefixJobNameWithEndpointId");
        props.add("recoverableJob");
        props.add("triggerParameters");
        props.add("durableJob");
        props.add("startDelayedSeconds");
        props.add("jobParameters");
        props.add("exceptionHandler");
        props.add("usingFixedCamelContextName");
        props.add("stateful");
        props.add("fireNow");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

