/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.pollconsumer.quartz;

import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.component.quartz.QuartzHelper;
import org.apache.camel.pollconsumer.quartz.QuartzScheduledPollConsumerJob;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduledPollConsumerScheduler
extends ServiceSupport
implements ScheduledPollConsumerScheduler,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzScheduledPollConsumerScheduler.class);
    private Scheduler quartzScheduler;
    private CamelContext camelContext;
    private String routeId;
    private Runnable runnable;
    private String cron;
    private String triggerId;
    private String triggerGroup = "QuartzScheduledPollConsumerScheduler";
    private TimeZone timeZone = TimeZone.getDefault();
    private boolean deleteJob = true;
    private volatile CronTrigger trigger;
    private volatile JobDetail job;

    public void onInit(Consumer consumer) {
        for (Route route : consumer.getEndpoint().getCamelContext().getRoutes()) {
            if (route.getConsumer() != consumer) continue;
            this.routeId = route.getId();
            break;
        }
    }

    public void scheduleTask(Runnable runnable) {
        this.runnable = runnable;
    }

    public void unscheduleTask() {
        if (this.trigger != null) {
            LOG.debug("Unscheduling trigger: {}", (Object)this.trigger.getKey());
            try {
                this.quartzScheduler.unscheduleJob(this.trigger.getKey());
            }
            catch (SchedulerException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public void startScheduler() {
    }

    public boolean isSchedulerStarted() {
        try {
            return this.quartzScheduler != null && this.quartzScheduler.isStarted();
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    public void setQuartzScheduler(Scheduler scheduler) {
        this.quartzScheduler = scheduler;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getTriggerGroup() {
        return this.triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    public boolean isDeleteJob() {
        return this.deleteJob;
    }

    public void setDeleteJob(boolean deleteJob) {
        this.deleteJob = deleteJob;
    }

    protected void doStart() throws Exception {
        block13: {
            String id;
            StringHelper.notEmpty((String)this.cron, (String)"cron", (Object)((Object)this));
            if (this.quartzScheduler == null) {
                QuartzComponent quartz = (QuartzComponent)this.getCamelContext().getComponent("quartz", QuartzComponent.class);
                this.setQuartzScheduler(quartz.getScheduler());
            }
            if ((id = this.triggerId) == null) {
                id = "trigger-" + this.getCamelContext().getUuidGenerator().generateUuid();
            }
            CronTrigger existingTrigger = null;
            TriggerKey triggerKey = null;
            if (this.triggerId != null && this.triggerGroup != null) {
                triggerKey = new TriggerKey(this.triggerId, this.triggerGroup);
                existingTrigger = (CronTrigger)this.quartzScheduler.getTrigger(triggerKey);
            }
            if (existingTrigger == null) {
                JobDataMap map = new JobDataMap();
                if (this.routeId != null) {
                    map.put("routeId", this.routeId);
                } else {
                    map.put("task", (Object)this.runnable);
                }
                map.put("CamelQuartzTriggerType", "cron");
                map.put("CamelQuartzTriggerCronExpression", this.getCron());
                map.put("CamelQuartzTriggerCronTimeZone", this.getTimeZone().getID());
                this.job = JobBuilder.newJob(QuartzScheduledPollConsumerJob.class).usingJobData(map).build();
                QuartzHelper.updateJobDataMap(this.getCamelContext(), this.job, null);
                this.trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(id, this.triggerGroup).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.getCron()).inTimeZone(this.getTimeZone())).build();
                LOG.debug("Scheduling job: {} with trigger: {}", (Object)this.job, (Object)this.trigger.getKey());
                this.quartzScheduler.scheduleJob(this.job, (Trigger)this.trigger);
            } else {
                this.checkTriggerIsNonConflicting((Trigger)existingTrigger);
                LOG.debug("Trigger with key {} is already present in scheduler. Only updating it.", triggerKey);
                this.job = this.quartzScheduler.getJobDetail(existingTrigger.getJobKey());
                JobDataMap jobData = this.job.getJobDataMap();
                jobData.put("CamelQuartzTriggerCronExpression", this.getCron());
                jobData.put("CamelQuartzTriggerCronTimeZone", this.getTimeZone().getID());
                QuartzHelper.updateJobDataMap(this.getCamelContext(), this.job, null);
                LOG.debug("Updated jobData map to {}", (Object)jobData);
                this.trigger = (CronTrigger)existingTrigger.getTriggerBuilder().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.getCron()).inTimeZone(this.getTimeZone())).build();
                if (this.hasTriggerChanged((Trigger)existingTrigger, (Trigger)this.trigger)) {
                    LOG.debug("Re-scheduling job: {} with trigger: {}", (Object)this.job, (Object)this.trigger.getKey());
                    this.quartzScheduler.rescheduleJob(triggerKey, (Trigger)this.trigger);
                } else {
                    LOG.debug("Scheduling job: {} with trigger: {}", (Object)this.job, (Object)this.trigger.getKey());
                    try {
                        this.quartzScheduler.scheduleJob(this.job, (Trigger)this.trigger);
                    }
                    catch (ObjectAlreadyExistsException ex) {
                        QuartzComponent quartz = (QuartzComponent)this.getCamelContext().getComponent("quartz", QuartzComponent.class);
                        if (!quartz.isClustered()) {
                            throw ex;
                        }
                        this.trigger = (CronTrigger)this.quartzScheduler.getTrigger(triggerKey);
                        if (this.trigger != null) break block13;
                        throw new SchedulerException("Trigger could not be found in quartz scheduler.");
                    }
                }
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Job {} (triggerType={}, jobClass={}) is scheduled. Next fire date is {}", new Object[]{this.trigger.getKey(), this.trigger.getClass().getSimpleName(), this.job.getJobClass().getSimpleName(), this.trigger.getNextFireTime()});
        }
    }

    protected void doStop() throws Exception {
        if (this.trigger != null && this.deleteJob) {
            boolean isClustered = this.quartzScheduler.getMetaData().isJobStoreClustered();
            if (!this.quartzScheduler.isShutdown() && !isClustered) {
                LOG.info("Deleting job {}", (Object)this.trigger.getKey());
                this.quartzScheduler.unscheduleJob(this.trigger.getKey());
            }
        }
    }

    protected void doShutdown() throws Exception {
    }

    private void checkTriggerIsNonConflicting(Trigger trigger) {
        JobDataMap jobDataMap = trigger.getJobDataMap();
        String routeIdFromTrigger = jobDataMap.getString("routeId");
        if (routeIdFromTrigger != null && !routeIdFromTrigger.equals(this.routeId)) {
            throw new IllegalArgumentException("Trigger key " + trigger.getKey() + " is already used by route: " + routeIdFromTrigger + ". Cannot re-use it for another route: " + this.routeId);
        }
    }

    private boolean hasTriggerChanged(Trigger oldTrigger, Trigger newTrigger) {
        if (newTrigger instanceof CronTrigger && oldTrigger instanceof CronTrigger) {
            CronTrigger newCron = (CronTrigger)newTrigger;
            CronTrigger oldCron = (CronTrigger)oldTrigger;
            return !newCron.getCronExpression().equals(oldCron.getCronExpression());
        }
        if (newTrigger instanceof SimpleTrigger && oldTrigger instanceof SimpleTrigger) {
            SimpleTrigger newSimple = (SimpleTrigger)newTrigger;
            SimpleTrigger oldSimple = (SimpleTrigger)oldTrigger;
            return newSimple.getRepeatInterval() != oldSimple.getRepeatInterval() || newSimple.getRepeatCount() != oldSimple.getRepeatCount();
        }
        return !newTrigger.getClass().equals(oldTrigger.getClass()) || !newTrigger.equals((Object)oldTrigger);
    }
}

