/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.component.quickfixj.MessageCorrelator;
import org.apache.camel.component.quickfixj.QuickfixjEventCategory;
import org.apache.camel.component.quickfixj.QuickfixjEventListener;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.URISupport;
import org.quickfixj.jmx.JmxExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.DoNotSend;
import quickfix.FieldConvertError;
import quickfix.FieldNotFound;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Initiator;
import quickfix.JdbcLogFactory;
import quickfix.JdbcStoreFactory;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RejectLogon;
import quickfix.SLF4JLogFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SleepycatStoreFactory;
import quickfix.SocketAcceptor;
import quickfix.SocketInitiator;
import quickfix.ThreadedSocketAcceptor;
import quickfix.ThreadedSocketInitiator;
import quickfix.UnsupportedMessageType;

public class QuickfixjEngine
extends ServiceSupport {
    public static final String DEFAULT_START_TIME = "00:00:00";
    public static final String DEFAULT_END_TIME = "00:00:00";
    public static final long DEFAULT_HEARTBTINT = 30L;
    public static final String SETTING_THREAD_MODEL = "ThreadModel";
    public static final String SETTING_USE_JMX = "UseJmx";
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjEngine.class);
    private Acceptor acceptor;
    private Initiator initiator;
    private JmxExporter jmxExporter;
    private MessageStoreFactory messageStoreFactory;
    private LogFactory sessionLogFactory;
    private MessageFactory messageFactory;
    private final MessageCorrelator messageCorrelator = new MessageCorrelator();
    private final List<QuickfixjEventListener> eventListeners = new CopyOnWriteArrayList<QuickfixjEventListener>();
    private final String uri;
    private ObjectName acceptorObjectName;
    private ObjectName initiatorObjectName;
    private final SessionSettings settings;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final boolean lazy;
    private final AtomicInteger refCount = new AtomicInteger();

    public QuickfixjEngine(CamelContext camelContext, String uri, String settingsResourceName) throws Exception {
        this(camelContext, uri, settingsResourceName, null, null, null);
    }

    public QuickfixjEngine(CamelContext camelContext, String uri, String settingsResourceName, MessageStoreFactory messageStoreFactoryOverride, LogFactory sessionLogFactoryOverride, MessageFactory messageFactoryOverride) throws Exception {
        this(camelContext, uri, QuickfixjEngine.loadSettings(camelContext, settingsResourceName), messageStoreFactoryOverride, sessionLogFactoryOverride, messageFactoryOverride);
    }

    public QuickfixjEngine(CamelContext camelContext, String uri, SessionSettings settings, MessageStoreFactory messageStoreFactoryOverride, LogFactory sessionLogFactoryOverride, MessageFactory messageFactoryOverride) throws Exception {
        this(camelContext, uri, settings, messageStoreFactoryOverride, sessionLogFactoryOverride, messageFactoryOverride, false);
    }

    public QuickfixjEngine(CamelContext camelContext, String uri, SessionSettings settings, MessageStoreFactory messageStoreFactoryOverride, LogFactory sessionLogFactoryOverride, MessageFactory messageFactoryOverride, boolean lazy) throws Exception {
        this.addEventListener(this.messageCorrelator);
        this.uri = URISupport.sanitizeUri((String)uri);
        this.lazy = lazy;
        this.settings = settings;
        if (messageFactoryOverride != null) {
            this.messageFactory = messageFactoryOverride;
        }
        if (sessionLogFactoryOverride != null) {
            this.sessionLogFactory = sessionLogFactoryOverride;
        }
        if (messageStoreFactoryOverride != null) {
            this.messageStoreFactory = messageStoreFactoryOverride;
        }
        if (!lazy) {
            this.initializeEngine();
        }
    }

    public int incRefCount() {
        return this.refCount.incrementAndGet();
    }

    public int decRefCount() {
        return this.refCount.decrementAndGet();
    }

    void initializeEngine() throws ConfigError, FieldConvertError, JMException {
        LOG.debug("Initializing QuickFIX/J Engine: {}", (Object)this.uri);
        if (this.messageFactory == null) {
            this.messageFactory = new DefaultMessageFactory();
        }
        if (this.sessionLogFactory == null) {
            this.sessionLogFactory = this.inferLogFactory(this.settings);
        }
        if (this.messageStoreFactory == null) {
            this.messageStoreFactory = this.inferMessageStoreFactory(this.settings);
        }
        if (!this.settings.isSetting("StartTime")) {
            this.settings.setString("StartTime", "00:00:00");
        }
        if (!this.settings.isSetting("EndTime")) {
            this.settings.setString("EndTime", "00:00:00");
        }
        if (!this.settings.isSetting("HeartBtInt")) {
            this.settings.setLong("HeartBtInt", 30L);
        }
        ThreadModel threadModel = ThreadModel.ThreadPerConnector;
        if (this.settings.isSetting(SETTING_THREAD_MODEL)) {
            threadModel = ThreadModel.valueOf(this.settings.getString(SETTING_THREAD_MODEL));
        }
        if (this.settings.isSetting(SETTING_USE_JMX) && this.settings.getBool(SETTING_USE_JMX)) {
            LOG.info("Enabling JMX for QuickFIX/J");
            this.jmxExporter = new JmxExporter();
        } else {
            this.jmxExporter = null;
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.acceptor = this.isConnectorRole(this.settings, "acceptor") ? this.createAcceptor(new Dispatcher(), this.settings, this.messageStoreFactory, this.sessionLogFactory, this.messageFactory, threadModel) : null;
            this.initiator = this.isConnectorRole(this.settings, "initiator") ? this.createInitiator(new Dispatcher(), this.settings, this.messageStoreFactory, this.sessionLogFactory, this.messageFactory, threadModel) : null;
            if (this.acceptor == null && this.initiator == null) {
                throw new ConfigError("No connector role");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
        LOG.debug("Initialized QuickFIX/J Engine: {}", (Object)this.uri);
        this.initialized.set(true);
    }

    protected static SessionSettings loadSettings(CamelContext camelContext, String settingsResourceName) throws Exception {
        InputStream inputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)settingsResourceName);
        return new SessionSettings(inputStream);
    }

    protected void doStart() throws Exception {
        LOG.debug("Starting QuickFIX/J Engine: {}", (Object)this.uri);
        if (this.acceptor != null) {
            this.acceptor.start();
            if (this.jmxExporter != null) {
                this.acceptorObjectName = this.jmxExporter.register((Connector)this.acceptor);
            }
        }
        if (this.initiator != null) {
            this.initiator.start();
            if (this.jmxExporter != null) {
                this.initiatorObjectName = this.jmxExporter.register((Connector)this.initiator);
            }
        }
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping QuickFIX/J Engine: {}", (Object)this.uri);
        if (this.acceptor != null) {
            this.acceptor.stop();
            if (this.jmxExporter != null && this.acceptorObjectName != null) {
                this.jmxExporter.getMBeanServer().unregisterMBean(this.acceptorObjectName);
            }
        }
        if (this.initiator != null) {
            this.initiator.stop();
            if (this.jmxExporter != null && this.initiatorObjectName != null) {
                this.jmxExporter.getMBeanServer().unregisterMBean(this.initiatorObjectName);
            }
        }
    }

    protected void doShutdown() throws Exception {
        this.eventListeners.clear();
    }

    private Initiator createInitiator(Application application, SessionSettings settings, MessageStoreFactory messageStoreFactory, LogFactory sessionLogFactory, MessageFactory messageFactory, ThreadModel threadModel) throws ConfigError {
        ThreadedSocketInitiator initiator;
        if (threadModel == ThreadModel.ThreadPerSession) {
            initiator = new ThreadedSocketInitiator(application, messageStoreFactory, settings, sessionLogFactory, messageFactory);
        } else if (threadModel == ThreadModel.ThreadPerConnector) {
            initiator = new SocketInitiator(application, messageStoreFactory, settings, sessionLogFactory, messageFactory);
        } else {
            throw new ConfigError("Unknown thread mode: " + (Object)((Object)threadModel));
        }
        return initiator;
    }

    private Acceptor createAcceptor(Application application, SessionSettings settings, MessageStoreFactory messageStoreFactory, LogFactory sessionLogFactory, MessageFactory messageFactory, ThreadModel threadModel) throws ConfigError {
        ThreadedSocketAcceptor acceptor;
        if (threadModel == ThreadModel.ThreadPerSession) {
            acceptor = new ThreadedSocketAcceptor(application, messageStoreFactory, settings, sessionLogFactory, messageFactory);
        } else if (threadModel == ThreadModel.ThreadPerConnector) {
            acceptor = new SocketAcceptor(application, messageStoreFactory, settings, sessionLogFactory, messageFactory);
        } else {
            throw new ConfigError("Unknown thread mode: " + (Object)((Object)threadModel));
        }
        return acceptor;
    }

    private MessageStoreFactory inferMessageStoreFactory(SessionSettings settings) throws ConfigError {
        HashSet<MessageStoreFactory> impliedMessageStoreFactories = new HashSet<MessageStoreFactory>();
        this.isJdbcStore(settings, impliedMessageStoreFactories);
        this.isFileStore(settings, impliedMessageStoreFactories);
        this.isSleepycatStore(settings, impliedMessageStoreFactories);
        if (impliedMessageStoreFactories.size() > 1) {
            throw new ConfigError("Ambiguous message store implied in configuration.");
        }
        Object messageStoreFactory = impliedMessageStoreFactories.size() == 1 ? (MessageStoreFactory)impliedMessageStoreFactories.iterator().next() : new MemoryStoreFactory();
        LOG.info("Inferring message store factory: {}", (Object)messageStoreFactory.getClass().getName());
        return messageStoreFactory;
    }

    private void isSleepycatStore(SessionSettings settings, Set<MessageStoreFactory> impliedMessageStoreFactories) {
        if (settings.isSetting("SleepycatDatabaseDir")) {
            impliedMessageStoreFactories.add((MessageStoreFactory)new SleepycatStoreFactory(settings));
        }
    }

    private void isFileStore(SessionSettings settings, Set<MessageStoreFactory> impliedMessageStoreFactories) {
        if (settings.isSetting("FileStorePath")) {
            impliedMessageStoreFactories.add((MessageStoreFactory)new FileStoreFactory(settings));
        }
    }

    private void isJdbcStore(SessionSettings settings, Set<MessageStoreFactory> impliedMessageStoreFactories) {
        if (settings.isSetting("JdbcDriver") || settings.isSetting("JdbcDataSourceName")) {
            impliedMessageStoreFactories.add((MessageStoreFactory)new JdbcStoreFactory(settings));
        }
    }

    private LogFactory inferLogFactory(SessionSettings settings) throws ConfigError {
        HashSet<LogFactory> impliedLogFactories = new HashSet<LogFactory>();
        this.isFileLog(settings, impliedLogFactories);
        this.isScreenLog(settings, impliedLogFactories);
        this.isSL4JLog(settings, impliedLogFactories);
        this.isJdbcLog(settings, impliedLogFactories);
        if (impliedLogFactories.size() > 1) {
            throw new ConfigError("Ambiguous log factory implied in configuration");
        }
        Object sessionLogFactory = impliedLogFactories.size() == 1 ? (LogFactory)impliedLogFactories.iterator().next() : new ScreenLogFactory(settings);
        LOG.info("Inferring log factory: {}", (Object)sessionLogFactory.getClass().getName());
        return sessionLogFactory;
    }

    private void isScreenLog(SessionSettings settings, Set<LogFactory> impliedLogFactories) {
        if (settings.isSetting("ScreenLogShowEvents") || settings.isSetting("ScreenLogShowIncoming") || settings.isSetting("ScreenLogShowOutgoing")) {
            impliedLogFactories.add((LogFactory)new ScreenLogFactory(settings));
        }
    }

    private void isFileLog(SessionSettings settings, Set<LogFactory> impliedLogFactories) {
        if (settings.isSetting("FileLogPath")) {
            impliedLogFactories.add((LogFactory)new FileLogFactory(settings));
        }
    }

    private void isJdbcLog(SessionSettings settings, Set<LogFactory> impliedLogFactories) {
        if ((settings.isSetting("JdbcDriver") || settings.isSetting("JdbcDataSourceName")) && settings.isSetting("JdbcLogEventTable")) {
            impliedLogFactories.add((LogFactory)new JdbcLogFactory(settings));
        }
    }

    private void isSL4JLog(SessionSettings settings, Set<LogFactory> impliedLogFactories) {
        for (Object key : settings.getDefaultProperties().keySet()) {
            if (!key.toString().startsWith("SLF4J")) continue;
            impliedLogFactories.add((LogFactory)new SLF4JLogFactory(settings));
            return;
        }
    }

    private boolean isConnectorRole(SessionSettings settings, String connectorRole) throws ConfigError {
        boolean hasRole = false;
        Iterator sessionIdItr = settings.sectionIterator();
        while (sessionIdItr.hasNext()) {
            if (!connectorRole.equals(settings.getString((SessionID)sessionIdItr.next(), "ConnectionType"))) continue;
            hasRole = true;
            break;
        }
        return hasRole;
    }

    public void addEventListener(QuickfixjEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(QuickfixjEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public String getUri() {
        return this.uri;
    }

    public MessageCorrelator getMessageCorrelator() {
        return this.messageCorrelator;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isLazy() {
        return this.lazy;
    }

    Initiator getInitiator() {
        return this.initiator;
    }

    Acceptor getAcceptor() {
        return this.acceptor;
    }

    MessageStoreFactory getMessageStoreFactory() {
        return this.messageStoreFactory;
    }

    LogFactory getLogFactory() {
        return this.sessionLogFactory;
    }

    MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    private class Dispatcher
    implements Application {
        private Dispatcher() {
        }

        public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
            try {
                this.dispatch(QuickfixjEventCategory.AdminMessageReceived, sessionID, message);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.rethrowIfType(e, FieldNotFound.class);
                this.rethrowIfType(e, IncorrectDataFormat.class);
                this.rethrowIfType(e, IncorrectTagValue.class);
                this.rethrowIfType(e, RejectLogon.class);
                throw new DispatcherException((Throwable)e);
            }
        }

        public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
            try {
                this.dispatch(QuickfixjEventCategory.AppMessageReceived, sessionID, message);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.rethrowIfType(e, FieldNotFound.class);
                this.rethrowIfType(e, IncorrectDataFormat.class);
                this.rethrowIfType(e, IncorrectTagValue.class);
                this.rethrowIfType(e, UnsupportedMessageType.class);
                throw new DispatcherException((Throwable)e);
            }
        }

        public void onCreate(SessionID sessionID) {
            try {
                this.dispatch(QuickfixjEventCategory.SessionCreated, sessionID, null);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        public void onLogon(SessionID sessionID) {
            try {
                this.dispatch(QuickfixjEventCategory.SessionLogon, sessionID, null);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        public void onLogout(SessionID sessionID) {
            try {
                this.dispatch(QuickfixjEventCategory.SessionLogoff, sessionID, null);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        public void toAdmin(Message message, SessionID sessionID) {
            try {
                this.dispatch(QuickfixjEventCategory.AdminMessageSent, sessionID, message);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        public void toApp(Message message, SessionID sessionID) throws DoNotSend {
            try {
                this.dispatch(QuickfixjEventCategory.AppMessageSent, sessionID, message);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        private <T extends Exception> void rethrowIfType(Exception e, Class<T> exceptionClass) throws T {
            if (e.getClass() == exceptionClass) {
                throw (Exception)exceptionClass.cast(e);
            }
        }

        private void dispatch(QuickfixjEventCategory quickfixjEventCategory, SessionID sessionID, Message message) throws Exception {
            LOG.debug("FIX event dispatched: {} {}", (Object)quickfixjEventCategory, message != null ? message : "");
            for (QuickfixjEventListener listener : QuickfixjEngine.this.eventListeners) {
                listener.onEvent(quickfixjEventCategory, sessionID, message);
            }
        }

        private class DispatcherException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            DispatcherException(Throwable cause) {
                super(cause);
            }
        }
    }

    public static enum ThreadModel {
        ThreadPerConnector,
        ThreadPerSession;

    }
}

