/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.quickfixj.CannotSendException;
import org.apache.camel.component.quickfixj.QuickfixjEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.quickfixj.QFJException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Session;
import quickfix.SessionID;

public class QuickfixjConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjConsumer.class);

    public QuickfixjConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public QuickfixjEndpoint getEndpoint() {
        return (QuickfixjEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        this.getEndpoint().addConsumer(this);
        this.getEndpoint().ensureInitialized();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getEndpoint().removeConsumer(this);
        super.doStop();
    }

    public void onExchange(Exchange exchange) {
        if (this.isStarted()) {
            try {
                this.getProcessor().process(exchange);
                if (exchange.getPattern().isOutCapable() && exchange.hasOut()) {
                    this.sendOutMessage(exchange);
                }
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
        }
    }

    private void sendOutMessage(Exchange exchange) throws QFJException {
        Message camelMessage = exchange.getMessage();
        quickfix.Message quickfixjMessage = (quickfix.Message)camelMessage.getBody(quickfix.Message.class);
        LOG.debug("Sending FIX message reply: {}", (Object)quickfixjMessage);
        SessionID messageSessionID = (SessionID)exchange.getIn().getHeader("SessionID", SessionID.class);
        Session session = this.getSession(messageSessionID);
        if (session == null) {
            throw new IllegalStateException("Unknown session: " + String.valueOf(messageSessionID));
        }
        if (!session.send(quickfixjMessage)) {
            throw new CannotSendException("Could not send FIX message reply: " + quickfixjMessage.toString());
        }
    }

    Session getSession(SessionID messageSessionID) {
        return Session.lookupSession((SessionID)messageSessionID);
    }
}

