/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq.reply;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.component.rabbitmq.reply.CorrelationListener;
import org.apache.camel.component.rabbitmq.reply.ReplyHandler;
import org.apache.camel.support.DefaultTimeoutMap;

public class CorrelationTimeoutMap
extends DefaultTimeoutMap<String, ReplyHandler> {
    private CorrelationListener listener;

    public CorrelationTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        super(executor, requestMapPollTimeMillis);
    }

    public void setListener(CorrelationListener listener) {
        this.listener = listener;
    }

    public boolean onEviction(String key, ReplyHandler value) {
        try {
            if (this.listener != null) {
                this.listener.onEviction(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            value.onTimeout(key);
        }
        catch (Throwable e) {
            this.log.warn("Error processing onTimeout for correlationID: " + key + " due: " + e.getMessage() + ". This exception is ignored.", e);
        }
        this.log.trace("Evicted correlationID: {}", (Object)key);
        return true;
    }

    public ReplyHandler get(String key) {
        ReplyHandler answer = (ReplyHandler)super.get((Object)key);
        this.log.trace("Get correlationID: {} -> {}", (Object)key, (Object)(answer != null ? 1 : 0));
        return answer;
    }

    public ReplyHandler put(String key, ReplyHandler value, long timeoutMillis) {
        try {
            if (this.listener != null) {
                this.listener.onPut(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ReplyHandler result = timeoutMillis <= 0L ? (ReplyHandler)super.put((Object)key, (Object)value, Integer.MAX_VALUE) : (ReplyHandler)super.put((Object)key, (Object)value, timeoutMillis);
        this.log.debug("Added correlationID: {} to timeout after: {} millis", (Object)key, (Object)timeoutMillis);
        return result;
    }

    public ReplyHandler putIfAbsent(String key, ReplyHandler value, long timeoutMillis) {
        this.log.trace("putIfAbsent with key {}", (Object)key);
        try {
            if (this.listener != null) {
                this.listener.onPut(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ReplyHandler result = timeoutMillis <= 0L ? (ReplyHandler)super.putIfAbsent((Object)key, (Object)value, Integer.MAX_VALUE) : (ReplyHandler)super.putIfAbsent((Object)key, (Object)value, timeoutMillis);
        if (result == null) {
            this.log.trace("Added correlationID: {} to timeout after: {} millis", (Object)key, (Object)timeoutMillis);
        } else {
            this.log.trace("Duplicate correlationID: {} detected", (Object)key);
        }
        return result;
    }

    public ReplyHandler remove(String key) {
        try {
            if (this.listener != null) {
                this.listener.onRemove(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ReplyHandler answer = (ReplyHandler)super.remove((Object)key);
        this.log.trace("Removed correlationID: {} -> {}", (Object)key, (Object)(answer != null ? 1 : 0));
        return answer;
    }
}

