/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaEndpoint;

public final class QueueReference {
    private final BlockingQueue<Exchange> queue;
    private Integer size;
    private Boolean multipleConsumers;
    private final Lock lock = new ReentrantLock();
    private final List<SedaEndpoint> endpoints = new LinkedList<SedaEndpoint>();

    QueueReference(BlockingQueue<Exchange> queue, Integer size, Boolean multipleConsumers) {
        this.queue = queue;
        this.size = size;
        this.multipleConsumers = multipleConsumers;
    }

    void addReference(SedaEndpoint endpoint) {
        this.lock.lock();
        try {
            if (!this.endpoints.contains((Object)endpoint)) {
                this.endpoints.add(endpoint);
                if (endpoint.isMultipleConsumers()) {
                    this.multipleConsumers = true;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void removeReference(SedaEndpoint endpoint) {
        this.lock.lock();
        try {
            this.endpoints.remove((Object)endpoint);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getCount() {
        this.lock.lock();
        try {
            int n = this.endpoints.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Integer getSize() {
        return this.size;
    }

    public Boolean getMultipleConsumers() {
        return this.multipleConsumers;
    }

    public BlockingQueue<Exchange> getQueue() {
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConsumers() {
        this.lock.lock();
        try {
            for (SedaEndpoint endpoint : this.endpoints) {
                if (endpoint.getConsumers().isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

