/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumer
extends ServiceSupport
implements Consumer,
RouteAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConsumer.class);
    private transient String consumerToString;
    private final Endpoint endpoint;
    private final Processor processor;
    private final AsyncProcessor asyncProcessor;
    private ExceptionHandler exceptionHandler;
    private Route route;
    private String routeId;

    public DefaultConsumer(Endpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
        this.asyncProcessor = AsyncProcessorConverterHelper.convert(processor);
        this.exceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), ((Object)((Object)this)).getClass());
    }

    public String toString() {
        if (this.consumerToString == null) {
            this.consumerToString = "Consumer[" + URISupport.sanitizeUri((String)this.endpoint.getEndpointUri()) + "]";
        }
        return this.consumerToString;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public UnitOfWork createUoW(Exchange exchange) throws Exception {
        if (this.route != null && exchange.getFromRouteId() == null) {
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setFromRouteId(this.route.getId());
        }
        UnitOfWork uow = ((ExtendedCamelContext)this.endpoint.getCamelContext().adapt(ExtendedCamelContext.class)).getUnitOfWorkFactory().createUnitOfWork(exchange);
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setUnitOfWork(uow);
        uow.start();
        return uow;
    }

    public void doneUoW(Exchange exchange) {
        UnitOfWorkHelper.doneUow(exchange.getUnitOfWork(), exchange);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public AsyncProcessor getAsyncProcessor() {
        return this.asyncProcessor;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected void doInit() throws Exception {
        LOG.debug("Init consumer: {}", (Object)this);
        ServiceHelper.initService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        LOG.debug("Stopping consumer: {}", (Object)this);
        ServiceHelper.stopService((Object)this.processor);
    }

    protected void doStart() throws Exception {
        LOG.debug("Starting consumer: {}", (Object)this);
        ServiceHelper.startService((Object)this.processor);
    }

    protected void handleException(Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(newt);
    }

    protected void handleException(String message, Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(message, newt);
    }
}

