/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@ManagedResource(description="Managed TimerEndpoint")
@UriEndpoint(firstVersion="1.0.0", scheme="timer", title="Timer", syntax="timer:timerName", consumerOnly=true, category={Category.CORE, Category.SCHEDULING})
public class TimerEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @UriPath
    @Metadata(required=true)
    private String timerName;
    @UriParam(defaultValue="1s", description="If greater than 0, generate periodic events every period.", javaType="java.time.Duration")
    private long period = 1000L;
    @UriParam(defaultValue="1s", description="Delay before first event is triggered.", javaType="java.time.Duration")
    private long delay = 1000L;
    @UriParam(defaultValue="0")
    private long repeatCount;
    @UriParam
    private boolean fixedRate;
    @UriParam(defaultValue="true", label="advanced")
    private boolean daemon = true;
    @UriParam(label="advanced")
    private Date time;
    @UriParam(label="advanced")
    private String pattern;
    @UriParam(label="advanced")
    private Timer timer;
    @UriParam(defaultValue="true")
    private boolean includeMetadata = true;
    @UriParam(defaultValue="false", label="advanced", description="Sets whether synchronous processing should be strictly used")
    private boolean synchronous;

    public TimerEndpoint() {
    }

    public TimerEndpoint(String uri, Component component, String timerName) {
        super(uri, component);
        this.timerName = timerName;
    }

    protected TimerEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public TimerComponent getComponent() {
        return (TimerComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        throw new RuntimeCamelException("Cannot produce to a TimerEndpoint: " + this.getEndpointUri());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        TimerConsumer answer = new TimerConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.timerName == null) {
            this.timerName = this.getEndpointUri();
        }
    }

    protected void doStop() throws Exception {
        this.setTimer(null);
        super.doStop();
    }

    @ManagedAttribute
    public boolean isMultipleConsumersSupported() {
        return true;
    }

    @ManagedAttribute(description="Timer Name")
    public String getTimerName() {
        return this.timerName;
    }

    @ManagedAttribute(description="Timer Name")
    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    @ManagedAttribute(description="Timer Daemon")
    public boolean isDaemon() {
        return this.daemon;
    }

    @ManagedAttribute(description="Timer Daemon")
    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @ManagedAttribute(description="Timer Delay")
    public long getDelay() {
        return this.delay;
    }

    @ManagedAttribute(description="Timer Delay")
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @ManagedAttribute(description="Timer FixedRate")
    public boolean isFixedRate() {
        return this.fixedRate;
    }

    @ManagedAttribute(description="Timer FixedRate")
    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    @ManagedAttribute(description="Timer Period")
    public long getPeriod() {
        return this.period;
    }

    @ManagedAttribute(description="Timer Period")
    public void setPeriod(long period) {
        this.period = period;
    }

    @ManagedAttribute(description="Repeat Count")
    public long getRepeatCount() {
        return this.repeatCount;
    }

    @ManagedAttribute(description="Repeat Count")
    public void setRepeatCount(long repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Timer getTimer(TimerConsumer consumer) {
        if (this.timer != null) {
            return this.timer;
        }
        return this.getComponent().getTimer(consumer);
    }

    @ManagedAttribute(description="Include metadata")
    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    @ManagedAttribute(description="Include metadata")
    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void removeTimer(TimerConsumer consumer) {
        if (this.timer == null) {
            this.getComponent().removeTimer(consumer);
        }
    }
}

