/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.undertow.UndertowClientCallback;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.util.IOHelper;
import org.xnio.channels.StreamSinkChannel;

class UndertowStreamingClientCallback
extends UndertowClientCallback {
    private InputStream bodyStream;

    UndertowStreamingClientCallback(Exchange exchange, AsyncCallback callback, UndertowEndpoint endpoint, ClientRequest request, ByteBuffer body) {
        super(exchange, callback, endpoint, request, body);
        this.bodyStream = null;
    }

    UndertowStreamingClientCallback(Exchange exchange, AsyncCallback callback, UndertowEndpoint endpoint, ClientRequest request, InputStream body) {
        super(exchange, callback, endpoint, request, null);
        this.bodyStream = body;
    }

    @Override
    protected void finish(Message result) {
        boolean close = true;
        if (result != null && result.getBody() instanceof InputStream) {
            close = false;
        }
        this.finish(result, close);
    }

    @Override
    protected void writeRequest(ClientExchange clientExchange) {
        if (this.bodyStream == null) {
            super.writeRequest(clientExchange);
            return;
        }
        StreamSinkChannel requestChannel = clientExchange.getRequestChannel();
        try (ReadableByteChannel source = Channels.newChannel(this.bodyStream);){
            IOHelper.transfer((ReadableByteChannel)source, (WritableByteChannel)requestChannel);
            UndertowStreamingClientCallback.flush(requestChannel);
        }
        catch (IOException e) {
            this.hasFailedWith(e);
        }
    }
}

