/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.camel.util.StringHelper;

public final class SensitiveUtils {
    private static final Set<String> SENSITIVE_KEYS = new HashSet<String>(Arrays.asList("accesskey", "accesstoken", "accesstokensecret", "accountkey", "accountsid", "acltoken", "authkey", "authorizationtoken", "blobaccesskey", "blobstoragesharedkeycredential", "certresourcepassword", "cipherkey", "clientsecret", "connectionstring", "consumerkey", "consumersecret", "emailaddress", "fulltokenid", "httpproxypassword", "keypassword", "keystore", "keystorepassword", "login", "oauthaccesstoken", "oauthappid", "oauthappsecret", "oauthclientid", "oauthclientsecret", "oauthtoken", "oauthtokenurl", "p12filename", "passcode", "passphrase", "password", "privatekey", "privatekeyfile", "privatekeyname", "privatekeypassword", "proxyauthpassword", "proxyauthusername", "proxypassword", "proxyuser", "publickeyid", "publishkey", "queueownerawsaccountid", "refreshtoken", "sasljaasconfig", "secretkey", "securerandom", "sharedaccesskey", "sslkeypassword", "sslkeystore", "sslkeystorepassword", "sslpassword", "ssltruststorepassword", "subscribekey", "systemid", "token", "user", "userauthenticationcredentials", "username", "userpassword", "verificationcode", "zookeeperpassword"));

    private SensitiveUtils() {
    }

    public static boolean containsSensitive(String text) {
        int lastPeriod = text.lastIndexOf(46);
        if (lastPeriod >= 0) {
            text = text.substring(lastPeriod + 1);
        }
        text = text.toLowerCase(Locale.ENGLISH);
        text = StringHelper.replaceAll(text, "-", "");
        return SENSITIVE_KEYS.contains(text);
    }
}

