/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientSessions
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(ClientSessions.class);
    private final int expectedCount;
    private final URI uri;
    private final ClientEndpointConfig config;
    private final WebSocketContainer container;
    private final BlockingQueue<Session> sessions;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final BiConsumer<Session, Object> onMessage;

    ClientSessions(int count, URI uri, ClientEndpointConfig config, BiConsumer<Session, Object> onMessage) {
        this.uri = uri;
        this.expectedCount = count;
        this.config = config;
        this.onMessage = onMessage;
        this.sessions = new ArrayBlockingQueue<Session>(this.expectedCount);
        this.container = ContainerProvider.getWebSocketContainer();
    }

    public void prepare() {
        this.sessions.addAll(IntStream.range(0, this.expectedCount).mapToObj(idx -> this.doConnect()).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Consumer<Session> apply) {
        Session session = null;
        try {
            session = this.sessions.take();
            apply.accept(session);
        }
        catch (RuntimeException re) {
            this.log.error(re.getMessage(), (Throwable)re);
            if (session.isOpen()) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, re.getMessage()));
                }
                catch (IOException errorOnClose) {
                    this.log.debug(errorOnClose.getMessage(), (Throwable)errorOnClose);
                }
            }
            session = null;
            throw re;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (session != null) {
                this.sessions.offer(session);
            }
        }
    }

    private Session doConnect() {
        try {
            Session session = this.container.connectToServer(new Endpoint(){

                public void onOpen(Session session, EndpointConfig endpointConfig) {
                    ClientSessions.this.log.debug("Session opened #{}", (Object)session.getId());
                }

                public void onClose(Session session, CloseReason closeReason) {
                    ClientSessions.this.sessions.remove(session);
                    ClientSessions.this.log.debug("Session closed #{}", (Object)session.getId());
                }

                public void onError(Session session, Throwable throwable) {
                    if (session.isOpen()) {
                        try {
                            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, "an exception occured"));
                        }
                        catch (IOException e) {
                            ClientSessions.this.log.debug("Error closing session #{}", (Object)session.getId(), (Object)e);
                        }
                    }
                    ClientSessions.this.sessions.remove(session);
                    ClientSessions.this.log.debug("Error on session #{}", (Object)session.getId(), (Object)throwable);
                    if (!ClientSessions.this.closed.get()) {
                        ClientSessions.this.sessions.offer(ClientSessions.this.doConnect());
                    }
                }
            }, this.config, this.uri);
            if (this.onMessage != null) {
                session.addMessageHandler(InputStream.class, message -> this.onMessage.accept(session, message));
                session.addMessageHandler(String.class, message -> this.onMessage.accept(session, message));
            }
            return session;
        }
        catch (IOException | DeploymentException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.sessions.forEach(it -> {
            if (it.isOpen()) {
                try {
                    it.close();
                }
                catch (IOException e) {
                    this.log.debug(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.sessions.clear();
    }
}

