/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.websocket.jsr356.JSR356Consumer;
import org.apache.camel.websocket.jsr356.JSR356Producer;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;

@UriEndpoint(firstVersion="2.23.0", scheme="websocket-jsr356", title="Javax Websocket", syntax="websocket-jsr356:uri", category={Category.HTTP})
public class JSR356Endpoint
extends DefaultEndpoint {
    @UriPath(description="If a schemeless URI path is provided, a ServerEndpoint is deployed under that path. Else if the URI is prefixed with the 'ws://' scheme, then a connection is established to the corresponding server")
    private URI uri;
    @UriParam(description="Used when the endpoint is in client mode to populate a pool of sessions", defaultValue="1")
    private int sessionCount = 1;

    public JSR356Endpoint(JSR356WebSocketComponent component, String uri) {
        super(uri, (Component)component);
    }

    public JSR356WebSocketComponent getComponent() {
        return (JSR356WebSocketComponent)((Object)JSR356WebSocketComponent.class.cast(super.getComponent()));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        JSR356Consumer consumer = new JSR356Consumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() {
        return new JSR356Producer(this);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public void setSessionCount(int sessionCount) {
        this.sessionCount = sessionCount;
    }
}

