/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.PlatformHttpListener;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.component.platform.http.springboot.SpringBootPlatformHttpConsumer;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.ReflectionHelper;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.ServletRequestPathUtils;

public class CamelRequestHandlerMapping
extends RequestMappingHandlerMapping
implements PlatformHttpListener {
    private final PlatformHttpComponent component;
    private final PlatformHttpEngine engine;
    private CorsConfiguration corsConfiguration;

    public CamelRequestHandlerMapping(PlatformHttpComponent component, PlatformHttpEngine engine) {
        this.component = component;
        this.engine = engine;
        this.component.addPlatformHttpListener((PlatformHttpListener)this);
    }

    public int getOrder() {
        return -1;
    }

    protected String[] getCandidateBeanNames() {
        return new String[0];
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        return null;
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        RestConfiguration restConfiguration = this.component.getCamelContext().getRestConfiguration();
        if (!restConfiguration.isEnableCORS()) {
            return null;
        }
        if (this.corsConfiguration == null) {
            Map<String, String> corsHeaders = restConfiguration.getCorsHeaders();
            this.corsConfiguration = this.createCorsConfiguration(corsHeaders != null ? corsHeaders : Collections.emptyMap());
        }
        return this.corsConfiguration;
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        return super.getCorsConfiguration(handler, request);
    }

    private CorsConfiguration createCorsConfiguration(Map<String, String> corsHeaders) {
        CorsConfiguration config = new CorsConfiguration();
        String allowedOrigin = corsHeaders.get("Access-Control-Allow-Origin");
        config.addAllowedOrigin(allowedOrigin != null ? allowedOrigin : "*");
        String allowMethodsStr = corsHeaders.get("Access-Control-Allow-Methods");
        allowMethodsStr = allowMethodsStr != null ? allowMethodsStr : "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        for (String allowMethod : allowMethodsStr.split(",")) {
            config.addAllowedMethod(allowMethod.trim());
        }
        String allowHeadersStr = corsHeaders.get("Access-Control-Allow-Headers");
        allowHeadersStr = allowHeadersStr != null ? allowHeadersStr : "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        for (String allowHeader : allowHeadersStr.split(",")) {
            config.addAllowedHeader(allowHeader.trim());
        }
        String maxAgeStr = corsHeaders.get("Access-Control-Max-Age");
        Long maxAge = maxAgeStr != null ? Long.parseLong(maxAgeStr) : Long.parseLong("3600");
        config.setMaxAge(maxAge);
        String allowCredentials = corsHeaders.get("Access-Control-Allow-Credentials");
        config.setAllowCredentials(Boolean.valueOf(Boolean.parseBoolean(allowCredentials)));
        return config;
    }

    protected HandlerMethod getHandlerInternal(HttpServletRequest request) throws Exception {
        ServletRequestPathUtils.parseAndCache((HttpServletRequest)request);
        return super.getHandlerInternal(request);
    }

    public void registerHttpEndpoint(HttpEndpointModel model) {
        List<RequestMappingInfo> requestMappingInfos = this.asRequestMappingInfo(model);
        Method m = ReflectionHelper.findMethod(SpringBootPlatformHttpConsumer.class, (String)"service", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
        for (RequestMappingInfo info : requestMappingInfos) {
            this.unregisterMapping(info);
            this.registerMapping(info, model.getConsumer(), m);
        }
    }

    public void unregisterHttpEndpoint(HttpEndpointModel model) {
    }

    private List<RequestMappingInfo> asRequestMappingInfo(HttpEndpointModel model) {
        PlatformHttpEndpoint endpoint;
        ArrayList<RequestMappingInfo> result = new ArrayList<RequestMappingInfo>();
        ArrayList<RequestMethod> methods = new ArrayList<RequestMethod>();
        String verbs = model.getVerbs();
        if (verbs == null && model.getConsumer() != null && (verbs = (endpoint = (PlatformHttpEndpoint)model.getConsumer().getEndpoint()).getHttpMethodRestrict()) == null) {
            Collections.addAll(methods, RequestMethod.values());
        }
        if (verbs != null) {
            for (String v : model.getVerbs().split(",")) {
                RequestMethod rm = RequestMethod.resolve((String)v);
                methods.add(rm);
            }
        }
        if (this.component.getCamelContext().getRestConfiguration().isEnableCORS()) {
            methods.remove(RequestMethod.OPTIONS);
        }
        for (RequestMethod rm : methods) {
            this.createRequestMappingInfo(model, rm, result);
        }
        return result;
    }

    private void createRequestMappingInfo(HttpEndpointModel model, RequestMethod rm, List<RequestMappingInfo> result) {
        RequestMethod[] methods = new RequestMethod[]{};
        if (rm != null) {
            methods = new RequestMethod[]{rm};
        }
        SpringBootPlatformHttpConsumer consumer = (SpringBootPlatformHttpConsumer)model.getConsumer();
        Object uri = model.getUri();
        if (consumer.getEndpoint().isMatchOnUriPrefix()) {
            uri = (String)uri + (((String)uri).endsWith("/") ? "" : "/");
            uri = (String)uri + "{*matchOnUriPrefix}";
        }
        RequestMappingInfo.Builder info = RequestMappingInfo.paths((String[])new String[]{uri}).methods(methods).options(this.getBuilderConfiguration());
        if (model.getConsumes() != null && (RequestMethod.POST.name().equals(rm.name()) || RequestMethod.PUT.name().equals(rm.name()) || RequestMethod.PATCH.name().equals(rm.name()))) {
            info.consumes(model.getConsumes().split(","));
        }
        if (model.getProduces() != null) {
            info.produces(model.getProduces().split(","));
        }
        result.add(info.build());
    }
}

