/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.util.ObjectHelper;

public class PlatformHttpMessage
extends DefaultMessage {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpBinding binding;
    private boolean requestRead;

    public PlatformHttpMessage(Exchange exchange, HttpBinding binding, HttpServletRequest request, HttpServletResponse response) {
        super(exchange);
        this.init(exchange, binding, request, response);
    }

    public PlatformHttpMessage(HttpServletRequest request, HttpServletResponse response, Exchange exchange, HttpBinding binding, boolean requestRead) {
        super(exchange);
        this.request = request;
        this.response = response;
        this.binding = binding;
        this.requestRead = requestRead;
    }

    public void init(Exchange exchange, HttpBinding binding, HttpServletRequest request, HttpServletResponse response) {
        StreamCache newBody;
        this.setExchange(exchange);
        exchange.setIn((Message)this);
        this.requestRead = false;
        this.binding = binding;
        this.request = request;
        this.response = response;
        this.setHeader("CamelHttpServletRequest", request);
        this.setHeader("CamelHttpServletResponse", response);
        Boolean flag = (Boolean)exchange.getProperty("CamelSkipWwwFormUrlEncoding", Boolean.class);
        if (flag != null && flag.booleanValue()) {
            this.setHeader("CamelSkipWwwFormUrlEncoding", Boolean.TRUE);
        }
        if ((newBody = (StreamCache)this.camelContext.getTypeConverter().tryConvertTo(StreamCache.class, exchange, this.getBody())) != null) {
            this.setBody(newBody);
        }
        binding.readRequest(request, (Message)this);
    }

    public void reset() {
        super.reset();
        this.request = null;
        this.response = null;
        this.binding = null;
        this.requestRead = false;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    protected Object createBody() {
        Object body;
        if (this.requestRead) {
            return null;
        }
        try {
            body = this.binding.parseBody(this.request, (Message)this);
        }
        catch (IOException var5) {
            throw new RuntimeCamelException((Throwable)var5);
        }
        finally {
            this.requestRead = true;
        }
        return body;
    }

    public PlatformHttpMessage newInstance() {
        PlatformHttpMessage answer = new PlatformHttpMessage(this.request, this.response, this.getExchange(), this.binding, this.requestRead);
        if (answer.camelContext == null) {
            answer.setCamelContext(this.camelContext);
        }
        return answer;
    }

    public String toString() {
        return "PlatformHttpMessage@" + ObjectHelper.getIdentityHashCode((Object)((Object)this));
    }
}

