/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.attachment.CamelFileDataSource;
import org.apache.camel.attachment.DefaultAttachmentMessage;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.Method;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public class SpringBootPlatformHttpBinding
extends DefaultHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootPlatformHttpBinding.class);
    private static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final List<Method> METHODS_WITH_BODY_ALLOWED = List.of(Method.POST, Method.PUT, Method.PATCH, Method.DELETE);
    private static final List<Method> METHODS_WITH_REQUEST_ALREADY_READ = List.of(Method.PUT, Method.PATCH, Method.DELETE);

    protected void populateRequestParameters(HttpServletRequest request, Message message) {
        super.populateRequestParameters(request, message);
        String path = request.getRequestURI();
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path != null) {
            PlatformHttpEndpoint endpoint = (PlatformHttpEndpoint)message.getExchange().getFromEndpoint();
            String consumerPath = endpoint.getPath();
            if (consumerPath != null && consumerPath.startsWith("/")) {
                consumerPath = consumerPath.substring(1);
            }
            if (this.useRestMatching(consumerPath)) {
                HttpHelper.evalPlaceholders((Map)message.getHeaders(), (String)path, (String)consumerPath);
            }
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }

    protected void populateAttachments(HttpServletRequest request, Message message) {
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            File tmpFolder = (File)request.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
            boolean isSingleAttachment = multipartHttpServletRequest.getFileMap() != null && multipartHttpServletRequest.getFileMap().keySet().size() == 1;
            message.setHeader("CamelAttachmentsSize", (Object)multipartHttpServletRequest.getFileMap().keySet().size());
            multipartHttpServletRequest.getFileMap().forEach((name, multipartFile) -> {
                try {
                    String ext;
                    Path uploadedTmpFile = Paths.get(tmpFolder.getPath(), UUID.randomUUID().toString());
                    multipartFile.transferTo(uploadedTmpFile);
                    if (name != null) {
                        name = name.replaceAll("[\n\r\t]", "_");
                    }
                    boolean accepted = true;
                    if (this.getFileNameExtWhitelist() != null && (ext = FileUtil.onlyExt((String)name)) != null) {
                        ext = ext.toLowerCase(Locale.US);
                        if (!this.getFileNameExtWhitelist().equals("*") && !this.getFileNameExtWhitelist().contains(ext)) {
                            accepted = false;
                        }
                    }
                    if (accepted) {
                        DefaultAttachmentMessage am = new DefaultAttachmentMessage(message);
                        File uploadedFile = uploadedTmpFile.toFile();
                        am.addAttachment(name, new DataHandler((DataSource)new CamelFileDataSource(uploadedFile, name)));
                        if (isSingleAttachment) {
                            message.setHeader("CamelFilePath", (Object)uploadedFile.getAbsolutePath());
                            message.setHeader("CamelFileLength", (Object)multipartFile.getSize());
                            message.setHeader("CamelFileName", (Object)multipartFile.getOriginalFilename());
                            if (multipartFile.getContentType() != null) {
                                message.setHeader("CamelFileContentType", (Object)multipartFile.getContentType());
                            }
                            message.setBody((Object)uploadedTmpFile);
                        }
                    } else {
                        LOG.debug("Cannot add file as attachment: {} because the file is not accepted according to fileNameExtWhitelist: {}", name, (Object)this.getFileNameExtWhitelist());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public Object parseBody(HttpServletRequest request, Message message) throws IOException {
        if (request instanceof StandardMultipartHttpServletRequest || this.requestAlreadyRead(request)) {
            return null;
        }
        return super.parseBody(request, message);
    }

    public void readRequest(HttpServletRequest request, Message message) {
        super.readRequest(request, message);
        SpringBootPlatformHttpBinding.populateMultiFormData(request, message);
    }

    private static void populateMultiFormData(HttpServletRequest request, Message message) {
        if (((PlatformHttpEndpoint)message.getExchange().getFromEndpoint()).isPopulateBodyWithForm() && METHODS_WITH_BODY_ALLOWED.contains(Method.valueOf((String)request.getMethod())) && (message.getBody() instanceof StreamCache || message.getBody() == null && !"POST".equals(request.getMethod())) && request.getContentType() != null && request.getContentType().contains(CONTENT_TYPE_FORM_URLENCODED)) {
            if ("POST".equals(request.getMethod())) {
                String body = (String)message.getBody(String.class);
                try {
                    message.setBody((Object)URISupport.parseQuery((String)body));
                }
                catch (URISyntaxException e) {
                    LOG.error("Cannot parse body: {}", (Object)body, (Object)e);
                    throw new RuntimeCamelException((Throwable)e);
                }
            } else {
                message.setBody((Object)request.getParameterMap());
            }
        }
    }

    private boolean requestAlreadyRead(HttpServletRequest request) {
        return Objects.nonNull(request.getContentType()) && request.getContentType().contains(CONTENT_TYPE_FORM_URLENCODED) && METHODS_WITH_REQUEST_ALREADY_READ.contains(Method.valueOf((String)request.getMethod()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteDirectResponse(Message message, HttpServletResponse response, Exchange exchange) throws IOException {
        block29: {
            block27: {
                ServletOutputStream os;
                InputStream is;
                block28: {
                    CachedOutputStream stream;
                    block26: {
                        String contentType = (String)message.getHeader("Content-Type", String.class);
                        if ("application/x-java-serialized-object".equals(contentType)) {
                            if (!this.isAllowJavaSerializedObject() && !this.isTransferException()) {
                                throw new RuntimeCamelException("Content-type application/x-java-serialized-object is not allowed");
                            }
                            try {
                                Object object = message.getMandatoryBody(Serializable.class);
                                org.apache.camel.http.common.HttpHelper.writeObjectToServletResponse((ServletResponse)response, (Object)object);
                            }
                            catch (InvalidPayloadException var19) {
                                InvalidPayloadException e = var19;
                                throw new IOException(e);
                            }
                        }
                        is = null;
                        if (this.checkChunked(message, exchange)) {
                            is = (InputStream)message.getBody(InputStream.class);
                        } else if (!this.isText(contentType)) {
                            is = (InputStream)exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, message.getBody());
                        }
                        if (is == null) break block27;
                        os = response.getOutputStream();
                        if (this.checkChunked(message, exchange)) break block28;
                        stream = new CachedOutputStream(exchange);
                        try {
                            int len = this.copyStream(is, (OutputStream)stream, response.getBufferSize());
                            response.setContentLength(len);
                            OutputStream current = stream.getCurrentStream();
                            if (current instanceof ByteArrayOutputStream) {
                                ByteArrayOutputStream bos = (ByteArrayOutputStream)current;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Streaming (direct) response in non-chunked mode with content-length {}", (Object)len);
                                }
                                bos.writeTo((OutputStream)os);
                                break block26;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Streaming response in non-chunked mode with content-length {} and buffer size: {}", (Object)len, (Object)len);
                            }
                            this.copyStream(stream.getInputStream(), (OutputStream)os, len);
                        }
                        catch (Throwable throwable) {
                            IOHelper.close((Closeable[])new Closeable[]{is, os});
                            stream.close();
                            throw throwable;
                        }
                    }
                    IOHelper.close((Closeable[])new Closeable[]{is, os});
                    stream.close();
                    break block29;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Streaming response in chunked mode with buffer size {}", (Object)response.getBufferSize());
                }
                this.copyStream(is, (OutputStream)os, response.getBufferSize());
                break block29;
            }
            Object body = message.getBody();
            if (body instanceof String) {
                String data = (String)message.getBody(String.class);
                if (data != null) {
                    String charset = ExchangeHelper.getCharsetName((Exchange)exchange, (boolean)true);
                    int len = data.getBytes(charset).length;
                    response.setCharacterEncoding(charset);
                    response.setContentLength(len);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Writing response in non-chunked mode as plain text with content-length {} and buffer size: {}", (Object)len, (Object)response.getBufferSize());
                    }
                    try {
                        response.getWriter().print(data);
                    }
                    finally {
                        response.getWriter().flush();
                    }
                }
            } else if (body instanceof InputStream) {
                InputStream bodyIS = (InputStream)message.getBody(InputStream.class);
                bodyIS.transferTo((OutputStream)response.getOutputStream());
            } else {
                TypeConverter tc = exchange.getContext().getTypeConverter();
                ByteBuffer bb = (ByteBuffer)tc.tryConvertTo(ByteBuffer.class, exchange, body);
                if (bb != null) {
                    response.getOutputStream().write(bb.array());
                } else {
                    try {
                        InputStream bodyIS = (InputStream)tc.mandatoryConvertTo(InputStream.class, exchange, body);
                        bodyIS.transferTo((OutputStream)response.getOutputStream());
                    }
                    catch (NoTypeConversionAvailableException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    protected String getRawPath(HttpServletRequest request) {
        String contextPath;
        String uri = request.getRequestURI();
        String string = contextPath = request.getContextPath() == null ? "" : request.getContextPath();
        if (contextPath.isEmpty() || contextPath.equals("/")) {
            return uri;
        }
        return uri.substring(contextPath.length());
    }
}

