/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.cookie.CookieConfiguration;
import org.apache.camel.component.platform.http.cookie.CookieHandler;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumer;
import org.apache.camel.component.platform.http.springboot.PlatformHttpMessage;
import org.apache.camel.component.platform.http.springboot.SpringBootPlatformHttpBinding;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ResponseBody;

public class SpringBootPlatformHttpConsumer
extends DefaultConsumer
implements PlatformHttpConsumer,
Suspendable,
SuspendableService {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootPlatformHttpConsumer.class);
    private HttpBinding binding = new SpringBootPlatformHttpBinding();
    private final boolean handleWriteResponseError;
    private CookieConfiguration cookieConfiguration;
    private Executor executor;

    public SpringBootPlatformHttpConsumer(PlatformHttpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.binding.setHeaderFilterStrategy(endpoint.getHeaderFilterStrategy());
        this.binding.setMuteException(endpoint.isMuteException());
        this.binding.setFileNameExtWhitelist(endpoint.getFileNameExtWhitelist());
        this.binding.setUseReaderForPayload(!endpoint.isUseStreaming());
        this.handleWriteResponseError = endpoint.isHandleWriteResponseError();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public SpringBootPlatformHttpConsumer(PlatformHttpEndpoint endpoint, Processor processor, Executor executor) {
        this(endpoint, processor);
        this.executor = executor;
    }

    void setBinding(HttpBinding binding) {
        this.binding = binding;
    }

    public PlatformHttpEndpoint getEndpoint() {
        return (PlatformHttpEndpoint)super.getEndpoint();
    }

    @ResponseBody
    public CompletableFuture<Void> service(HttpServletRequest request, HttpServletResponse response) {
        return CompletableFuture.runAsync(() -> {
            LOG.trace("Service: {}", (Object)request);
            try {
                this.handleService(request, response);
            }
            catch (Exception e) {
                LOG.warn("Error handling request due to: {}", (Object)e.getMessage(), (Object)e);
                try {
                    if (!response.isCommitted()) {
                        response.sendError(500);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isSuspended()) {
            LOG.debug("Consumer suspended, cannot service request: {}", (Object)request);
            response.sendError(503);
            return;
        }
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(ExchangePattern.InOut);
        HttpHelper.setCharsetFromContentType((String)request.getContentType(), (Exchange)exchange);
        PlatformHttpMessage msg = new PlatformHttpMessage(request, response, exchange, this.binding, false);
        exchange.setIn((Message)msg);
        msg.init(exchange, this.binding, request, response);
        String contextPath = this.getEndpoint().getPath();
        exchange.getIn().setHeader("CamelPlatformHttpContextPath", (Object)contextPath);
        if (this.getEndpoint().isUseCookieHandler()) {
            this.cookieConfiguration = this.getEndpoint().getCookieConfiguration();
            exchange.setProperty("CamelCookieHandler", (Object)new SpringBootCookieHandler(request, response));
        }
        try {
            this.createUoW(exchange);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            this.afterProcess(response, exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterProcess(HttpServletResponse response, Exchange exchange) throws Exception {
        boolean writeFailure = false;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Writing res for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            this.binding.writeResponse(exchange, response);
        }
        catch (Exception e) {
            writeFailure = true;
            this.handleFailure(exchange, e);
        }
        finally {
            this.doneUoW(exchange);
            this.releaseExchange(exchange, false);
        }
        try {
            if (writeFailure && !response.isCommitted()) {
                response.sendError(500);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleFailure(Exchange exchange, Throwable failure) {
        this.getExceptionHandler().handleException("Failed writing HTTP response url: " + this.getEndpoint().getPath() + " due to: " + failure.getMessage(), failure);
        if (this.handleWriteResponseError) {
            Exception existing = exchange.getException();
            if (existing != null) {
                failure.addSuppressed(existing);
            }
            exchange.setProperty("CamelExceptionCaught", (Object)failure);
            exchange.setException(failure);
        }
    }

    class SpringBootCookieHandler
    implements CookieHandler {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        public SpringBootCookieHandler(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public void addCookie(String cookieName, String cookieValue) {
            Cookie cookie = new Cookie(cookieName, cookieValue);
            cookie.setPath(SpringBootPlatformHttpConsumer.this.cookieConfiguration.getCookiePath());
            cookie.setDomain(SpringBootPlatformHttpConsumer.this.cookieConfiguration.getCookieDomain());
            cookie.setSecure(SpringBootPlatformHttpConsumer.this.cookieConfiguration.isCookieSecure());
            cookie.setHttpOnly(SpringBootPlatformHttpConsumer.this.cookieConfiguration.isCookieHttpOnly());
            cookie.setAttribute("SameSite", SpringBootPlatformHttpConsumer.this.cookieConfiguration.getCookieSameSite().getValue());
            if (SpringBootPlatformHttpConsumer.this.cookieConfiguration.getCookieMaxAge() != null) {
                cookie.setMaxAge(Math.toIntExact(SpringBootPlatformHttpConsumer.this.cookieConfiguration.getCookieMaxAge()));
            }
            this.response.addCookie(cookie);
        }

        public String removeCookie(String cookieName) {
            Cookie cookieToRemove = new Cookie(cookieName, null);
            cookieToRemove.setPath(SpringBootPlatformHttpConsumer.this.cookieConfiguration.getCookiePath());
            cookieToRemove.setMaxAge(0);
            this.response.addCookie(cookieToRemove);
            return cookieName;
        }

        public String getCookieValue(@CookieValue String cookieName) {
            Cookie[] cookie = this.request.getCookies();
            if (cookie != null) {
                for (Cookie c : cookie) {
                    if (!c.getName().equals(cookieName)) continue;
                    return c.getValue();
                }
            }
            return "Cookie not found";
        }
    }
}

