/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import org.apache.camel.component.platform.http.springboot.PlatformHttpComponentConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, PlatformHttpComponentConfiguration.class, WebMvcProperties.class})
public class SpringBootPlatformWebMvcConfiguration
implements WebMvcConfigurer {
    private PlatformHttpComponentConfiguration platformHttpComponentConfiguration;
    private WebMvcProperties webMvcProperties;

    public SpringBootPlatformWebMvcConfiguration(PlatformHttpComponentConfiguration platformHttpComponentConfiguration, WebMvcProperties webMvcProperties) {
        this.platformHttpComponentConfiguration = platformHttpComponentConfiguration;
        this.webMvcProperties = webMvcProperties;
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        if (this.webMvcProperties.getAsync().getRequestTimeout() == null && this.platformHttpComponentConfiguration.getRequestTimeout() != null) {
            configurer.setDefaultTimeout(this.platformHttpComponentConfiguration.getRequestTimeout().longValue());
        }
        if (this.webMvcProperties.getAsync().getRequestTimeout() != null && this.platformHttpComponentConfiguration.getRequestTimeout() == null) {
            this.platformHttpComponentConfiguration.setRequestTimeout(this.webMvcProperties.getAsync().getRequestTimeout().toMillis());
        }
    }
}

