/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot.actuate.metrics.undertow;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.XnioWorker;

public class UndertowMetrics
implements MeterBinder,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowMetrics.class);
    private final XnioWorker xnioWorker;
    private final SessionManager sessionManager;
    private final Deployment deployment;
    private final Iterable<Tag> tags;
    private final MBeanServer mBeanServer;

    public UndertowMetrics(XnioWorker xnioWorker, SessionManager sessionManager, Iterable<Tag> tags) {
        this(xnioWorker, sessionManager, null, tags, ManagementFactory.getPlatformMBeanServer());
    }

    public UndertowMetrics(XnioWorker xnioWorker, SessionManager sessionManager, Deployment deployment, Iterable<Tag> tags) {
        this(xnioWorker, sessionManager, deployment, tags, ManagementFactory.getPlatformMBeanServer());
    }

    public UndertowMetrics(XnioWorker xnioWorker, SessionManager sessionManager, Deployment deployment, Iterable<Tag> tags, MBeanServer mBeanServer) {
        this.xnioWorker = xnioWorker;
        this.sessionManager = sessionManager;
        this.deployment = deployment;
        this.tags = tags;
        this.mBeanServer = mBeanServer;
    }

    public static void monitor(MeterRegistry registry, XnioWorker xnioWorker, SessionManager sessionManager, String ... tags) {
        UndertowMetrics.monitor(registry, xnioWorker, sessionManager, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public static void monitor(MeterRegistry registry, XnioWorker xnioWorker, SessionManager sessionManager, Iterable<Tag> tags) {
        new UndertowMetrics(xnioWorker, sessionManager, tags).bindTo(registry);
    }

    public static void monitor(MeterRegistry registry, XnioWorker xnioWorker, SessionManager sessionManager, Deployment deployment, Iterable<Tag> tags) {
        new UndertowMetrics(xnioWorker, sessionManager, deployment, tags).bindTo(registry);
    }

    public void bindTo(MeterRegistry registry) {
        this.registerWorkerThreadMetrics(registry);
        this.registerSessionMetrics(registry);
        this.registerJmxMetrics(registry);
    }

    private void registerWorkerThreadMetrics(MeterRegistry registry) {
        if (this.xnioWorker == null) {
            return;
        }
        Gauge.builder((String)"undertow.threads.worker.core", (Object)this.xnioWorker, this::getCoreWorkerPoolSize).tags(this.tags).baseUnit("threads").description("Core worker thread pool size").register(registry);
        Gauge.builder((String)"undertow.threads.worker.max", (Object)this.xnioWorker, this::getMaxWorkerPoolSize).tags(this.tags).baseUnit("threads").description("Maximum worker thread pool size").register(registry);
        Gauge.builder((String)"undertow.threads.worker.current", (Object)this.xnioWorker, this::getCurrentWorkerThreadCount).tags(this.tags).baseUnit("threads").description("Current worker thread count").register(registry);
        Gauge.builder((String)"undertow.threads.worker.busy", (Object)this.xnioWorker, this::getBusyWorkerThreadCount).tags(this.tags).baseUnit("threads").description("Busy worker thread count").register(registry);
        Gauge.builder((String)"undertow.threads.worker.utilization", (Object)this.xnioWorker, this::getWorkerThreadUtilization).tags(this.tags).baseUnit("percent").description("Worker thread utilization percentage").register(registry);
        Gauge.builder((String)"undertow.threads.worker.queue.size", (Object)this.xnioWorker, this::getWorkerQueueSize).tags(this.tags).description("Worker thread queue size").register(registry);
        Gauge.builder((String)"undertow.threads.io", (Object)this.xnioWorker, XnioWorker::getIoThreadCount).tags(this.tags).baseUnit("threads").description("IO thread count").register(registry);
    }

    private void registerSessionMetrics(MeterRegistry registry) {
        if (this.sessionManager == null) {
            return;
        }
        Gauge.builder((String)"undertow.sessions.active.current", (Object)this.sessionManager, this::getActiveSessions).tags(this.tags).baseUnit("sessions").description("Current active sessions").register(registry);
        Gauge.builder((String)"undertow.sessions.active.max", (Object)this.sessionManager, this::getMaxSessions).tags(this.tags).baseUnit("sessions").description("Maximum sessions allowed").register(registry);
        FunctionCounter.builder((String)"undertow.sessions.created", (Object)this.sessionManager, this::getCreatedSessions).tags(this.tags).baseUnit("sessions").description("Total sessions created").register(registry);
        FunctionCounter.builder((String)"undertow.sessions.expired", (Object)this.sessionManager, this::getExpiredSessions).tags(this.tags).baseUnit("sessions").description("Total sessions expired").register(registry);
    }

    private void registerJmxMetrics(MeterRegistry registry) {
        this.registerJmxMetricsIfAvailable(":type=thread-pool,name=*", registry);
    }

    private void registerJmxMetricsIfAvailable(String objectNamePattern, MeterRegistry registry) {
        try {
            ObjectName pattern = new ObjectName("jboss.threads" + objectNamePattern);
            Set<ObjectName> objectNames = this.mBeanServer.queryNames(pattern, null);
            for (ObjectName objectName : objectNames) {
                this.registerJmxThreadPoolMetrics(objectName, registry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerJmxThreadPoolMetrics(ObjectName objectName, MeterRegistry registry) {
        Tags allTags = Tags.concat(this.tags, (Iterable)Tags.of((String)"name", (String)this.getNameFromObjectName(objectName)));
        Gauge.builder((String)"undertow.threads.jmx.active", (Object)this.mBeanServer, s -> this.safeDouble(() -> {
            try {
                return s.getAttribute(objectName, "ActiveCount");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })).tags((Iterable)allTags).baseUnit("threads").description("Active threads from JMX").register(registry);
        Gauge.builder((String)"undertow.threads.jmx.pool.size", (Object)this.mBeanServer, s -> this.safeDouble(() -> {
            try {
                return s.getAttribute(objectName, "PoolSize");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })).tags((Iterable)allTags).baseUnit("threads").description("Thread pool size from JMX").register(registry);
    }

    private double getCoreWorkerPoolSize(XnioWorker worker) {
        return this.safeDouble(() -> this.xnioWorker.getMXBean().getCoreWorkerPoolSize());
    }

    private double getMaxWorkerPoolSize(XnioWorker worker) {
        return this.safeDouble(() -> this.xnioWorker.getMXBean().getMaxWorkerPoolSize());
    }

    private double getCurrentWorkerThreadCount(XnioWorker worker) {
        return this.safeDouble(() -> worker.getMXBean().getWorkerPoolSize());
    }

    private double getBusyWorkerThreadCount(XnioWorker worker) {
        return this.safeDouble(() -> worker.getMXBean().getBusyWorkerThreadCount());
    }

    private double getWorkerThreadUtilization(XnioWorker worker) {
        double current = this.getCurrentWorkerThreadCount(worker);
        double total = this.getCoreWorkerPoolSize(worker);
        if (total > 0.0 && !Double.isNaN(current) && !Double.isNaN(total)) {
            return current / total * 100.0;
        }
        return Double.NaN;
    }

    private double getWorkerQueueSize(XnioWorker worker) {
        return this.safeDouble(() -> worker.getMXBean().getWorkerQueueSize());
    }

    private double getActiveSessions(SessionManager manager) {
        if (manager.getStatistics() != null) {
            return this.safeDouble(() -> manager.getStatistics().getActiveSessionCount());
        }
        if (this.deployment != null && this.deployment.getSessionManager() != null) {
            return this.safeDouble(() -> this.deployment.getSessionManager().getActiveSessions().size());
        }
        return Double.NaN;
    }

    private double getMaxSessions(SessionManager manager) {
        if (manager.getStatistics() != null) {
            return this.safeDouble(() -> manager.getStatistics().getMaxActiveSessions());
        }
        return Double.NaN;
    }

    private double getCreatedSessions(SessionManager manager) {
        if (manager.getStatistics() != null) {
            return this.safeDouble(() -> manager.getStatistics().getCreatedSessionCount());
        }
        return Double.NaN;
    }

    private double getExpiredSessions(SessionManager manager) {
        if (manager.getStatistics() != null) {
            return this.safeDouble(() -> manager.getStatistics().getExpiredSessionCount());
        }
        return Double.NaN;
    }

    private double safeDouble(Supplier<Object> supplier) {
        try {
            Object result = supplier.get();
            if (result == null) {
                return Double.NaN;
            }
            if (result instanceof Number) {
                return ((Number)result).doubleValue();
            }
            return Double.parseDouble(result.toString());
        }
        catch (Exception e) {
            LOG.trace(e.getMessage(), (Throwable)e);
            return Double.NaN;
        }
    }

    private String getNameFromObjectName(ObjectName objectName) {
        String name = objectName.getKeyProperty("name");
        return name != null ? name.replace("\"", "") : "unknown";
    }

    @Override
    public void close() {
    }
}

