/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import java.util.Collection;
import org.apache.camel.health.HealthCheck;
import org.slf4j.Logger;

public final class CamelProbesHelper {
    private CamelProbesHelper() {
    }

    public static boolean checkProbeState(Collection<HealthCheck.Result> results, Logger log) {
        boolean isUp = true;
        for (HealthCheck.Result result : results) {
            if (HealthCheck.State.UP.equals((Object)result.getState())) continue;
            isUp = false;
            log.warn("Probe in group '{}', with id '{}' failed with message '{}'", new Object[]{result.getCheck().getGroup(), result.getCheck().getId(), result.getMessage().orElse("")});
            result.getError().ifPresent(error -> log.warn(error.getMessage(), error));
        }
        return isUp;
    }
}

