/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.commons.lang3.StringUtils;

public class JMXResource
implements IResource {
    private static final String ROOT_NAME = "mbean";
    private static final JMXResource ROOT_RESOURCE = new JMXResource();
    private final Level level;
    private final String name;
    private static final Set<Permission> JMX_PERMISSIONS = Sets.immutableEnumSet((Enum)Permission.AUTHORIZE, (Enum[])new Permission[]{Permission.DESCRIBE, Permission.EXECUTE, Permission.MODIFY, Permission.SELECT});

    private JMXResource() {
        this.level = Level.ROOT;
        this.name = null;
    }

    private JMXResource(String name) {
        this.name = name;
        this.level = Level.MBEAN;
    }

    public static JMXResource mbean(String name) {
        return new JMXResource(name);
    }

    public static JMXResource fromName(String name) {
        String[] parts = StringUtils.split((String)name, (char)'/');
        if (!parts[0].equals(ROOT_NAME) || parts.length > 2) {
            throw new IllegalArgumentException(String.format("%s is not a valid JMX resource name", name));
        }
        if (parts.length == 1) {
            return JMXResource.root();
        }
        return JMXResource.mbean(parts[1]);
    }

    @Override
    public String getName() {
        if (this.level == Level.ROOT) {
            return ROOT_NAME;
        }
        if (this.level == Level.MBEAN) {
            return String.format("%s/%s", ROOT_NAME, this.name);
        }
        throw new AssertionError();
    }

    public String getObjectName() {
        if (this.level == Level.ROOT) {
            throw new IllegalStateException(String.format("%s JMX resource has no object name", new Object[]{this.level}));
        }
        return this.name;
    }

    public static JMXResource root() {
        return ROOT_RESOURCE;
    }

    @Override
    public IResource getParent() {
        if (this.level == Level.MBEAN) {
            return JMXResource.root();
        }
        throw new IllegalStateException("Root-level resource can't have a parent");
    }

    @Override
    public boolean hasParent() {
        return !this.level.equals((Object)Level.ROOT);
    }

    @Override
    public boolean exists() {
        if (!this.hasParent()) {
            return true;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            return !mbs.queryNames(new ObjectName(this.name), null).isEmpty();
        }
        catch (MalformedObjectNameException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public Set<Permission> applicablePermissions() {
        return JMX_PERMISSIONS;
    }

    public String toString() {
        return this.level == Level.ROOT ? "<all mbeans>" : String.format("<mbean %s>", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JMXResource)) {
            return false;
        }
        JMXResource j = (JMXResource)o;
        return Objects.equal((Object)((Object)this.level), (Object)((Object)j.level)) && Objects.equal((Object)this.name, (Object)j.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.level, this.name});
    }

    static enum Level {
        ROOT,
        MBEAN;

    }
}

