/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.StreamingRepairTask;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.repair.ValidationManager;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.repair.messages.CleanupMessage;
import org.apache.cassandra.repair.messages.FailSession;
import org.apache.cassandra.repair.messages.FinalizeCommit;
import org.apache.cassandra.repair.messages.FinalizePromise;
import org.apache.cassandra.repair.messages.FinalizePropose;
import org.apache.cassandra.repair.messages.PrepareConsistentRequest;
import org.apache.cassandra.repair.messages.PrepareConsistentResponse;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.StatusRequest;
import org.apache.cassandra.repair.messages.StatusResponse;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.repair.messages.ValidationResponse;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.streaming.PreviewKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairMessageVerbHandler
implements IVerbHandler<RepairMessage> {
    public static RepairMessageVerbHandler instance = new RepairMessageVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(RepairMessageVerbHandler.class);

    private boolean isIncremental(UUID sessionID) {
        return ActiveRepairService.instance.consistent.local.isSessionInProgress(sessionID);
    }

    private PreviewKind previewKind(UUID sessionID) {
        ActiveRepairService.ParentRepairSession prs = ActiveRepairService.instance.getParentRepairSession(sessionID);
        return prs != null ? prs.previewKind : PreviewKind.NONE;
    }

    @Override
    public void doVerb(Message<RepairMessage> message) {
        RepairJobDesc desc = ((RepairMessage)message.payload).desc;
        try {
            switch (message.verb()) {
                case PREPARE_MSG: {
                    PrepareMessage prepareMessage = (PrepareMessage)message.payload;
                    logger.debug("Preparing, {}", (Object)prepareMessage);
                    if (!ActiveRepairService.verifyCompactionsPendingThreshold(prepareMessage.parentRepairSession, prepareMessage.previewKind)) {
                        this.sendFailureResponse(message);
                        return;
                    }
                    ArrayList<ColumnFamilyStore> columnFamilyStores = new ArrayList<ColumnFamilyStore>(prepareMessage.tableIds.size());
                    for (TableId tableId : prepareMessage.tableIds) {
                        ColumnFamilyStore columnFamilyStore = ColumnFamilyStore.getIfExists(tableId);
                        if (columnFamilyStore == null) {
                            this.logErrorAndSendFailureResponse(String.format("Table with id %s was dropped during prepare phase of repair", tableId), message);
                            return;
                        }
                        columnFamilyStores.add(columnFamilyStore);
                    }
                    ActiveRepairService.instance.registerParentRepairSession(prepareMessage.parentRepairSession, message.from(), columnFamilyStores, prepareMessage.ranges, prepareMessage.isIncremental, prepareMessage.timestamp, prepareMessage.isGlobal, prepareMessage.previewKind);
                    MessagingService.instance().send(message.emptyResponse(), message.from());
                    break;
                }
                case SNAPSHOT_MSG: {
                    logger.debug("Snapshotting {}", (Object)desc);
                    ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(desc.keyspace, desc.columnFamily);
                    if (cfs == null) {
                        this.logErrorAndSendFailureResponse(String.format("Table %s.%s was dropped during snapshot phase of repair %s", desc.keyspace, desc.columnFamily, desc.parentSessionId), message);
                        return;
                    }
                    ActiveRepairService.ParentRepairSession prs = ActiveRepairService.instance.getParentRepairSession(desc.parentSessionId);
                    TableRepairManager repairManager = cfs.getRepairManager();
                    if (prs.isGlobal) {
                        repairManager.snapshot(desc.parentSessionId.toString(), prs.getRanges(), false);
                    } else {
                        repairManager.snapshot(desc.parentSessionId.toString(), desc.ranges, true);
                    }
                    logger.debug("Enqueuing response to snapshot request {} to {}", (Object)desc.sessionId, (Object)message.from());
                    MessagingService.instance().send(message.emptyResponse(), message.from());
                    break;
                }
                case VALIDATION_REQ: {
                    ValidationRequest validationRequest = (ValidationRequest)message.payload;
                    logger.debug("Validating {}", (Object)validationRequest);
                    ColumnFamilyStore store = ColumnFamilyStore.getIfExists(desc.keyspace, desc.columnFamily);
                    if (store == null) {
                        logger.error("Table {}.{} was dropped during snapshot phase of repair {}", new Object[]{desc.keyspace, desc.columnFamily, desc.parentSessionId});
                        MessagingService.instance().send(Message.out(Verb.VALIDATION_RSP, new ValidationResponse(desc)), message.from());
                        return;
                    }
                    ActiveRepairService.instance.consistent.local.maybeSetRepairing(desc.parentSessionId);
                    Validator validator = new Validator(desc, message.from(), validationRequest.nowInSec, this.isIncremental(desc.parentSessionId), this.previewKind(desc.parentSessionId));
                    ValidationManager.instance.submitValidation(store, validator);
                    break;
                }
                case SYNC_REQ: {
                    SyncRequest request = (SyncRequest)message.payload;
                    logger.debug("Syncing {}", (Object)request);
                    StreamingRepairTask task = new StreamingRepairTask(desc, request.initiator, request.src, request.dst, request.ranges, this.isIncremental(desc.parentSessionId) ? desc.parentSessionId : null, request.previewKind, request.asymmetric);
                    task.run();
                    break;
                }
                case CLEANUP_MSG: {
                    logger.debug("cleaning up repair");
                    CleanupMessage cleanup = (CleanupMessage)message.payload;
                    ActiveRepairService.instance.removeParentRepairSession(cleanup.parentRepairSession);
                    MessagingService.instance().send(message.emptyResponse(), message.from());
                    break;
                }
                case PREPARE_CONSISTENT_REQ: {
                    ActiveRepairService.instance.consistent.local.handlePrepareMessage(message.from(), (PrepareConsistentRequest)message.payload);
                    break;
                }
                case PREPARE_CONSISTENT_RSP: {
                    ActiveRepairService.instance.consistent.coordinated.handlePrepareResponse((PrepareConsistentResponse)message.payload);
                    break;
                }
                case FINALIZE_PROPOSE_MSG: {
                    ActiveRepairService.instance.consistent.local.handleFinalizeProposeMessage(message.from(), (FinalizePropose)message.payload);
                    break;
                }
                case FINALIZE_PROMISE_MSG: {
                    ActiveRepairService.instance.consistent.coordinated.handleFinalizePromiseMessage((FinalizePromise)message.payload);
                    break;
                }
                case FINALIZE_COMMIT_MSG: {
                    ActiveRepairService.instance.consistent.local.handleFinalizeCommitMessage(message.from(), (FinalizeCommit)message.payload);
                    break;
                }
                case FAILED_SESSION_MSG: {
                    FailSession failure = (FailSession)message.payload;
                    ActiveRepairService.instance.consistent.coordinated.handleFailSessionMessage(failure);
                    ActiveRepairService.instance.consistent.local.handleFailSessionMessage(message.from(), failure);
                    break;
                }
                case STATUS_REQ: {
                    ActiveRepairService.instance.consistent.local.handleStatusRequest(message.from(), (StatusRequest)message.payload);
                    break;
                }
                case STATUS_RSP: {
                    ActiveRepairService.instance.consistent.local.handleStatusResponse(message.from(), (StatusResponse)message.payload);
                    break;
                }
                default: {
                    ActiveRepairService.instance.handleMessage(message);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Got error, removing parent repair session");
            if (desc != null && desc.parentSessionId != null) {
                ActiveRepairService.instance.removeParentRepairSession(desc.parentSessionId);
            }
            throw new RuntimeException(e);
        }
    }

    private void logErrorAndSendFailureResponse(String errorMessage, Message<?> respondTo) {
        logger.error(errorMessage);
        this.sendFailureResponse(respondTo);
    }

    private void sendFailureResponse(Message<?> respondTo) {
        Message<RequestFailureReason> reply = respondTo.failureResponse(RequestFailureReason.UNKNOWN);
        MessagingService.instance().send(reply, respondTo.from());
    }
}

